/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRow;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PortalTableRowImpl
extends TableRowImpl
implements PortalTableRow,
SitesSynchronizeable {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public PortalTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.PORTAL, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getIPAddress() + ":" + this.getPort();
        return changedValues;
    }

    @Override
    protected String canBeDeleted() {
        IPTableRowImpl ipTableRow = this.getParentVSwitch().getIPTableRow(this.getIPAddress());
        if (this.getParentVSwitch().isUnderTakeover() && ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
            return "You cannot remove portal on IP that is " + ipTableRow.getActivity();
        }
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIPAddress() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
    }

    @Override
    public Integer getPort() {
        BigInteger port = (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_PORTAL_PORT);
        return port == null ? null : new Integer(port.toString());
    }

    @Override
    public IscsiPortalRolesConstant getRole() {
        IscsiPortalRolesConstant role = (IscsiPortalRolesConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_PORTAL_ROLE);
        return role;
    }

    public boolean isIpTableRowExist() {
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        if (parentVSwitch == null) {
            return false;
        }
        return parentVSwitch.getIPTableRow(this.getIPAddress()) != null;
    }

    @Override
    public Integer getTag() {
        Integer retTag = null;
        VSwitchImpl parentVSwitch = this.getParentVSwitch();
        if (parentVSwitch != null) {
            IPTableRowImpl ipTableRow = parentVSwitch.getIPTableRow(this.getIPAddress());
            if (ipTableRow == null) {
                String msg = "The ipTableRow should never be null in: " + this.getClassId() + " ip: " + this.getIPAddress() + ". " + this;
                theLogger.error(SrLogCategories.ERROR, new Object[]{msg});
                throw new IllegalStateException(msg);
            }
            if (ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.getDescriptionName())) {
                retTag = parentVSwitch.getSwitchID();
            } else if (ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
                Integer activeVSwitchTag = parentVSwitch.getSwitchID();
                retTag = activeVSwitchTag == 1 ? new Integer(0) : new Integer(1);
            } else {
                VSwitchImpl otherVSwitch = this.getCluster().getOtherVSwitch(parentVSwitch);
                if (otherVSwitch != null) {
                    retTag = otherVSwitch.getSwitchID();
                }
            }
        }
        return retTag;
    }

    public boolean isTargetRole() {
        IscsiPortalRolesConstant role = this.getRole();
        return role.equals((Object)IscsiPortalRolesConstant.TARGET) || role.equals((Object)IscsiPortalRolesConstant.TARGET_AND_INITIATOR);
    }

    @Override
    public SrFuture<Void> synchronizeNewElementOnRemoteCluster(ClusterImpl remoteCluster) {
        final SrFuture retFuture = new SrFuture("PortalTableRowImpl.synchronizeNewElementOnRemoteCluster");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (this.isTargetRole() && remoteCluster.isDiscoverCompleted()) {
            Vector<ISCSITargetImpl> localTargets = this.getCluster().getStorage().getTargetList();
            for (ISCSITargetImpl target : localTargets) {
                VSwitchImpl vswitch = target.getExposedOnVSwitchObject();
                ArrayList<PortalTableRowImpl> targetPortals = this.getCluster().getAllTargetPortals(vswitch);
                ISCSIRemoteTargetImpl equivalentRemoteTarget = this.getCluster().findLocalTargetInRemoteCluster(remoteCluster, target.getName());
                if (equivalentRemoteTarget == null || !targetPortals.contains(this)) continue;
                VSwitchImpl[] createOnVSwitch = equivalentRemoteTarget.getConnectedVSwitches();
                midFutures.add(equivalentRemoteTarget.createLocalPortalInRemoteCluster(this, createOnVSwitch));
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public void synchronizeChangeElementOnRemoteCluster(ClusterImpl remoteCluster, HashMap changedValues) throws RemoteException {
    }

    @Override
    public SrFuture<Void> synchronizePreRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        final SrFuture retFuture = new SrFuture("PortalTableRowImpl.synchronizePreRemoveElementOnRemoteCluster");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (this.isTargetRole()) {
            Vector<ISCSITargetImpl> localTargets = this.getCluster().getStorage().getTargetList();
            for (ISCSITargetImpl target : localTargets) {
                ISCSIRemoteTargetImpl equivalentRemoteTarget = this.getCluster().findLocalTargetInRemoteCluster(remoteCluster, target.getName());
                if (equivalentRemoteTarget == null) continue;
                try {
                    ISCSIRemoteTargetPortal[] remotePortals = equivalentRemoteTarget.getISCSIPortals();
                    for (int index = 0; index < remotePortals.length; ++index) {
                        ISCSIRemoteTargetPortal remotePortal = remotePortals[index];
                        if (!this.equivalentTo(remotePortal)) continue;
                        midFutures.add(remotePortal.deleteElement());
                    }
                }
                catch (IllegalValueException ive) {
                }
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> synchronizeDiscoveryElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        return this.synchronizeNewElementOnRemoteCluster(remoteCluster);
    }

    @Override
    public void synchronizePostRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
    }

    private boolean equivalentTo(ISCSIRemoteTargetPortal remotePortal) throws RemoteException {
        String ip = remotePortal.getIPAddress();
        BigInteger port = remotePortal.getPort();
        Integer tag = remotePortal.getPortalGroupTag();
        return ip.equals(this.getIPAddress()) && port.intValue() == this.getPort().intValue() && tag.intValue() == this.getTag().intValue();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_PORTAL_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_PORTAL_ROLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NETWORK_CONFIG_INTERFACE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

