/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.vswitch.NeighborAlarmGenerator;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.Neighbor;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.SDNeighborStatusConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NeighborImpl
extends TableRowImpl
implements Neighbor {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private String ip = null;

    public NeighborImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.NEIGHBORE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.ip = this.getIPAddress();
        return changedValues;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_NAME);
    }

    @Override
    public String getIPAddress() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_IP_ADDRESS);
    }

    @Override
    public Long getLastKeepAliveReceived() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.NEIGHBOR_LAST_KEEPALIVE));
        ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().refreshTableFields(element));
        return (Long)this.getValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_LAST_KEEPALIVE);
    }

    private SDNeighborStatusConstant getStatusConst() {
        if ((SDNeighborStatusConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_STATUS) == null) {
            return SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_UNKNOWN;
        }
        return (SDNeighborStatusConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_STATUS);
    }

    private boolean isInStatus(SDNeighborStatusConstant status) {
        return this.getStatusConst().equals((Object)status);
    }

    public boolean isDead() {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_DEAD);
    }

    public boolean isAlive() {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_ALIVE);
    }

    public boolean isMissConfigured() {
        return false;
    }

    public boolean isSuspicious() {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_SUSPICIOUS);
    }

    public boolean isUnknown() {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_UNKNOWN);
    }

    @Override
    public String getStatus() throws RemoteException {
        return this.getStatusConst().toString();
    }

    @Override
    public long getTimeout() throws RemoteException {
        int timeout = ((SrInteger)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_TIMEOUT)).intValue();
        return Long.parseLong(Integer.toString(timeout));
    }

    @Override
    public int getNumberOfRetries() throws RemoteException {
        return ((SrInteger)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_RETRIES)).intValue();
    }

    @Override
    public int getSnmpPort() throws RemoteException {
        return ((SrInteger)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_PORT)).intValue();
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Neighbor) {
            return ((NeighborImpl)obj).ip.equals(this.ip);
        }
        return false;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return NeighborAlarmGenerator.getInstance();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_IP_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_LAST_KEEPALIVE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_RETRIES, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NEIGHBOR_TIMEOUT, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

