/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.Manager;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ManagerImpl
extends TableRowImpl
implements Manager {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static SrLogger theLogger;
    private String ip = null;

    public ManagerImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SNMP_MANAGER, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.ip = this.getIPAddress();
        return changedValues;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String writeCommunity;
        String readCommunity;
        Boolean trapEnable;
        Integer trapPort = (Integer)parameterList.get(ClientParameterCode.MANAGER_TRAP_PORT);
        if (trapPort != null) {
            parameterList.put(ClientParameterCode.MANAGER_TRAP_PORT, new SrInteger(trapPort));
        }
        if ((trapEnable = (Boolean)parameterList.get(ClientParameterCode.MANAGER_TRAP_ENABLE)) != null) {
            parameterList.put(ClientParameterCode.MANAGER_TRAP_ENABLE, new SrBoolean(trapEnable.booleanValue()));
        }
        if ((readCommunity = (String)parameterList.get(ClientParameterCode.MANAGER_READ_COMMUNITY)) != null) {
            parameterList.put(ClientParameterCode.MANAGER_READ_COMMUNITY, new SrString(readCommunity));
        }
        if ((writeCommunity = (String)parameterList.get(ClientParameterCode.MANAGER_WRITE_COMMUNITY)) != null) {
            parameterList.put(ClientParameterCode.MANAGER_WRITE_COMMUNITY, new SrString(writeCommunity));
        }
        return null;
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIPAddress() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.MANAGER_IP_ADDRESS);
    }

    @Override
    public String getReadCommunity() {
        String readCommunity = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_READ_COMMUNITY);
        if (readCommunity == null || readCommunity.equals("")) {
            String debugMsg = "Read Community (2) of " + this + " is empty (" + readCommunity + ") !!!! (class: " + this.getClass() + ")";
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{debugMsg});
            Thread.dumpStack();
        }
        return readCommunity;
    }

    @Override
    public String getWriteCommunity() {
        String writeCommunity = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_WRITE_COMMUNITY);
        if (writeCommunity == null || writeCommunity.equals("")) {
            String debugMsg = "Write Community (2) of " + this + " is empty (" + writeCommunity + ") !!!! (class: " + this.getClass() + ")";
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{debugMsg});
            Thread.dumpStack();
        }
        return writeCommunity;
    }

    @Override
    public Integer getTrapPort() {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_TRAP_PORT);
    }

    @Override
    public Boolean isTrapEnable() {
        boolean result = (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_TRAP_ENABLE) == 1;
        return new Boolean(result);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Manager) {
            return ((ManagerImpl)obj).ip.equals(this.ip);
        }
        return false;
    }

    public boolean isEqualTo(String[] ips, Integer trapPort) {
        Integer managerTrapPort = this.getTrapPort();
        String managerIp = this.getIPAddress();
        if (managerTrapPort == null || trapPort == null || trapPort.compareTo(managerTrapPort) == 0) {
            for (int i = 0; i < ips.length; ++i) {
                if (!ips[i].equals(managerIp)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.MANAGER_IP_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.MANAGER_READ_COMMUNITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.MANAGER_TRAP_ENABLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.MANAGER_TRAP_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.MANAGER_WRITE_COMMUNITY, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

