/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.IfJumboMtuConstant;
import com.sanrad.nms.server.util.types.constants.IfOperStatConstant;
import com.sanrad.nms.server.util.types.constants.IfResetConstant;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InterfaceTableRowImpl
extends TableRowImpl
implements InterfaceTableRow {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static String theCannotResetInterfaceType;
    private String equalsValue = null;
    private static SrLogger theLogger;
    private String name = null;

    public InterfaceTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.INTERFACE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    protected InterfaceTableRowImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getAlias();
        Object nameValue = this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_NAME);
        if (nameValue != null) {
            this.name = nameValue.toString();
        }
        return changedValues;
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        Integer resetVal;
        IfJumboMtuConstant ifJumboMtu;
        String alias = (String)parameterList.get(ClientParameterCode.INTERFACE_ALIAS);
        if (alias != null) {
            String errorMsg = AliasObjectValidator.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            VSwitchImpl vSwitch = this.getParentVSwitch();
            if (vSwitch.isInterfaceAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.INTERFACE_ALIAS, new SrString(alias));
        }
        if ((ifJumboMtu = (IfJumboMtuConstant)parameterList.get(ClientParameterCode.INTERFACE_JUMBO_MTU)) != null) {
            parameterList.put(ClientParameterCode.INTERFACE_JUMBO_MTU, new SrInteger(ifJumboMtu.intValue()));
        }
        if ((resetVal = (Integer)parameterList.get(ClientParameterCode.INTERFACE_RESET)) != null) {
            if (this.isEthernet() || this.isFC() || this.isPSCSI()) {
                parameterList.put(ClientParameterCode.INTERFACE_RESET, IfResetConstant.getIfResetStat((Integer)resetVal));
            } else {
                Object[] msgArgs = new Object[]{this.getAlias(), this.getType()};
                return MessageFormat.format(theCannotResetInterfaceType, msgArgs);
            }
        }
        return null;
    }

    @Override
    public String getAlias() {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_ALIAS);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.IF_ALIAS);
    }

    @Override
    public String getPhysicalAddress() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.IF_PHYSICAL_ADDRESS);
    }

    @Override
    public String getDescriptor() {
        Object value = this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_DESCRIPTION);
        return value == null ? null : value.toString();
    }

    @Override
    public IfJumboMtuConstant getJumboMtu() {
        Integer val = (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_JUMBO_MTU);
        if (val == null) {
            return null;
        }
        IfJumboMtuConstant retVal = IfJumboMtuConstant.valueOf((int)val);
        theLogger.logAndAssert(SrLogCategories.ILLEGAL_STATE, retVal != null, new Object[]{"The MTU value ", (int)val, " for interface ", this.getName(), " is not valid"});
        return retVal;
    }

    @Override
    public String getName() {
        Object nameVal;
        if (this.name == null && (nameVal = this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_NAME)) != null) {
            return nameVal.toString();
        }
        return this.name;
    }

    @Override
    public BigInteger getHighSpeedMbits() {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_HIGH_SPEED);
    }

    private boolean isOfType(IANAifTypeConstant aType) {
        IANAifTypeConstant type = (IANAifTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.IF_TYPE);
        return type != null && type.equals((Object)aType);
    }

    public boolean isFC() {
        return this.isOfType(IANAifTypeConstant.IANA_IF_TYPE_FC);
    }

    public boolean isPSCSI() {
        return this.isOfType(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI);
    }

    public boolean isRS232() {
        return this.isOfType(IANAifTypeConstant.IANA_IF_TYPE_RS232);
    }

    public boolean isUnknown() {
        return this.isOfType(IANAifTypeConstant.IANA_IF_TYPE_UNKNOWN);
    }

    public boolean isEthernet() {
        return this.isOfType(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET);
    }

    @Override
    public String getType() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.IF_TYPE);
    }

    @Override
    public String getOperationalStatus() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.IF_OPER_STAT);
    }

    public boolean isLinkDown() {
        IfOperStatConstant status = (IfOperStatConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.IF_OPER_STAT);
        return status != null && status.equals((Object)IfOperStatConstant.IF_OPER_STAT_DOWN);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof InterfaceTableRow && this.equalsValue != null) {
            return this.equalsValue.equals(((InterfaceTableRowImpl)obj).equalsValue);
        }
        return false;
    }

    @Override
    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        return null;
    }

    public boolean isManagementInterface() {
        String mgmtName = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.MGMT_INTERFACE_PORT_NAME);
        return this.getName().equals(mgmtName);
    }

    @Override
    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws IllegalValueException {
        CommKeyClassId[] vswitches = this.getConnectedVswitchesData();
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vswitches));
    }

    static {
        theCannotResetInterfaceType = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.CANNOT_RESET_INTERFACE_BECAUSE_TYPE);
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.IF_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_DESCRIPTION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_HIGH_SPEED, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_OPER_STAT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_PHYSICAL_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IF_JUMBO_MTU, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

