/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class IPTableRowImpl
extends TableRowImpl
implements IPTableRow {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static SrLogger theLogger;

    public IPTableRowImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.NETWORK_CONFIGURATION, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getIPAddress();
        return changedValues;
    }

    public SrFuture<Void> readState() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_ACTIVITY));
        return this.getParentVSwitch().refreshFields(element);
    }

    @Override
    protected String canBeDeleted() {
        Vector<IPTableRowImpl> ips;
        if (this.getIPAddress().equals(this.getParentVSwitch().getMgmIPAddr())) {
            return "You cannot delete management ip " + this.getIPAddress();
        }
        if (this.getParentVSwitch().getPortalTableRows(this.getIPAddress()).size() > 0) {
            return "You cannot delete an ip (" + this.getIPAddress() + ") that has a portal on it. Please remove the portal first";
        }
        if (this.getParentVSwitch().getGwIPRouteTableRows(this).size() > 0 && (ips = this.getParentVSwitch().getIPsOfInterfaceAndSameSubnet(this.getInterface(), this)).size() == 1) {
            return "You cannot delete last ip (" + this.getIPAddress() + ") that has an IP route on it. Please delete the IP route first";
        }
        if (this.getParentVSwitch().isUnderTakeover() && this.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
            return "You cannot remove " + this.getActivity() + " IP";
        }
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIPAddress() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_IP_ADDRESS);
    }

    @Override
    public String getIPMask() {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_NET_MASK);
    }

    @Override
    public String getActivity() {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{ClassID.VSWITCH, " ", this.getParentVSwitch(), " - trying to get NetConfigActivityConstant of " + this.getIPAddress()});
        NetConfigActivityConstant activity = (NetConfigActivityConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_ACTIVITY);
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{ClassID.VSWITCH, " ", this.getParentVSwitch(), " - NetConfigActivityConstant of ", this.getIPAddress(), " is ", activity});
        if (activity != null) {
            return activity.toString();
        }
        theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Null value for Activiy in IP Table Row for ", this.getIPAddress()});
        return NetConfigActivityConstant.NET_CONFIG_ACTIVITY_UNKNOWN.toString();
    }

    @Override
    public InterfaceTableRowImpl getInterface() {
        String interfaceName = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_INTERFACE);
        InterfaceTableRowImpl interfaceTableRow = this.getParentVSwitch().getInterfaceTableRowByName(interfaceName);
        return interfaceTableRow;
    }

    public SrFuture<Void> setActive() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_ACTIVITY, (Object)NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE));
        return DataMgrAdapter.getInstance().changeElement(element);
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.NETWORK_CONFIG_IP_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NETWORK_CONFIG_NET_MASK, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NETWORK_CONFIG_ACTIVITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.NETWORK_CONFIG_INTERFACE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

