/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.vswitch.IPTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;
import java.util.Vector;

public class IPRouteTableRowValidator
extends LogicObjectValidator {
    private VSwitchImpl vSwitch;
    private String destIp;
    private String destMask;
    private String gateway;
    private String interfaceName;

    public IPRouteTableRowValidator(VSwitchImpl vSwitch, String destIp, String destMask, String gateway, String interfaceAlias) {
        this.vSwitch = vSwitch;
        this.destIp = destIp;
        this.destMask = destMask;
        this.gateway = gateway;
        this.interfaceName = interfaceAlias;
    }

    private boolean hasIPActive(InterfaceTableRowImpl interfaceRow) {
        for (IPTableRowImpl ipRow : this.vSwitch.getIPsOfInterface(interfaceRow)) {
            if (!ipRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() throws RemoteException {
        try {
            if (!NetUtil.isNetworkIpValid((String)this.destIp) && !this.destIp.equals("0.0.0.0")) {
                this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.destIp));
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.destIp));
            return false;
        }
        try {
            if (!NetUtil.isNetworkIpValid((String)this.gateway)) {
                this.setErrorMsg(ErrorMessage.GATEWAY_IS_NOT_VALID.getMessage(this.gateway));
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            this.setErrorMsg(ErrorMessage.GATEWAY_IS_NOT_VALID.getMessage(this.gateway));
            return false;
        }
        if (!NetUtil.isMaskValid((String)this.destMask)) {
            this.setErrorMsg(ErrorMessage.MASK_IS_NOT_VALID.getMessage(this.destMask));
            return false;
        }
        if (this.vSwitch.getIPRouteTableRow(this.destIp, this.gateway, this.interfaceName) != null) {
            this.setErrorMsg(ClassID.IP_ROUTE + " (dest. ip " + this.destIp + "; gateway " + this.gateway + ") already exists in " + ClassID.VSWITCH + " " + this.vSwitch.getName() + "; interface " + this.interfaceName);
            return false;
        }
        String subnet = NetUtil.getSubnet((String)this.destIp, (String)this.destMask);
        if (this.vSwitch.getIPRouteTableRow(subnet, this.interfaceName) != null) {
            this.setErrorMsg(ClassID.IP_ROUTE + " (dest. subnet " + subnet + ") already exists in " + ClassID.VSWITCH + " " + this.vSwitch.getName() + "; interface " + this.interfaceName);
            return false;
        }
        if (!NetUtil.isValidRoute((String)this.destIp, (String)this.destMask)) {
            this.setErrorMsg("The mask " + this.destMask + " does not match the IP address " + this.destIp + ".  Please change either the mask or the IP address");
            return false;
        }
        InterfaceTableRowImpl interfaceRow = this.vSwitch.getInterfaceTableRowByName(this.interfaceName);
        if (interfaceRow == null) {
            this.setErrorMsg(ClassID.INTERFACE + " " + interfaceRow.getAlias() + " not found");
            return false;
        }
        if (!interfaceRow.isEthernet()) {
            this.setErrorMsg(ClassID.INTERFACE + " is of type " + interfaceRow.getType() + ".  It should be of type " + IANAifTypeConstant.IANA_IF_TYPE_ETHERNET.toDisplayString());
            return false;
        }
        Vector<IPTableRowImpl> ips = this.vSwitch.getIPsOfInterface(interfaceRow);
        boolean ipMatchGateway = false;
        for (IPTableRowImpl ip : ips) {
            if (!NetUtil.isSameSubnet((String)ip.getIPAddress(), (String)ip.getIPMask(), (String)this.gateway, (String)ip.getIPMask())) continue;
            ipMatchGateway = true;
            break;
        }
        if (!ipMatchGateway) {
            this.setErrorMsg("There is no active ip on " + ClassID.INTERFACE + " " + interfaceRow.getAlias() + " that matches gateway " + this.gateway + " subnet");
            return false;
        }
        return true;
    }
}

