/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.validators.VirtualVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.Vector;

public class VolumeOperationValidator
extends VirtualVolumeValidator {
    protected VolumeNodeImpl source;
    protected VolumeNodeImpl destination = null;
    protected VolumeNodeImpl[] multiDestination = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    public VolumeOperationValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object child, VolumeManager volumeMgr) {
        super(cluster, ClassID.VOLUME_OPERATION, alias, child, volumeMgr);
        this.source = source;
    }

    public VolumeOperationValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object child, VolumeManager volumeMgr, VolumeNodeImpl destinationVolume) {
        this(cluster, source, alias, child, volumeMgr);
        this.destination = destinationVolume;
    }

    public VolumeOperationValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object child, VolumeManager volumeMgr, VolumeNodeImpl[] destinationVolumes) {
        this(cluster, source, alias, child, volumeMgr);
        this.multiDestination = destinationVolumes;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.source.isIllegalDownHierarchy() || this.source.isIllegalUpHierarchy()) {
            String msg = this.source.getAlias();
            this.setErrorMsg(ErrorMessage.ILLEGAL_VOLUME_IN_HIERARCHY.getMessage(msg));
            return false;
        }
        if (this.isExposedOnDisconnectedVswitch()) {
            return false;
        }
        CopyOperationManagerImpl copyMgr = this.cluster.getCopyOperManager();
        CopyOperationImpl oper = copyMgr.getActiveCopyForNode(this.source.getCommKeyClassId());
        if (oper != null) {
            this.setErrorMsg("Operation cannot be performed. " + this.source.getClassId() + " " + this.source + " is a part of active " + oper.getRestartType());
            return false;
        }
        if (this.destination != null) {
            oper = copyMgr.getActiveCopyForNode(this.destination.getCommKeyClassId());
            if (oper != null) {
                this.setErrorMsg("Operation cannot be performed. " + this.destination.getClassId() + " " + this.destination + " is a part of active " + oper.getRestartType());
                return false;
            }
        } else if (this.multiDestination != null) {
            for (int i = 0; i < this.multiDestination.length; ++i) {
                VolumeNodeImpl dst = this.multiDestination[i];
                oper = copyMgr.getActiveCopyForNode(dst.getCommKeyClassId());
                if (oper == null) continue;
                this.setErrorMsg("Operation cannot be performed. " + dst.getClassId() + " " + dst + " is a part of active " + oper.getRestartType());
                return false;
            }
        }
        return true;
    }

    @Override
    public VSwitchImpl[] forWhichVswitchIsValid() throws RemoteException {
        if (!this.isValid()) {
            return null;
        }
        return this.source.getConnectedVSwitches();
    }

    public CommKeyClassId[] forWhichVswitchIsValidData(CommKeyClassId[] initialList) throws RemoteException {
        if (initialList == null) {
            return this.forWhichVswitchIsValidData();
        }
        CommKeyClassId[] validList = this.forWhichVswitchIsValidData();
        Vector<CommKeyClassId> finalList = new Vector<CommKeyClassId>();
        for (int i = 0; i < initialList.length; ++i) {
            for (int j = 0; j < validList.length; ++j) {
                if (!validList[j].equals((Object)initialList[i])) continue;
                finalList.add(initialList[i]);
            }
        }
        CommKeyClassId[] retVal = new CommKeyClassId[finalList.size()];
        finalList.toArray(retVal);
        return retVal;
    }

    public CommKeyClassId[] forWhichVswitchIsValidData() throws RemoteException {
        VSwitchImpl[] valid = this.forWhichVswitchIsValid();
        if (valid == null) {
            return new CommKeyClassId[0];
        }
        CommKeyClassId[] validData = new CommKeyClassId[valid.length];
        for (int i = 0; i < valid.length; ++i) {
            validData[i] = valid[i].getCommKeyClassId();
        }
        return validData;
    }

    protected boolean isExposedOnVSwitchButLuNotExistOnIt() {
        if (!this.source.isExposed()) {
            return false;
        }
        VSwitchImpl exposedOnVswitch = this.source.getExposedOnVSwitch();
        LUImpl lu = this.source.getHeadLU();
        VSwitchImpl[] connectedVswitches = lu.getConnectedVSwitches();
        for (int i = 0; i < connectedVswitches.length; ++i) {
            if (!((Object)connectedVswitches[i]).equals(exposedOnVswitch)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExposedOnDisconnectedVswitch() {
        try {
            if (!this.source.isExposed()) {
                return false;
            }
            VSwitchImpl exposedOnVswitch = this.source.getExposedOnVSwitch();
            if (exposedOnVswitch != null && !exposedOnVswitch.isConnected()) {
                return true;
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
        }
        return false;
    }
}

