/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VirtualVolumeValidator;
import com.sanrad.nms.server.util.ClassID;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public class StripeVolumeValidator
extends VirtualVolumeValidator {
    private BigInteger stripeSize;

    public StripeVolumeValidator(ClusterImpl cluster, String alias, Vector children, BigInteger stripeSize, VolumeManager volumeMgr) {
        super(cluster, ClassID.STRIPE_VOLUME, alias, children, volumeMgr);
        this.stripeSize = stripeSize;
    }

    @Override
    public boolean isValid() throws RemoteException {
        BigInteger accessibleSpace = ((VolumeNode)((List)this.children).get(0)).getAccessibleSpace();
        for (VolumeNode child : (List)this.children) {
            if (((VolumeNodeImpl)child).isDROfflineLocalCopy()) {
                this.setErrorMsg(ErrorMessage.CANNOT_REMOVE_CHILD_VOLUME_IS_PART_OF_COPY_OPER.getMessage(this.stripeSize.toString() + " Bytes"));
            }
            if (child.getAccessibleSpace().compareTo(this.stripeSize) == 1) continue;
            this.setErrorMsg(ErrorMessage.STRIPE_SIZE_IS_TOO_HIGH.getMessage(this.stripeSize.toString() + " Bytes"));
            return false;
        }
        int blockSize = ((VolumeNode)((List)this.children).get(0)).getBlockSize();
        BigInteger blkSize = new BigInteger(Integer.toString(blockSize));
        BigInteger limit = new BigInteger("2");
        if (this.stripeSize.divide(blkSize).compareTo(limit) != 1) {
            this.setErrorMsg("Stripe size should be at least " + limit.toString() + "KB");
            return false;
        }
        return super.isValid();
    }
}

