/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VirtualVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class JournalVolumeValidator
extends VirtualVolumeValidator {
    private VSwitchImpl m_vswitchActiveOn;
    private VSwitchImpl m_otherVswitch;
    private Integer m_thresholdPrecent;
    private boolean m_vswitchActiveOnChanged = false;
    private boolean m_createInActiveJournalOnly = false;

    public JournalVolumeValidator(ClusterImpl cluster, String volAlias, Integer threshold, List<VolumeNodeImpl> children, boolean vswitchActiveOnChanged, VSwitchImpl vswitchActiveOn, VSwitchImpl vswitchInActiveOn, VolumeManager volumeMgr) {
        super(cluster, ClassID.JOURNAL_VOLUME, volAlias, children, volumeMgr);
        this.m_thresholdPrecent = threshold;
        this.m_vswitchActiveOnChanged = vswitchActiveOnChanged;
        this.m_vswitchActiveOn = vswitchActiveOn;
        this.m_otherVswitch = vswitchInActiveOn;
        this.m_createInActiveJournalOnly = this.m_vswitchActiveOn == null && this.m_otherVswitch != null;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (!super.isValid() && !this.isNotEnoughChildren()) {
            return false;
        }
        if (this.isChildStorageMissing()) {
            return false;
        }
        if (this.m_thresholdPrecent == null) {
            this.setErrorMsg("Journal volume threshold precentage is missing for the new volume");
            return false;
        }
        if (this.m_vswitchActiveOn == null && !this.m_createInActiveJournalOnly) {
            this.setErrorMsg("Journal volume " + ClassID.VSWITCH + " activate on is missing for the new volume");
            return false;
        }
        if (this.m_thresholdPrecent < 6 || this.m_thresholdPrecent >= 100) {
            this.setErrorMsg(ErrorMessage.JOURNAL_THRESHOLD_INVALID.getMessage());
            return false;
        }
        List volChildren = (List)this.children;
        int i = volChildren.size();
        while (i-- > 0) {
            VolumeNode child = (VolumeNodeImpl)volChildren.get(i);
            if (this.m_vswitchActiveOn == null) continue;
            if (this.m_vswitchActiveOn != null && !((LogicObjectImpl)((Object)child)).isKnownByVSwitch(this.m_vswitchActiveOn)) {
                StringBuffer sb = new StringBuffer("Cannot create Journal ");
                sb.append(this.alias).append(" active on " + ClassID.VSWITCH + " ").append(this.m_vswitchActiveOn.getName());
                sb.append(" ,the volume ").append(((VolumeNodeImpl)child).getAlias()).append(" is not defined this " + ClassID.VSWITCH);
                this.setErrorMsg(sb.toString());
                return false;
            }
            if (this.m_otherVswitch == null || !this.m_otherVswitch.isConnected() || ((LogicObjectImpl)((Object)child)).isKnownByVSwitch(this.m_otherVswitch)) continue;
            StringBuffer sb = new StringBuffer("Cannot create Journal ");
            sb.append(this.alias).append(" inactive on " + ClassID.VSWITCH + " ").append(this.m_vswitchActiveOn.getName());
            sb.append(" ,the volume ").append(((VolumeNodeImpl)child).getAlias()).append(" is not defined this " + ClassID.VSWITCH);
            this.setErrorMsg(sb.toString());
            return false;
        }
        for (VolumeNode child : (List)this.children) {
            if (child.getClassId().equals((Object)ClassID.TRANSPARENT_VOLUME)) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(ClassID.TRANSPARENT_VOLUME.toString()));
                return false;
            }
            if (child.getClassId().equals((Object)ClassID.SNAPSHOT_VOLUME)) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(ClassID.SNAPSHOT_VOLUME.toString()));
                return false;
            }
            if (child.getClassId().equals((Object)ClassID.JOURNAL_VOLUME)) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(ClassID.JOURNAL_VOLUME.toString()));
                return false;
            }
            if (child.isExposed()) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage("an exposed child"));
                return false;
            }
            if (!child.isNonFunctional()) continue;
            this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage("a nonfunctional child"));
            return false;
        }
        if (!this.m_createInActiveJournalOnly && this.isThereActiveJournalVolOnVSwitch(this.m_vswitchActiveOn.getName())) {
            this.setErrorMsg(ErrorMessage.VSWITCH_HAS_ACTIVE_JOURNAL.getMessage(this.m_vswitchActiveOn.getName()));
            return false;
        }
        VolumeNodeImpl child = (VolumeNodeImpl)((List)this.children).get(0);
        if (this.m_otherVswitch != null && child.isKnownByVSwitch(this.m_otherVswitch) && this.isThereInActiveJournalVolOnVSwitch(this.m_otherVswitch.getName())) {
            this.setErrorMsg(ErrorMessage.VSWITCH_HAS_INACTIVE_JOURNAL.getMessage(this.m_otherVswitch.getName()));
            return false;
        }
        return true;
    }

    @Override
    protected boolean isNotEnoughChildren() {
        return false;
    }

    public String isValid(HashMap parameterList) {
        if (this.alias != null) {
            String errMsg = JournalVolumeValidator.isAliasValid(this.alias);
            if (errMsg != null) {
                return errMsg;
            }
            if (this.volumeMgr.isAliasExist(this.alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias);
            }
            if (this.cluster.getStoragePool().isAliasExist(this.alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias);
            }
            parameterList.put(ClientParameterCode.VOLUME_ALIAS, new SrString(this.alias));
        }
        if (this.m_thresholdPrecent != null) {
            int val = this.m_thresholdPrecent;
            if (val < 6 || val > 100) {
                return ErrorMessage.JOURNAL_THRESHOLD_INVALID.getMessage();
            }
            parameterList.put(ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, new SrInteger(this.m_thresholdPrecent));
        }
        if (this.m_vswitchActiveOnChanged) {
            if (!this.m_createInActiveJournalOnly && this.isThereActiveJournalVolOnVSwitch(this.m_vswitchActiveOn.getName())) {
                return ErrorMessage.VSWITCH_HAS_ACTIVE_JOURNAL.getMessage(this.m_vswitchActiveOn.getName());
            }
            if (this.m_otherVswitch != null && this.isThereInActiveJournalVolOnVSwitch(this.m_otherVswitch.getName())) {
                return ErrorMessage.VSWITCH_HAS_INACTIVE_JOURNAL.getMessage(this.m_otherVswitch.getName());
            }
            parameterList.put(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, this.m_vswitchActiveOn.getCommKeyClassId());
        }
        return null;
    }

    private boolean isThereActiveJournalVolOnVSwitch(String vswitchName) {
        List<? extends VolumeNodeImpl> allJournalVolumesInCluster = this.cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
        for (int index = 0; index < allJournalVolumesInCluster.size(); ++index) {
            JournalVolumeImpl volume = (JournalVolumeImpl)allJournalVolumesInCluster.get(index);
            VSwitchImpl vswitchActiveOn = volume.getActiveOnVSwitch();
            if (vswitchActiveOn == null || !vswitchName.equals(vswitchActiveOn.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isThereInActiveJournalVolOnVSwitch(String vswitchName) {
        List<? extends VolumeNodeImpl> allJournalVolumesInCluster = this.cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
        for (int index = 0; index < allJournalVolumesInCluster.size(); ++index) {
            JournalVolumeImpl volume = (JournalVolumeImpl)allJournalVolumesInCluster.get(index);
            VSwitchImpl vswitchInctiveOn = volume.getInactiveOnVSwitch();
            if (vswitchInctiveOn == null) {
                return false;
            }
            if (!vswitchName.equals(vswitchInctiveOn.getName())) continue;
            return true;
        }
        return false;
    }
}

