/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VolumeOperationValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ExpandVolumeValidator
extends VolumeOperationValidator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public ExpandVolumeValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object children, VolumeManager volumeMgr) {
        super(cluster, source, alias, children, volumeMgr);
    }

    @Override
    public boolean isValid() throws RemoteException {
        return super.isValid();
    }

    @Override
    public CommKeyClassId[] forWhichVswitchIsValidData() {
        try {
            VSwitchImpl[] vSwitchesToSet = super.forWhichVswitchIsValid();
            if (vSwitchesToSet == null || vSwitchesToSet.length == 0) {
                return new CommKeyClassId[0];
            }
            ArrayList<VSwitchImpl> vSwitchToExpand = new ArrayList<VSwitchImpl>();
            for (int i = 0; i < vSwitchesToSet.length; ++i) {
                if (!this.source.isInState(vSwitchesToSet[i], (SrType)VolumeStateConstant.VOLUME_STATE_EXPANDABLE) || !vSwitchesToSet[i].isConnected()) continue;
                vSwitchToExpand.add(vSwitchesToSet[i]);
            }
            if (vSwitchToExpand.size() == 0) {
                return new CommKeyClassId[0];
            }
            CommKeyClassId[] vSwitches = new CommKeyClassId[vSwitchToExpand.size()];
            for (int i = 0; i < vSwitches.length; ++i) {
                vSwitches[i] = ((VSwitchImpl)vSwitchToExpand.get(i)).getCommKeyClassId();
            }
            return vSwitches;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            return new CommKeyClassId[0];
        }
    }
}

