/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.AddChildValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.HashMap;

public class AddMirrorValidator
extends AddChildValidator {
    public AddMirrorValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object child, VolumeManager volumeMgr, VolumeNodeImpl newChild) {
        super(cluster, source, alias, child, volumeMgr, newChild);
        this.MAX_NUM_OF_CHILDREN = Server.CONSTANSTS_BUNDLE.getIntResource((BundleKeysInterface)SrConstantsBundleKeys.VOLUME_MAX_NUM_OF_MIRROR_CHILDREN);
    }

    @Override
    public VSwitchImpl[] forWhichVswitchIsValid() throws RemoteException {
        VSwitchImpl[] validVs = super.forWhichVswitchIsValid();
        if (validVs != null && validVs.length > 0) {
            if (this.destination.getAccessibleSpace().longValue() < this.source.getAccessibleSpace().longValue()) {
                String[] msg = new String[]{this.destination.getAlias(), this.source.getAlias()};
                this.setErrorMsg(ErrorMessage.NEW_MIRROR_CHILD_HAS_SMALL_CAPACITY.getMessage(msg));
                return null;
            }
            if (this.source instanceof VolumeImpl) {
                if (this.source instanceof JournalVolumeImpl) {
                    String[] msg = new String[]{this.destination.getAlias(), " ", this.source.getAlias()};
                    this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(msg));
                    return null;
                }
                VolumeImpl sourceVol = (VolumeImpl)this.source;
                if (sourceVol.isInconsistent()) {
                    if (this.source instanceof MirrorVolumeImpl) {
                        HashMap<Object, CommKeyClassId[]> childrenListByVswitch = sourceVol.getChildrenCommKeyClassIdListByVSwitch();
                        for (Object key : childrenListByVswitch.keySet()) {
                            if (!(key instanceof VSwitchImpl) || childrenListByVswitch.get(key).length == 0) continue;
                            VSwitchImpl[] vSwitchToSet = new VSwitchImpl[]{this.cluster.getOtherVSwitch((VSwitchImpl)key)};
                            for (int i = 0; i < validVs.length; ++i) {
                                if (!validVs[i].equals(vSwitchToSet[0])) continue;
                                return vSwitchToSet;
                            }
                        }
                    }
                    String msg = sourceVol.getAlias();
                    this.setErrorMsg(ErrorMessage.VOLUME_INCONSISTANT.getMessage(msg));
                    return null;
                }
            }
        }
        return validVs;
    }
}

