/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.snapshot;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotSchedulerImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.AllocationPolicy;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SnapshotSchedulerMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl myCluster;
    private ArrayList<SnapshotSchedulerImpl> mySnapshotSchedulers = new ArrayList();

    public SnapshotSchedulerMgr(ClusterImpl aCluster) {
        Util.validateInputNotNull((Object)aCluster, (String)"Cluster");
        this.myCluster = aCluster;
    }

    public void clear() {
        this.mySnapshotSchedulers.clear();
    }

    private SnapshotSchedulerImpl findSnapshotScheduler(ConfigElementData aCED) {
        CommKeyClassId sourceVolId = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        Util.validateInputNotNull((Object)sourceVolId, (String)"Source volume ID");
        for (SnapshotSchedulerImpl scheduler : this.mySnapshotSchedulers) {
            VolumeNodeImpl sourceVolume = scheduler.getSourceVolume();
            if (sourceVolume == null || !sourceVolId.equals((Object)sourceVolume.getCommKeyClassId())) continue;
            return scheduler;
        }
        return null;
    }

    private SnapshotSchedulerImpl getSnapshotScheduler(CommKeyClassId aSchedulerId) {
        Util.validateInputNotNull((Object)aSchedulerId, (String)"Snapshot Scheduler ID");
        for (SnapshotSchedulerImpl scheduler : this.mySnapshotSchedulers) {
            if (!aSchedulerId.equals((Object)scheduler.getCommKeyClassId())) continue;
            return scheduler;
        }
        return null;
    }

    public SnapshotSchedulerImpl getSchedulerForSourceVolume(VolumeNodeImpl aSourceVolume) {
        Util.validateInputNotNull((Object)aSourceVolume, (String)"Source volume");
        for (SnapshotSchedulerImpl scheduler : this.mySnapshotSchedulers) {
            if (!aSourceVolume.equals(scheduler.getSourceVolume())) continue;
            return scheduler;
        }
        return null;
    }

    public SnapshotSchedulerImpl getSchedulerForSnapshot(SnapshotVolumeImpl aSnapshotVolume) {
        VolumeNodeImpl sourceVolume;
        Util.validateInputNotNull((Object)aSnapshotVolume, (String)"Snapshot volume");
        if (SnapshotConfigFlagsConstant.SCHEDULED_BASED.equals((Object)aSnapshotVolume.getConfigFlags()) && (sourceVolume = aSnapshotVolume.getSourceVolume()) != null) {
            return this.getSchedulerForSourceVolume(sourceVolume);
        }
        return null;
    }

    public List<SnapshotSchedulerImpl> getSnapshotSchedulers() {
        return new ArrayList<SnapshotSchedulerImpl>(this.mySnapshotSchedulers);
    }

    public SnapshotSchedulerImpl newSnapshotScheduler(ConfigElementData aCED) throws IllegalValueException, RemoteException, InvalidElementException, AlreadyKnownByVSwitch {
        SnapshotSchedulerImpl alreadyExistScheduler = this.findSnapshotScheduler(aCED);
        if (alreadyExistScheduler != null) {
            throw new AlreadyKnownByVSwitch(alreadyExistScheduler);
        }
        SnapshotSchedulerImpl scheduler = new SnapshotSchedulerImpl(this.myCluster, aCED);
        scheduler.changeParameterList(aCED);
        this.mySnapshotSchedulers.add(scheduler);
        return scheduler;
    }

    public void removeSnapshotScheduler(SnapshotSchedulerImpl aSnapshotScheduler) {
        if (aSnapshotScheduler.getConnectedVSwitchCounter() == 1) {
            this.mySnapshotSchedulers.remove(aSnapshotScheduler);
        }
    }

    public ClientConfigElementData getClientCedForStartScheduler(ClientConfigElementData aClientCed) {
        GeneralSCSIDevice[] sourceVolumeDisks;
        long currentSnapCount = 0L;
        Long desiredSnapCount = 0L;
        BigInteger blocksPerSnapshot = BigInteger.ZERO;
        if (aClientCed.isNested(ClientParameterCode.ELEMENT_ID)) {
            ClientConfigElementData createSchedulerCed = (ClientConfigElementData)aClientCed.getValue(ClientParameterCode.ELEMENT_ID);
            currentSnapCount = 0L;
            desiredSnapCount = (Long)createSchedulerCed.getValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT);
            Long snapBlocksLongVal = (Long)createSchedulerCed.getValue(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE);
            blocksPerSnapshot = new BigInteger(String.valueOf(snapBlocksLongVal));
        } else {
            CommKeyClassId schedulerId = LogicMgrAOImpl.getInstance().getServerCKCI(aClientCed.getCommKeyClassId());
            SnapshotSchedulerImpl scheduler = null;
            scheduler = this.getSnapshotScheduler(schedulerId);
            currentSnapCount = scheduler.getSchedulerSnapshots().size();
            desiredSnapCount = scheduler.getNumberOfSnapshots().longValue();
            blocksPerSnapshot = scheduler.getBlocksPerSnapshot();
        }
        CommKeyClassId sourceVolumeId = (CommKeyClassId)aClientCed.removeValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
        VolumeNodeImpl sourceVolume = (VolumeNodeImpl)LogicMgrAOImpl.getInstance().getLogicObject(sourceVolumeId);
        ArrayList<CommKeyClassId> forbiddenDisks = new ArrayList<CommKeyClassId>();
        for (GeneralSCSIDevice sourceDisk : sourceVolumeDisks = sourceVolume.getDisksOfVolume()) {
            try {
                forbiddenDisks.add(sourceDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Remote exception inside a server context."});
            }
        }
        List<SnapshotVolumeImpl> sourceSnaps = this.myCluster.getVolumeMgr().getSnapshotManager().getSnapshotsForSourceVolume(sourceVolume);
        for (SnapshotVolumeImpl existsSnapshot : sourceSnaps) {
            GeneralSCSIDevice[] existsSnapshotDisks;
            for (GeneralSCSIDevice existsSnapshotDisk : existsSnapshotDisks = existsSnapshot.getDisksOfVolume()) {
                try {
                    forbiddenDisks.add(existsSnapshotDisk.getCommKeyClassId());
                }
                catch (RemoteException e) {
                    theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Remote exception inside a server context."});
                }
            }
        }
        DirectAccessDeviceImpl sourceVolumeDisk = (DirectAccessDeviceImpl)sourceVolumeDisks[0];
        if (currentSnapCount < desiredSnapCount) {
            String snapAliasPrefix = sourceVolume.getAlias() + ".snapshot";
            snapAliasPrefix = Util.replaceInvalidCharacters((String)snapAliasPrefix, (String)"[\\&#\\+\\-!\\*]");
            ArrayList<ClientConfigElementData> snapshotCreationCeds = new ArrayList<ClientConfigElementData>();
            CommKeyClassId clusterId = this.myCluster.getCommKeyClassId();
            for (long i = currentSnapCount; i < desiredSnapCount; ++i) {
                ClientConfigElementData snapClientCed = new ClientConfigElementData(ClassID.SNAPSHOT_VOLUME, clusterId, ConfigOperation.CREATE);
                String snapshotAlias = snapAliasPrefix + '.' + (i + 1L);
                snapshotAlias = this.myCluster.getStoragePoolMgr().getRecommendedAlias(snapshotAlias);
                snapClientCed.putValue(ClientParameterCode.VOLUME_ALIAS, (Object)snapshotAlias);
                int blockSize = sourceVolume.getBlockSize();
                snapClientCed.putValue(ClientParameterCode.VOLUME_SPACE, (Object)Util.blocksToBytes((BigInteger)blocksPerSnapshot, (int)blockSize));
                snapClientCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, (Object)sourceVolumeDisk.getDriveType());
                snapClientCed.putValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, (Object)sourceVolumeDisk.getRaidLevel());
                snapClientCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, (Object)sourceVolumeId);
                snapClientCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, (Object)Server.CONSTANSTS_BUNDLE.getIntResource((BundleKeysInterface)SrConstantsBundleKeys.SNAPSHOT_DEFAULT_THRESHOLD));
                snapClientCed.putValue(ClientParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, (Object)SnapshotConfigFlagsConstant.SCHEDULED_BASED);
                AllocationPolicy policy = AllocationPolicy.DONT_REUSE_ALLOCATED;
                policy = policy.addPolicy(AllocationPolicy.FORBIDDEN_STORAGES, forbiddenDisks);
                snapClientCed.putValue(ClientParameterCode.VOLUME_ALLOCATION_POLICY, (Object)policy);
                snapshotCreationCeds.add(snapClientCed);
            }
            List preClientCeds = aClientCed.getPreConfigurationElements();
            preClientCeds.addAll(snapshotCreationCeds);
            aClientCed.setPreConfigurationElement(preClientCeds);
        } else if (currentSnapCount > desiredSnapCount) {
            // empty if block
        }
        return aClientCed;
    }
}

