/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.snapshot;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotScheduler;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotSchedulerAlarmGenerator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnapshotSchedulerImpl
extends LogicObjectImpl
implements SnapshotScheduler {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static final SrFilterSimpleRule<SnapshotVolumeImpl> SCHEDULER_SNAPS_FILTER_RULE;

    public SnapshotSchedulerImpl(ClusterImpl aCluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(aCluster, ClassID.SNAPSHOT_SCHEDULER, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE, this.getCommKeyClassIdValueOf(ParameterCode.SNAPSHOT_VOLUME_SOURCE));
        return params;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return SnapshotSchedulerAlarmGenerator.getInstance();
    }

    public boolean isRunning() {
        SnapshotSchedulerStateConstant state = (SnapshotSchedulerStateConstant)this.getSrValueOf(ParameterCode.SNAPSHOT_SCHEDULER_STATE);
        return SnapshotSchedulerStateConstant.RUNNING.equals((Object)state);
    }

    public BigInteger getBlocksPerSnapshot() {
        SrType srSize = this.getSrValueOf(ParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE);
        return (BigInteger)srSize.value();
    }

    public BigInteger getNumberOfSnapshots() {
        return (BigInteger)this.getValueOf(ParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT);
    }

    public VolumeNodeImpl getSourceVolume() {
        CommKeyClassId sourceVolumeId = this.getCommKeyClassIdValueOf(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        return (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sourceVolumeId);
    }

    public CommKeyClassId getSourceVolumeId() {
        return this.getCommKeyClassIdValueOf(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
    }

    public List<SnapshotVolumeImpl> getSchedulerSnapshots() {
        ArrayList<SnapshotVolumeImpl> schedulerSnaps = new ArrayList<SnapshotVolumeImpl>();
        VolumeNodeImpl sourceVolume = this.getSourceVolume();
        if (sourceVolume != null) {
            List<SnapshotVolumeImpl> sourceSnaps = this.cluster.getVolumeMgr().getSnapshotManager().getSnapshotsForSourceVolume(sourceVolume);
            SrFilteredArrayList filter = new SrFilteredArrayList(sourceSnaps);
            filter.addRule(SCHEDULER_SNAPS_FILTER_RULE);
            return filter.getAllOfMatched();
        }
        return schedulerSnaps;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        boolean isStateChange;
        SnapshotSchedulerStateConstant state = (SnapshotSchedulerStateConstant)parameterList.get(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE);
        boolean bl = isStateChange = state != null;
        if (isStateChange && parameterList.size() > 1) {
            return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.SNAPSHOT_SCHEDULER_CHANGE_ON_STATE_CHANGE, new Object[]{state});
        }
        if (this.isRunning() && !isStateChange) {
            return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.SNAPSHOT_SCHEDULER_CHANGE_ON_RUNNING);
        }
        if (parameterList.containsKey(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT)) {
            return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.SNAPSHOT_SCHEDULER_CHANGE_SNAP_COUNT);
        }
        if (parameterList.containsKey(ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE)) {
            return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.SNAPSHOT_SCHEDULER_CHANGE_SNAP_SIZE);
        }
        Long period = (Long)parameterList.get(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD);
        if (period != null) {
            if (period <= 0L) {
                return Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.ELEMENT_ILLEGAL_VALUE, new Object[]{ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD, period});
            }
            parameterList.put(ClientParameterCode.SNAPSHOT_SCHEDULER_PERIOD, new SrGauge(period.longValue()));
        }
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    protected List<LogicObjectImpl> getChildElementsForDeletion() {
        return Util.convertListType(this.getSchedulerSnapshots());
    }

    @Override
    public ConfigElementDataList getTreeDeletionCedList() {
        ConfigElementDataList deletionCeds = new ConfigElementDataList(ConfigOperation.DELETE);
        AlarmMgrImpl.getInstance().removeAlarmsFromSilencedList((GeneralLogicObjectImpl)this);
        deletionCeds.addAll((Collection)this.getDeleteChildrenCedList());
        ConfigElementData deleteScheduleCed = new ConfigElementData(this.getCommKeyClassId(), ConfigOperation.DELETE);
        deletionCeds.add((ElementData)deleteScheduleCed);
        return deletionCeds;
    }

    @Override
    public List<ConfigElementData> getCedForDeletion() {
        List<ConfigElementData> retVal = super.getCedForDeletion();
        for (SnapshotVolumeImpl snapshot : this.getSchedulerSnapshots()) {
            SnapshotConfigFlagsConstant flags = snapshot.getConfigFlags();
            if (flags == null) continue;
            ConfigElementData removeSnapFlagsCed = new ConfigElementData(snapshot.getCommKeyClassId(), ConfigOperation.CHANGE);
            flags = (SnapshotConfigFlagsConstant)flags.turnOffBitConstant((SrBITSConstant)SnapshotConfigFlagsConstant.SCHEDULED_BASED);
            flags = (SnapshotConfigFlagsConstant)flags.turnOffBitConstant((SrBITSConstant)SnapshotConfigFlagsConstant.EXTERNAL_SCHEDULER);
            removeSnapFlagsCed.setValue(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, (SrType)flags);
            retVal.add(0, removeSnapFlagsCed);
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClassId());
        sb.append(" of volume ");
        sb.append(this.getSourceVolume());
        return sb.toString();
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        return null;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_SCHEDULER_PERIOD, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_SCHEDULER_START_AT, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_SCHEDULER_STATE, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE, new ParameterCode.Flags(false, true));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_VOLUME_SOURCE, new ParameterCode.Flags(false, true));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        SCHEDULER_SNAPS_FILTER_RULE = new SrFilterSimpleRule<SnapshotVolumeImpl>(){

            public boolean isValid(SnapshotVolumeImpl aNewObject, Object ... aParams) {
                SnapshotConfigFlagsConstant snapFlags = aNewObject.getConfigFlags();
                return snapFlags != null && snapFlags.contains((SrBITSConstant)SnapshotConfigFlagsConstant.SCHEDULED_BASED);
            }
        };
    }
}

