/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.copy;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManager;
import com.sanrad.nms.server.logic.volume.copy.MirrorSyncOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.OfflineCopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.RestoreOperationImpl;
import com.sanrad.nms.server.logic.volume.validators.SnapshotVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityEvent;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityListener;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.SrPostponedExecutor;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CopyOperationManagerImpl
extends RemoteObjectImpl
implements CopyOperationManager,
VSwitchConnectivityListener {
    private Vector allCopyOpers = new Vector();
    private ClusterImpl myCluster;
    private static SrLogger theLogger = SrLogger.getLogger();

    public CopyOperationManagerImpl(ClusterImpl cluster) throws RemoteException {
        this.myCluster = cluster;
        cluster.addVSwitchConnectivityListener(this);
    }

    public void clear() {
        this.allCopyOpers.clear();
    }

    @Override
    public synchronized Vector getAllCopyOpers() {
        return this.allCopyOpers;
    }

    @Override
    public synchronized Vector getMirrorSyncCopyOpers() {
        Vector opers = this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, (SrType)VolumeOperationType.VOL_OPER_MIRROR_SYNC);
        opers.addAll(this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, (SrType)VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC));
        return opers;
    }

    @Override
    public synchronized Vector getOfflineCopyOpers() {
        Vector opers = this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, (SrType)VolumeOperationType.VOL_OPER_OFFLINE_COPY);
        opers.addAll(this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, (SrType)VolumeOperationType.VOL_OPER_ABORT_COPY));
        return opers;
    }

    @Override
    public synchronized Vector getRestoreOpers() {
        Vector opers = this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, (SrType)VolumeOperationType.VOL_OPER_RESTORE);
        opers.addAll(this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, (SrType)VolumeOperationType.VOL_OPER_ABORT_RESTORE));
        return opers;
    }

    public synchronized void removeCopyOper(CopyOperationImpl copyOper) {
        this.allCopyOpers.remove(copyOper);
        if (copyOper instanceof RestoreOperationImpl) {
            CommKeyClassId src = copyOper.getCopySrc();
            SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub(src);
            if (snapshotVolume != null) {
                snapshotVolume.setRestoreOperation(null);
                ClusterImpl curCluster = snapshotVolume.getCluster();
                if (curCluster != null) {
                    AlarmMgrImpl.getInstance().generateAlarms(curCluster, 2, (GeneralLogicObjectImpl)snapshotVolume, copyOper.getActiveVswitch());
                } else {
                    theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The snapshot volume ", snapshotVolume, " contains null as its cluster."});
                }
                if (snapshotVolume.getSourceVolume() != null) {
                    curCluster = snapshotVolume.getSourceVolume().getCluster();
                    if (curCluster != null) {
                        AlarmMgrImpl.getInstance().generateAlarms(curCluster, 2, (GeneralLogicObjectImpl)snapshotVolume.getSourceVolume(), copyOper.getActiveVswitch());
                    } else {
                        theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The snapshot volume source ", snapshotVolume.getSourceVolume(), " contains null as its cluster."});
                    }
                }
            }
        }
    }

    public synchronized boolean isCopyLegitimate(CopyOperationImpl copyOper) throws RemoteException, IllegalValueException {
        boolean result = this.isCopyLegitimate(copyOper.getCopySrc(), copyOper.getCopyDst(), copyOper.getVSwitchCommKeyClassId(), copyOper.getCopyType());
        return result;
    }

    public synchronized boolean isCopyLegitimate(CommKeyClassId src, CommKeyClassId dst, CommKeyClassId vSwitch, VolumeOperationType copyType) throws RemoteException, IllegalValueException {
        if (copyType.isRestore()) {
            SnapshotVolumeImpl sourceOfRestore = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub(src);
            SnapshotVolumeValidator snapshotVolumeValidator = new SnapshotVolumeValidator(sourceOfRestore.getAlias());
            if (!snapshotVolumeValidator.isValidForRestoreOperation(sourceOfRestore)) {
                throw new IllegalValueException(snapshotVolumeValidator.getErrorMsg());
            }
            if (this.isInvolvedInActiveCopyOper(sourceOfRestore.getCommKeyClassId())) {
                throw new IllegalValueException("Snapshot volume is involved in another active copy operation");
            }
            if (this.isInvolvedInActiveCopyOper(sourceOfRestore.getSourceVolume().getCommKeyClassId())) {
                throw new IllegalValueException("Snapshot source volume is involved in another copy operation");
            }
        }
        return true;
    }

    private CopyOperationImpl[] getOperIfAlreadyExist(VolumeNodeImpl src, VolumeNodeImpl dst, VSwitchImpl vSwitch, VolumeOperationType copyType) throws IllegalValueException {
        Vector<CopyOperationImpl> copyOpers = new Vector<CopyOperationImpl>();
        for (CopyOperationImpl current : this.allCopyOpers) {
            if (dst != null) {
                if (!current.getCopyDstNode().equals(dst) || !current.getCopySrcNode().equals(src) || !this.isSameCopyType(current.getCopyType(), copyType)) continue;
                copyOpers.add(current);
                continue;
            }
            if (!current.getCopySrcNode().equals(src) || !this.isSameCopyType(current.getCopyType(), copyType)) continue;
            copyOpers.add(current);
        }
        CopyOperationImpl[] retVal = new CopyOperationImpl[copyOpers.size()];
        for (int i = 0; i < copyOpers.size(); ++i) {
            retVal[i] = (CopyOperationImpl)copyOpers.get(i);
        }
        return retVal;
    }

    private boolean isSameCopyType(VolumeOperationType oper1, VolumeOperationType oper2) {
        return oper1.isMirrSyncOper() && oper2.isMirrSyncOper() || oper1.isOfflineCopy() && oper2.isOfflineCopy() || oper1.isRestore() && oper2.isRestore();
    }

    @Override
    public SrFuture<Void> abortCopyOper(CopyOperation oper) throws RemoteException {
        CopyOperationImpl copyOper = (CopyOperationImpl)oper;
        ConfigElementData element = new ConfigElementData(copyOper.getCommKeys(), copyOper.getClassId());
        VolumeOperationType abortType = copyOper.getAbortType();
        try {
            copyOper.setOneParameter(ParameterCode.COPY_OPERATION_TYPE, abortType, copyOper.getVSwitches().get(0));
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.LEGACY, (Throwable)((Object)ive), new Object[]{"Failed to set new Copy Operation type for abort operation."});
        }
        return DataMgrAdapter.getInstance().operate(element, abortType);
    }

    @Override
    public SrFuture<Void> refreshCopyTable() throws RemoteException {
        if (!this.getCluster().getVSwitches().isEmpty()) {
            ConfigElementData element = new ConfigElementData(ClassID.COPY_OPERATION);
            element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, (SrType)null);
            element.setValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS, (SrType)null);
            element.setValue(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, (SrType)null);
            this.getCluster().prepareVSwitchIDs((ElementData)element, "prepare V-Switches for copy-oper refresh", null);
            return DataMgrAdapter.getInstance().refreshTableFields(element);
        }
        return new CompleteFuture("CopyOperationManagerImpl.refreshCopyTable");
    }

    private ClusterImpl getCluster() {
        return this.myCluster;
    }

    public synchronized SrFuture<Void> addCopyOperation(VolumeNodeImpl src, VolumeNodeImpl dst, VSwitchImpl vSwitch, VolumeOperationType copyType) throws IllegalValueException, CopyAlreadyExistException, RemoteException {
        CommKeyClassId vSwitchCommKeyClassId;
        if (copyType.isRestore() && dst == null) {
            dst = ((SnapshotVolumeImpl)src).getSourceVolume();
        }
        CommKeyClassId[] vSwitchData = new CommKeyClassId[]{vSwitchCommKeyClassId = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId())};
        ConfigElementData element = null;
        CopyOperationImpl[] opers = this.getOperIfAlreadyExist(src, dst, vSwitch, copyType);
        if (opers.length > 0) {
            LogicObjectImpl operToRestart = null;
            for (int i = 0; i < opers.length; ++i) {
                CopyOperationImpl oper = opers[i];
                if (oper.getCopyStatus().isActive()) {
                    String destinationStr = dst != null ? dst.toString() : oper.getCopyDstNode().toString();
                    String sourceStr = src != null ? src.toString() : oper.getCopySrcNode().toString();
                    String[] errData = new String[]{copyType.toString(), sourceStr, destinationStr, oper.getVSwitches().get(0).toString()};
                    throw new CopyAlreadyExistException(ErrorMessage.COPY_ALREADY_RUN_FOR_DST_OR_SRC.getMessage(errData));
                }
                if (!oper.getVSwitches().get(0).equals(vSwitch)) continue;
                operToRestart = oper;
                break;
            }
            if (operToRestart != null) {
                if (vSwitch.isConnected()) {
                    element = new ConfigElementData(operToRestart.getCommKeys(), operToRestart.getClassId());
                    vSwitchData[0] = ((CopyOperationImpl)operToRestart).getVSwitchCommKeyClassId();
                    element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchData));
                } else {
                    StringBuffer msg = new StringBuffer(copyType.toString());
                    msg.append(" cannot be restarted. ");
                    msg.append(ClassID.VSWITCH);
                    msg.append(" ");
                    msg.append(vSwitch);
                    msg.append(" is not connected.");
                    throw new IllegalValueException(msg.toString());
                }
            }
        }
        if (element == null) {
            CommKeyClassId dstData = dst != null ? dst.getCommKeyClassId() : null;
            CommKeyClassId srcData = src.getCommKeyClassId();
            if (this.isCopyLegitimate(srcData, dstData, vSwitchCommKeyClassId, copyType)) {
                element = new ConfigElementData(src.getCommKeys(), src.getClassId());
                element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchData));
                if (srcData != null) {
                    element.setValue(ParameterCode.VOLUME_OPERATION_SRC, (SrType)srcData);
                }
                if (dstData != null) {
                    element.setValue(ParameterCode.VOLUME_OPERATION_DST, (SrType)dstData);
                }
            } else {
                throw new IllegalValueException("Copy Operation cannot be created in cluster " + this.getCluster().getAlias());
            }
        }
        return DataMgrAdapter.getInstance().operate(element, copyType);
    }

    public SrFuture<Void> restartOperation(CopyOperationImpl copyOper) throws IllegalValueException {
        CopyOperationImpl[] opers = this.getOperIfAlreadyExist(copyOper.getCopySrcNode(), copyOper.getCopyDstNode(), copyOper.getConnectedVSwitches()[0], copyOper.getCopyType());
        for (int i = 0; i < opers.length; ++i) {
            CopyOperationImpl oper = opers[i];
            if (!oper.getCopyStatus().isActive()) continue;
            StringBuffer msg = new StringBuffer(copyOper.getRestartType().toString());
            msg.append(" for the same source and destination is currently running in ");
            msg.append(ClassID.VSWITCH);
            msg.append(" ");
            msg.append(oper.getVSwitches().get(0).toString());
            throw new IllegalValueException(msg.toString());
        }
        ConfigElementData element = new ConfigElementData(copyOper.getCommKeys(), copyOper.getClassId());
        CommKeyClassId[] vSwithcData = new CommKeyClassId[]{copyOper.getVSwitchCommKeyClassId()};
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwithcData));
        return DataMgrAdapter.getInstance().operate(element, copyOper.getRestartType());
    }

    public synchronized LogicObjectImpl newCopyOper(ConfigElementData aCED) throws AlreadyKnownByVSwitch, RemoteException, IllegalValueException, InvalidElementException {
        Object copyType = aCED.getValue((ParameterCodes)ParameterCode.COPY_OPERATION_TYPE);
        Object dst = aCED.getValue((ParameterCodes)ParameterCode.VOLUME_OPERATION_DST);
        Object status = aCED.getValue((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS);
        Object vswitch = aCED.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
        Object src = aCED.getValue((ParameterCodes)ParameterCode.VOLUME_OPERATION_SRC);
        Object perCopy = aCED.getValue((ParameterCodes)ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED);
        if (perCopy == null) {
            perCopy = new SrInteger(0);
        }
        CopyOperationImpl current = null;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            current = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!current.getCopySrc().equals(src) || !current.getCopyDst().equals(dst) || !current.getCopyType().equals(copyType) || !current.getVSwitchCommKeyClassId().equals(vswitch)) continue;
            throw new AlreadyKnownByVSwitch(current);
        }
        CopyOperationImpl newOper = null;
        if (copyType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC)) {
            if (copyType.equals(MirrorSyncOperationImpl.getStaticAbortType())) {
                if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) {
                    aCED.addParameter((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
                } else {
                    aCED.addParameter((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTE_FAILED);
                }
            }
            newOper = new MirrorSyncOperationImpl(this.getCluster(), aCED);
        } else if (copyType.equals(VolumeOperationType.VOL_OPER_OFFLINE_COPY) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_COPY)) {
            if (copyType.equals(OfflineCopyOperationImpl.getStaticAbortType())) {
                if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) {
                    aCED.addParameter((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
                } else {
                    aCED.addParameter((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTE_FAILED);
                }
            }
            newOper = new OfflineCopyOperationImpl(this.getCluster(), aCED);
        } else if (copyType.equals(VolumeOperationType.VOL_OPER_RESTORE) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            if (copyType.equals(RestoreOperationImpl.getStaticAbortType())) {
                if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) {
                    aCED.addParameter((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
                } else {
                    aCED.addParameter((ParameterCodes)ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTE_FAILED);
                }
            }
            newOper = new RestoreOperationImpl(this.getCluster(), aCED);
            SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)src);
            snapshotVolume.setRestoreOperation((RestoreOperationImpl)newOper);
        } else {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"Unhandled copy operation type: " + copyType});
        }
        if (newOper != null) {
            newOper.changeParameterList(aCED);
            this.allCopyOpers.add(newOper);
        }
        if (copyType.equals(VolumeOperationType.VOL_OPER_RESTORE) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            VSwitchImpl vswitchImpl = (VSwitchImpl)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)vswitch);
            SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)src);
            ClusterImpl clusterImpl = snapshotVolume.getCluster();
            VolumeNodeImpl snapshotSource = snapshotVolume.getSourceVolume();
            if (clusterImpl != null) {
                if (snapshotVolume != null) {
                    AlarmMgrImpl.getInstance().generateAlarms(clusterImpl, 2, (GeneralLogicObjectImpl)snapshotVolume, vswitchImpl);
                }
                if (snapshotSource != null) {
                    AlarmMgrImpl.getInstance().generateAlarms(clusterImpl, 2, (GeneralLogicObjectImpl)snapshotSource, vswitchImpl);
                }
            } else {
                theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The snapshot volume ", snapshotVolume, " contains null as its cluster."});
            }
        }
        return newOper;
    }

    public synchronized Vector getByParameter(ParameterCode parameter, SrType value) {
        Vector opers = new Vector();
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            if (!((CopyOperationImpl)this.allCopyOpers.get(i)).getSrValueOf(parameter).equals((Object)value)) continue;
            opers.add(this.allCopyOpers.get(i));
        }
        return opers;
    }

    protected synchronized String canBeDeleted() {
        return null;
    }

    protected synchronized String isValid(HashMap parameterList) {
        return null;
    }

    public void registerToPropagatedStateChange() {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        return true;
    }

    public SrFuture<Void> removeAllCopyOpersForVolume(VolumeNodeImpl vol, VSwitchImpl vSwitch, boolean removeAlsoFromDataMgr, SrPostponedExecutor aEventMonitor) throws InvalidElementException, RemoteException {
        ArrayList opersToRemove = new ArrayList();
        if (vol instanceof MirrorVolumeImpl) {
            List<VolumeNodeImpl> mirChildren = vol.getChildren();
            for (VolumeNodeImpl child : mirChildren) {
                int i;
                Vector opers = this.getByParameter(ParameterCode.VOLUME_OPERATION_DST, (SrType)child.getCommKeyClassId());
                for (i = 0; i < opers.size(); ++i) {
                    if (opersToRemove.contains(opers.get(i))) continue;
                    opersToRemove.add(opers.get(i));
                }
                opers = this.getByParameter(ParameterCode.VOLUME_OPERATION_SRC, (SrType)child.getCommKeyClassId());
                for (i = 0; i < opers.size(); ++i) {
                    if (opersToRemove.contains(opers.get(i))) continue;
                    opersToRemove.add(opers.get(i));
                }
            }
            Iterator opers = opersToRemove.iterator();
            while (opers.hasNext()) {
                CopyOperationImpl oper = (CopyOperationImpl)opers.next();
                SrType operType = oper.getSrValueOf(ParameterCode.COPY_OPERATION_TYPE);
                if (operType.equals((Object)VolumeOperationType.VOL_OPER_MIRROR_SYNC) || operType.equals((Object)VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC)) continue;
                opers.remove();
            }
        }
        opersToRemove.addAll(this.getByParameter(ParameterCode.VOLUME_OPERATION_DST, (SrType)vol.getCommKeyClassId()));
        opersToRemove.addAll(this.getByParameter(ParameterCode.VOLUME_OPERATION_SRC, (SrType)vol.getCommKeyClassId()));
        CommKeyClassId[] opers = opersToRemove.iterator();
        while (opers.hasNext()) {
            CopyOperationImpl oper = (CopyOperationImpl)opers.next();
            if (vSwitch.equals(oper.getConnectedVSwitches()[0])) continue;
            opers.remove();
        }
        if (removeAlsoFromDataMgr) {
            opers = new CommKeyClassId[opersToRemove.size()];
            for (int i = 0; i < opersToRemove.size(); ++i) {
                opers[i] = ((CopyOperationImpl)opersToRemove.get(i)).getCommKeyClassId();
            }
            try {
                return this.myCluster.deleteObjects(opers);
            }
            catch (IllegalValueException ive) {
                theLogger.error(SrLogCategories.LEGACY, new Object[]{"caught an exception during deleting objects from cluster ", this.myCluster.getAlias(), ": ", ive.getMessage()});
                return new FailedFuture((Exception)((Object)ive), "CopyOperationManagerImpl.removeAllCopyOpersForVolume");
            }
        }
        final SrFuture retFuture = new SrFuture("CopyOperationManagerImpl.removeAllCopyOpersForVolume");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        Iterator itr = opersToRemove.iterator();
        while (itr.hasNext()) {
            midFutures.add(this.getCluster().removeElement((CopyOperationImpl)itr.next(), vSwitch, aEventMonitor, vSwitch.getMgmIPAddr()));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public boolean isInvolvedInCopyOper(CommKeyClassId node) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getSrValueOf(src).equals((Object)node) && !oper.getSrValueOf(dst).equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    public boolean isInvolvedInCopyOper(CommKeyClassId node, CommKeyClassId vSwitch) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getSrValueOf(src).equals((Object)node) && !oper.getSrValueOf(dst).equals((Object)node) || !vSwitch.equals((Object)oper.getConnectedVSwitches()[0].getCommKeyClassId())) continue;
            return true;
        }
        return false;
    }

    public boolean isInvolvedInActiveCopyOper(CommKeyClassId node, CommKeyClassId vSwitch) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        ParameterCode status = ParameterCode.VOLUME_OPERATION_OPER_STATUS;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getSrValueOf(src).equals((Object)node) && !oper.getSrValueOf(dst).equals((Object)node) || !vSwitch.equals((Object)oper.getConnectedVSwitches()[0].getCommKeyClassId()) || !((VolumeOperationOperStatusConstant)oper.getSrValueOf(status)).isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isInvolvedInActiveCopyOper(CommKeyClassId node) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        ParameterCode status = ParameterCode.VOLUME_OPERATION_OPER_STATUS;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getSrValueOf(src).equals((Object)node) && !oper.getSrValueOf(dst).equals((Object)node) || !((VolumeOperationOperStatusConstant)oper.getSrValueOf(status)).isActive()) continue;
            return true;
        }
        return false;
    }

    public CopyOperationImpl getCopyForNode(CommKeyClassId node) {
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getCopySrc().equals((Object)node) && !oper.getCopyDst().equals((Object)node)) continue;
            return oper;
        }
        return null;
    }

    public boolean isExistedAsSrcInOtherActivrCopyOperation(CommKeyClassId node) {
        CopyOperationImpl existedCopyOperation = this.getActiveCopyForNode(node);
        if (existedCopyOperation != null) {
            return existedCopyOperation.getSrValueOf(ParameterCode.VOLUME_OPERATION_SRC).equals((Object)node);
        }
        return false;
    }

    public boolean isExistedAsDstInOtherActivrCopyOperation(CommKeyClassId node) {
        CopyOperationImpl existedCopyOperation = this.getActiveCopyForNode(node);
        if (existedCopyOperation != null) {
            return existedCopyOperation.getSrValueOf(ParameterCode.VOLUME_OPERATION_DST).equals((Object)node);
        }
        return false;
    }

    public CopyOperationImpl getActiveCopyForNode(CommKeyClassId node) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        ParameterCode status = ParameterCode.VOLUME_OPERATION_OPER_STATUS;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getSrValueOf(src).equals((Object)node) && !oper.getSrValueOf(dst).equals((Object)node) || !((VolumeOperationOperStatusConstant)oper.getSrValueOf(status)).isActive()) continue;
            return oper;
        }
        return null;
    }

    public void setOperStatForAllCopyOfVswitch(VSwitchImpl vSwitch, VolumeOperationOperStatusConstant operStat) {
        try {
            for (CopyOperationImpl oper : this.allCopyOpers) {
                if (!oper.getConnectedVSwitches()[0].equals(vSwitch)) continue;
                Parameter param = new Parameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS, (Object)operStat);
                oper.setOneParameter(param, vSwitch);
                HashMap<ParameterCode, VolumeOperationOperStatusConstant> changedValues = new HashMap<ParameterCode, VolumeOperationOperStatusConstant>();
                changedValues.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, operStat);
                try {
                    ElementEventImpl elementEvent = new ElementEventImpl((Object)this, oper);
                    elementEvent.setParameterList(changedValues);
                    LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"Couldn't initialize ElementEventImpl because ", re.getMessage()});
                }
            }
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.LEGACY, (Throwable)((Object)ive));
        }
    }

    @Override
    public void vSwitchConnectivityChanged(VSwitchConnectivityEvent event) {
        try {
            boolean isConnected = event.getConnectivityStatus();
            if (!isConnected) {
                this.setOperStatForAllCopyOfVswitch(event.getVSwitch(), VolumeOperationOperStatusConstant.VOLUME_OPERATION_UNKNOWN);
            } else {
                ErrorAssertingListener.listenTo(this.refreshCopyTable());
            }
        }
        catch (RemoteException re) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"got a remote exception in the server."});
        }
    }

    public boolean isInvolvedInActiveRestoreOperation(VolumeNodeImpl nodeImpl) {
        for (CopyOperationImpl oper : this.allCopyOpers) {
            if (!this.operationStatusActive(oper.getCopyStatus()) || !(oper instanceof RestoreOperationImpl)) continue;
            RestoreOperationImpl restoreOperation = (RestoreOperationImpl)oper;
            VolumeNodeImpl src = restoreOperation.getCopySrcNode();
            if (src.equals(nodeImpl)) {
                return true;
            }
            VolumeNodeImpl dst = restoreOperation.getCopyDstNode();
            if (!dst.equals(nodeImpl)) continue;
            return true;
        }
        return false;
    }

    public boolean operationStatusActive(VolumeOperationOperStatusConstant operStat) {
        return operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
    }

    @Override
    public SrFuture<Void> restoreSnapshots(SnapshotVolume[] snapshots) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("CopyOperationManagerImpl.restoreSnapshots");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (snapshots != null && snapshots.length > 0) {
            for (int index = 0; index < snapshots.length; ++index) {
                midFutures.add(snapshots[index].restore());
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }
}

