/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.copy;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CopyOperationImpl
extends TableRowImpl
implements CopyOperation {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private String m_copyTypeName;
    private VolumeNodeImpl m_copySrcNode;
    private VolumeNodeImpl m_copyDstNode;
    private String m_copyStatusName;

    public CopyOperationImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.COPY_OPERATION, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        HashMap changedValues = super.changeParameterList(aCED);
        this.m_copyTypeName = this.getSrValueOf(ParameterCode.COPY_OPERATION_TYPE).toDisplayString();
        this.m_copySrcNode = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_SRC));
        this.m_copyDstNode = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_DST));
        this.m_copyStatusName = this.getSrValueOf(ParameterCode.VOLUME_OPERATION_OPER_STATUS).toDisplayString();
        if (this.getCopyType().equals((Object)this.getAbortType())) {
            this.setOneParameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS, VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED, vSwitch);
            changedValues.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
        }
        return changedValues;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        ced.setValue(ParameterCode.COPY_OPERATION_TYPE, (SrType)this.getCopyType());
        ced.setValue(ParameterCode.VOLUME_OPERATION_SRC, (SrType)this.getCopySrc());
        ced.setValue(ParameterCode.VOLUME_OPERATION_DST, (SrType)this.getCopyDst());
        return this.deleteElement(ced);
    }

    @Override
    public SrType getSrValueOf(ParameterCode code) {
        VSwitchImpl[] connectedVs = this.getConnectedVSwitches();
        if (connectedVs.length > 0) {
            VSwitchImpl vSwitch = connectedVs[0];
            return super.getSrValueOf(vSwitch, code);
        }
        return null;
    }

    @Override
    public VolumeNodeImpl getCopySrcNode() {
        return this.m_copySrcNode;
    }

    @Override
    public VolumeNodeImpl getCopyDstNode() {
        return this.m_copyDstNode;
    }

    public CommKeyClassId getCopySrc() {
        return (CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_SRC);
    }

    public VolumeOperationType getCopyType() {
        return (VolumeOperationType)this.getSrValueOf(ParameterCode.COPY_OPERATION_TYPE);
    }

    @Override
    public String getCopyTypeName() {
        return this.m_copyTypeName;
    }

    public CommKeyClassId getVSwitchCommKeyClassId() {
        VSwitchImpl vSwitch = this.getConnectedVSwitches()[0];
        return new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
    }

    @Override
    public VSwitchImpl getCopyVSwitch() {
        return this.getConnectedVSwitches()[0];
    }

    public CommKeyClassId getCopyDst() {
        return (CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_DST);
    }

    @Override
    public Integer getCopyPercentage() {
        return (Integer)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED).value();
    }

    @Override
    public VolumeOperationOperStatusConstant getCopyStatus() {
        return (VolumeOperationOperStatusConstant)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
    }

    @Override
    public String getCopyStatusName() {
        return this.m_copyStatusName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CopyOperationImpl) {
            return ((CopyOperationImpl)obj).getCommKeys().equals(this.getCommKeys());
        }
        return false;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        return true;
    }

    public abstract VolumeOperationType getAbortType();

    public abstract VolumeOperationType getRestartType();

    public String toStringWhenError() {
        StringBuffer str = new StringBuffer("CopyOperImpl. CommKey is: ");
        str.append(this.getCommKeys().toString());
        str.append("\n params are: ");
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            str.append("\n Params are:");
            str.append(this.getParameterListValuesMap(vSwitches[i]).toString());
        }
        return str.toString();
    }

    @Override
    public SrFuture<Void> abortOperation() {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        return DataMgrAdapter.getInstance().operate(element, this.getAbortType());
    }

    @Override
    public SrFuture<Void> restartOperation() throws IllegalValueException, RemoteException {
        VSwitchImpl vSwitch = this.getConnectedVSwitches()[0];
        if (vSwitch.isConnected()) {
            return this.getCluster().getCopyOperManager().restartOperation(this);
        }
        VSwitchImpl otherVswitch = this.cluster.getOtherVSwitch(vSwitch);
        if (!otherVswitch.isConnected()) {
            throw new IllegalValueException("Cannot find any active " + ClassID.VSWITCH + " to set the operation to.");
        }
        try {
            return this.getCluster().getCopyOperManager().addCopyOperation(this.getCopySrcNode(), this.getCopyDstNode(), otherVswitch, this.getRestartType());
        }
        catch (CopyAlreadyExistException copyE) {
            return new FailedFuture((Exception)((Object)copyE), "CopyOperationImpl.restartOperation");
        }
    }

    @Override
    public String toString() {
        try {
            StringBuffer str = new StringBuffer();
            str.append(this.getCopyTypeName());
            str.append(": src = ");
            str.append(this.getCopySrcNode());
            str.append(": dst = ");
            str.append(this.getCopyDstNode());
            str.append(": status = ");
            str.append(this.getCopyStatusName());
            return str.toString();
        }
        catch (NullPointerException npe) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)npe, new Object[0]);
            return this.toStringWhenError();
        }
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_OPERATION_DST, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_OPERATION_SRC, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.COPY_OPERATION_TYPE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

