/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class VolumeNodeImplTest
extends TestCase {
    private static SrTestUtils myTestUtils;
    private static int theSubdiskCounter;
    private static final String theSubdiskAliasPrefix = "$subdisk$test$";
    private static int theVolumeCounter;
    private static final String theVolumeAliasPrefix = "$volume$test$";

    public VolumeNodeImplTest(String arg0) {
        super(arg0);
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SrLogger.init((Properties)new Properties());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testResize() {
        List allClusters = myTestUtils.getClusters();
        ClusterImpl cluster = null;
        for (ClusterImpl _cluster : allClusters) {
            if (_cluster.getConnectedVSwitches().length <= 0) continue;
            cluster = _cluster;
            break;
        }
        VolumeNodeImplTest.assertNotNull((String)"Cluster not found", cluster);
        DirectAccessDeviceImpl disk = null;
        for (DirectAccessDeviceImpl _disk : myTestUtils.getAllDisks(cluster)) {
            if (_disk.getParentVolume() != null || _disk.getParentLU() != null) continue;
            disk = _disk;
            break;
        }
        VolumeNodeImplTest.assertNotNull((String)"Disk not found", disk);
        String subdiskAlias1 = VolumeNodeImplTest.getNewSubdiskAlias();
        String subdiskAlias2 = VolumeNodeImplTest.getNewSubdiskAlias();
        SubDirectAccessDeviceImpl subdiskToEnlarge = myTestUtils.createSubDisk((DirectAccessDevice)disk, VolumeNodeImplTest.getNewSubdiskAlias(), new BigInteger("1000000"));
        SubDirectAccessDeviceImpl subdiskToAdd = myTestUtils.createSubDisk((DirectAccessDevice)disk, VolumeNodeImplTest.getNewSubdiskAlias(), new BigInteger("1000000"));
        String resizeVolumeAlias = VolumeNodeImplTest.getNewVolumeAlias();
        try {
            SrFuture<Void> resizeFuture = subdiskToEnlarge.resize(subdiskToAdd.getCommKeyClassId(), resizeVolumeAlias);
            resizeFuture.get();
        }
        catch (RemoteException e) {
            VolumeNodeImplTest.assertTrue((String)e.getMessage(), (boolean)false);
        }
        catch (IllegalValueException e) {
            VolumeNodeImplTest.assertTrue((String)e.getMessage(), (boolean)false);
        }
        catch (SrExecutionException e) {
            VolumeNodeImplTest.assertTrue((String)e.getMessage(), (boolean)false);
        }
        catch (InterruptedException e) {
            VolumeNodeImplTest.assertTrue((String)e.getMessage(), (boolean)false);
        }
        finally {
            Volume cube = myTestUtils.getVolumeByAlias((Cluster)cluster, resizeVolumeAlias);
            myTestUtils.removeVolume((Cluster)cluster, (VolumeNode)cube);
            try {
                myTestUtils.removeSubDisk((SubDirectAccessDevice)subdiskToEnlarge);
                myTestUtils.removeSubDisk((SubDirectAccessDevice)subdiskToAdd);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getNewSubdiskAlias() {
        return theSubdiskAliasPrefix + theSubdiskCounter++;
    }

    private static String getNewVolumeAlias() {
        return theVolumeAliasPrefix + theVolumeCounter++;
    }

    static {
        theSubdiskCounter = (int)(Math.random() * 10000.0);
        theVolumeCounter = (int)(Math.random() * 10000.0);
    }
}

