/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VirtualizationHierarchyObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.validators.AddMirrorValidator;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.ReplaceVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.ResizeVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.MirrVolConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class VolumeNodeImpl
extends SynchronizeableImpl
implements VolumeNode,
VirtualizationHierarchyObject {
    private boolean myIsExposed = false;
    private boolean free = true;
    private VolumeImpl volumeParent = null;
    private LUImpl parentLU = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected VolumeNodeImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected String canBeDeleted() {
        if (this.isExposed()) {
            return this.getClassId().toString() + " " + this.getAlias() + " is exposed - cannot be deleted";
        }
        if (this.getParentVolume() != null) {
            return this.getClassId().toString() + " " + this.getAlias() + " has parent - cannot be deleted";
        }
        if (this.isSnapshotSource()) {
            return this.getClassId().toString() + " " + this.getAlias() + " is a source of " + ClassID.SNAPSHOT_VOLUME + ".  You have to delete the " + ClassID.SNAPSHOT_VOLUME + " first";
        }
        if (this.cluster.getSnapshotSchedulerMgr().getSchedulerForSourceVolume(this) != null) {
            return this.getClassId().toString() + " " + this.getAlias() + " is a source of " + ClassID.SNAPSHOT_SCHEDULER + ".  You have to delete the " + ClassID.SNAPSHOT_SCHEDULER + " first";
        }
        if (this.isDROfflineLocalCopy()) {
            return this.getClassId().toString() + " " + this.getAlias() + " is used as a local copy of " + ClassID.ASYNC_PAIR + ".  You have to delete the " + ClassID.ASYNC_PAIR + " first";
        }
        return null;
    }

    public boolean isInternal() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isInternal(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void setExposed(boolean exposed) {
        if (exposed != this.myIsExposed) {
            this.myIsExposed = exposed;
            try {
                ElementEventImpl event = new ElementEventImpl((Object)this, this);
                HashMap<ClientParameterCode, Boolean> parameterList = new HashMap<ClientParameterCode, Boolean>();
                parameterList.put(ClientParameterCode.VOLUME_EXPOSED, new Boolean(exposed));
                parameterList.put(ClientParameterCode.VOLUME_STATE, (Boolean)this.getVolumeState());
                event.setParameterList(parameterList);
                LogicMgrAOImpl.getInstance().__elementChanged(event);
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"A remote exception was thrown in server"});
            }
        }
    }

    @Override
    public boolean isFree() {
        return this.free;
    }

    @Override
    public void setFree(boolean free) {
        this.free = free;
    }

    @Override
    public int getBlockSize() {
        return this.getBlockSize(null);
    }

    public abstract int getBlockSize(VSwitchImpl var1);

    public double getBlockNum() {
        return this.getBlockNum(null);
    }

    public abstract double getBlockNum(VSwitchImpl var1);

    public abstract BigInteger getNumberOfBlocks(VSwitchImpl var1);

    @Override
    public void setParent(VolumeNode parent, int stam) {
        this.volumeParent = (VolumeImpl)parent;
        if (parent == null) {
            this.setFree(true);
        } else {
            this.setFree(false);
        }
    }

    public void removeParent() {
        this.setParent(null, 0);
    }

    @Override
    public VolumeImpl getParentVolume() {
        return this.volumeParent;
    }

    public VolumeImpl getParentVolume(VSwitchImpl vSwitch) {
        CommKeyClassId parentCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_PARENT, vSwitch == null);
        if (parentCommKeyClassId == null) {
            return null;
        }
        return (VolumeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parentCommKeyClassId);
    }

    @Override
    public LUImpl getParentLU() {
        return this.parentLU;
    }

    public LUImpl getParentLU(VSwitchImpl vSwitch) {
        CommKeyClassId parentCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_LU, vSwitch == null);
        if (parentCommKeyClassId == null) {
            return this.parentLU;
        }
        return (LUImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parentCommKeyClassId);
    }

    public void setParentLU(LUImpl parent) {
        this.parentLU = parent;
    }

    @Override
    public boolean isChildOfMirror() {
        if (this.getParentVolume() == null) {
            return false;
        }
        if (this.getParentVolume().getClassId().equals((Object)ClassID.MIRROR_VOLUME)) {
            return true;
        }
        return this.getParentVolume().isChildOfMirror();
    }

    public boolean isInvolvedInCopy() {
        return this.cluster.getCopyOperManager().isInvolvedInCopyOper(this.getCommKeyClassId());
    }

    public boolean isInvolvedInCopy(VSwitchImpl vSwitch) {
        return this.cluster.getCopyOperManager().isInvolvedInCopyOper(this.getCommKeyClassId(), vSwitch.getCommKeyClassId());
    }

    public boolean isInvolvedInActiveCopy(VSwitchImpl vSwitch) {
        return this.cluster.getCopyOperManager().isInvolvedInActiveCopyOper(this.getCommKeyClassId(), vSwitch.getCommKeyClassId());
    }

    public VSwitchImpl isInvolvedInActiveCopyDownHirarchy() {
        VSwitchImpl[] volumeVSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < volumeVSwitches.length; ++i) {
            if (!this.isInvolvedInActiveCopyDownHirarchy(volumeVSwitches[i])) continue;
            return volumeVSwitches[i];
        }
        return null;
    }

    public boolean isInvolvedInActiveCopyDownHirarchy(VSwitchImpl vSwitch) {
        if (this.getChildren() != null) {
            for (VolumeNodeImpl child : this.getChildren()) {
                if (!child.isInvolvedInActiveCopyDownHirarchy(vSwitch)) continue;
                return true;
            }
        }
        return this.cluster.getCopyOperManager().isInvolvedInActiveCopyOper(this.getCommKeyClassId(), vSwitch.getCommKeyClassId());
    }

    public CopyOperationImpl getCopyOperIfInvolved() throws RemoteException {
        return this.cluster.getCopyOperManager().getCopyForNode(this.getCommKeyClassId());
    }

    @Override
    public boolean isSnapshotSource() {
        return this.cluster.getVolumeMgr().getSnapshotManager().isSourceOfSnapshot(this);
    }

    public boolean isSnapshotSource(VSwitchImpl vSwitch) {
        return this.cluster.getVolumeMgr().getSnapshotManager().isSourceOfSnapshot(this, vSwitch);
    }

    public List<SnapshotVolumeImpl> getSnapshotsIfSource() {
        return this.cluster.getVolumeMgr().getSnapshotManager().getSnapshotsForSourceVolume(this);
    }

    private SrBITSConstant getState(VSwitchImpl vSwitch) {
        SrBITSConstant state = (SrBITSConstant)this.getSrValueOf(vSwitch, ParameterCode.VOLUME_STATE, vSwitch == null);
        return state;
    }

    public boolean isInState(VSwitchImpl vSwitch, SrType state) {
        SrBITSConstant volState = this.getState(vSwitch);
        if (volState != null) {
            return volState.contains((SrBITSConstant)state);
        }
        return false;
    }

    public boolean isInState(SrType state) {
        VSwitchImpl[] connectedVs = this.getConnectedVSwitches();
        for (int i = 0; i < connectedVs.length; ++i) {
            if (!this.isInState(connectedVs[i], state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNonFunctional() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isNonFunctional(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isNonFunctional(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, (SrType)VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL);
    }

    protected boolean isNeedSync() {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isNeedSync(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isNeedSync(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, (SrType)VolumeStateConstant.VOLUME_STATE_NEED_SYNC);
    }

    public boolean isInternal(VSwitchImpl vSwitch) {
        if (this.volumeParent == null) {
            return this.parentLU == null;
        }
        return false;
    }

    public boolean isSuspended(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, (SrType)VolumeStateConstant.VOLUME_STATE_SUSPENDED);
    }

    private SrBITSConstant getVolumeState(VSwitchImpl vSwitch) {
        VSwitchImpl vSwitchToGet = vSwitch;
        if (vSwitchToGet == null) {
            vSwitchToGet = this.getDominantVswitch();
        }
        SrBITSConstant state = (SrBITSConstant)this.getSrValueOf(vSwitchToGet, ParameterCode.VOLUME_STATE, vSwitchToGet == null);
        return state;
    }

    @Override
    public SrBITSConstant getVolumeState() throws RemoteException {
        return this.getVolumeState(null);
    }

    @Override
    public boolean isExposed() {
        return this.myIsExposed;
    }

    public boolean isExposed(VSwitchImpl vSwitch) {
        if (this.getParentLU(vSwitch) == null) {
            VolumeImpl parent = this.getParentVolume(vSwitch);
            if (parent != null) {
                return parent.isExposed(vSwitch);
            }
            return false;
        }
        return true;
    }

    public boolean isRetractable(VSwitchImpl vs) throws RemoteException {
        return this.isInState(vs, (SrType)VolumeStateConstant.VOLUME_STATE_RETRACTABLE);
    }

    protected VolumeNodeImpl getHeadOfVolumeTree() {
        VolumeNodeImpl headNode = this;
        for (VolumeImpl tmpParentNode = this.volumeParent; tmpParentNode != null; tmpParentNode = tmpParentNode.getParentVolume()) {
            headNode = tmpParentNode;
        }
        return headNode;
    }

    public LUImpl getHeadLU() {
        VolumeNodeImpl treeHead = this.getHeadOfVolumeTree();
        return treeHead.getParentLU();
    }

    protected Target getHeadTarget() throws RemoteException {
        if (this.parentLU != null) {
            return this.parentLU.getParentTarget();
        }
        return null;
    }

    public VSwitchImpl getExposedOnVSwitch() {
        LUImpl lu = this.getHeadLU();
        if (lu != null) {
            String vSwitchName = lu.getParentTarget().getExposedOnVSwitch();
            return this.getCluster().getVSwitchByName(vSwitchName);
        }
        return null;
    }

    public VSwitchImpl getVSwitchToSetForOfflineCopy() throws RemoteException {
        return this.getExposedOnVSwitch();
    }

    @Override
    public SrFuture<Void> replace(CommKeyClassId newVol) throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        ReplaceVolumeValidator validator = new ReplaceVolumeValidator(this.cluster, this, this.getAlias(), this.getChildren(), storage.getVolumeMgr(), (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newVol));
        CommKeyClassId[] vSwitchToSet = validator.forWhichVswitchIsValidData();
        if (vSwitchToSet == null || vSwitchToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData oldVol = new ConfigElementData(this.getCommKeys(), this.getClassId());
        oldVol.setValue(ParameterCode.VOLUME_OPERATION_DST, (SrType)newVol);
        oldVol.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchToSet);
        if (this.volumeParent != null) {
            CommKeyClassId parentVol = new CommKeyClassId(this.volumeParent.getCommKeys(), this.volumeParent.getClassId());
            oldVol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)parentVol);
            List<VolumeNodeImpl> myParentChildren = this.volumeParent.getChildren();
            CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
            for (int i = 0; i < myParentChildren.size(); ++i) {
                childrenData[i] = myParentChildren.get(i).getCommKeyClassId();
            }
            oldVol.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, (Object)childrenData));
        } else if (this.parentLU != null) {
            CommKeyClassId parentLu = new CommKeyClassId(this.parentLU.getCommKeys(), this.parentLU.getClassId());
            oldVol.setValue(ParameterCode.VIRTUAL_VOLUME_LU, (SrType)parentLu);
        } else {
            throw new IllegalValueException("Volume does not have any parent Volume or LU!");
        }
        return DataMgrAdapter.getInstance().operate(oldVol, VolumeOperationType.VOL_OPER_REPLACE_VOLUME);
    }

    @Override
    public SrFuture<Void> addMirror(CommKeyClassId newChild, String mirrVolAlias, boolean autoSync) throws RemoteException, IllegalValueException {
        VSwitchImpl[] vSwitchToSet;
        StorageImpl storage = this.cluster.getStorage();
        VolumeNodeImpl newChildVolume = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(newChild);
        List<VolumeNodeImpl> children = this.getChildren();
        if (children == null) {
            children = new ArrayList<VolumeNodeImpl>(2);
            children.add(this);
        }
        children.add(newChildVolume);
        AddMirrorValidator validator = new AddMirrorValidator(this.cluster, this, mirrVolAlias, this.getChildren(), storage.getVolumeMgr(), newChildVolume);
        if (this.volumeParent != null && this.volumeParent.getClassId().equals((Object)ClassID.MIRROR_VOLUME)) {
            validator.turnOffAliasValidation();
        }
        if ((vSwitchToSet = validator.forWhichVswitchIsValid()) == null || vSwitchToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        MirrVolConfigElementData vol = null;
        if (this.volumeParent != null) {
            if (this.volumeParent instanceof MirrorVolumeImpl) {
                return this.volumeParent.addMirror(newChild, mirrVolAlias, autoSync);
            }
            vol = new MirrVolConfigElementData(this.getCommKeys(), this.getClassId(), this.volumeParent.getActiveVswitch().getCommKeyClassId(), autoSync);
            CommKeyClassId parentVol = new CommKeyClassId(this.volumeParent.getCommKeys(), this.volumeParent.getClassId());
            vol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)parentVol);
            List<VolumeNodeImpl> myParentChildren = this.volumeParent.getChildren();
            CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
            for (int i = 0; i < myParentChildren.size(); ++i) {
                childrenData[i] = myParentChildren.get(i).getCommKeyClassId();
            }
            vol.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, (Object)childrenData));
        } else if (this.parentLU != null) {
            vol = new MirrVolConfigElementData(this.getCommKeys(), this.getClassId(), this.getActiveVswitch().getCommKeyClassId(), autoSync);
            CommKeyClassId luData = new CommKeyClassId(this.parentLU.getCommKeys(), this.parentLU.getClassId());
            vol.setValue(ParameterCode.VIRTUAL_VOLUME_LU, (SrType)luData);
        } else {
            throw new IllegalValueException("Cannot Upgrade Internal volume into Mirror volume.");
        }
        if (mirrVolAlias == null || mirrVolAlias.equals("")) {
            mirrVolAlias = CreateVolumeValidator.getDefaultAlias();
        }
        vol.setValue(ParameterCode.VOLUME_ALIAS, (SrType)new SrString(mirrVolAlias));
        vol.setValue(ParameterCode.VOLUME_OPERATION_DST, (SrType)newChild);
        return DataMgrAdapter.getInstance().operate((ConfigElementData)vol, VolumeOperationType.VOL_OPER_ADD_MIRROR);
    }

    @Override
    public SrFuture<Void> resize(CommKeyClassId newChild, String cubeVolAlias) throws RemoteException, IllegalValueException {
        if (cubeVolAlias == null || cubeVolAlias.equals("")) {
            cubeVolAlias = CreateVolumeValidator.getDefaultAlias();
        }
        StorageImpl storage = this.cluster.getStorage();
        VolumeNodeImpl newChildNode = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newChild);
        ResizeVolumeValidator validator = new ResizeVolumeValidator(this.cluster, this, cubeVolAlias, this.getChildren(), storage.getVolumeMgr(), newChildNode);
        CommKeyClassId[] vSToSet = validator.forWhichVswitchIsValidData(this.getConnectedVswitchesData());
        validator.isAllowedByDR();
        if (vSToSet == null || vSToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData vol = null;
        VolumeImpl parent = this.getParentVolume();
        if (parent != null) {
            if (parent instanceof ConcatinationVolume) {
                vol = new ConfigElementData(parent.getCommKeys(), parent.getClassId());
                List<VolumeNodeImpl> parentChildren = parent.getChildren();
                CommKeyClassId[] childrenData = new CommKeyClassId[parentChildren.size()];
                for (int i = 0; i < parentChildren.size(); ++i) {
                    childrenData[i] = parentChildren.get(i).getCommKeyClassId();
                }
                vol.addParameter((ParameterCodes)ParameterCode.VOLUME_CHILDREN, (Object)childrenData);
            } else {
                vol = new ConfigElementData(this.getCommKeys(), this.getClassId());
                CommKeyClassId parentVol = new CommKeyClassId(parent.getCommKeys(), parent.getClassId());
                vol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)parentVol);
                List<VolumeNodeImpl> myParentChildren = parent.getChildren();
                CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
                for (int i = 0; i < myParentChildren.size(); ++i) {
                    childrenData[i] = myParentChildren.get(i).getCommKeyClassId();
                }
                vol.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, (Object)childrenData));
            }
        } else {
            vol = new ConfigElementData(this.getCommKeys(), this.getClassId());
            if (this.parentLU != null) {
                CommKeyClassId luData = new CommKeyClassId(this.parentLU.getCommKeys(), this.parentLU.getClassId());
                vol.setValue(ParameterCode.VIRTUAL_VOLUME_LU, (SrType)luData);
            }
        }
        vol.setValue(ParameterCode.VOLUME_ALIAS, (SrType)new SrString(cubeVolAlias));
        vol.setValue(ParameterCode.VOLUME_OPERATION_DST, (SrType)newChild);
        return DataMgrAdapter.getInstance().operate(vol, VolumeOperationType.VOL_OPER_RESIZE);
    }

    @Override
    public SrFuture<Void> mirrorSync() throws RemoteException, IllegalValueException {
        VolumeImpl parentVolume = this.getParentVolume();
        if (!(parentVolume instanceof MirrorVolumeImpl)) {
            throw new IllegalValueException("Volume is not a child of Mirror Volume");
        }
        try {
            return this.mirrorSync((MirrorVolumeImpl)parentVolume, this);
        }
        catch (CopyAlreadyExistException copyE) {
            throw new IllegalValueException(copyE.getMessage());
        }
    }

    public SrFuture<Void> mirrorSync(MirrorVolumeImpl mirrVol, VolumeNodeImpl childToSync) throws RemoteException, IllegalValueException, CopyAlreadyExistException {
        VSwitchImpl vSwitchToSet = this.getVSwitchToSetForMirrSync(mirrVol, childToSync);
        VolumeNodeImpl syncSrc = mirrVol.getSyncSource(vSwitchToSet, childToSync);
        if (syncSrc == null) {
            throw new IllegalValueException("Cannot find source volume for the Mirror Sync on " + vSwitchToSet);
        }
        List<SnapshotVolumeImpl> snapshots = mirrVol.getSnapshotsIfSource();
        for (SnapshotVolumeImpl snap : snapshots) {
            if (!snap.isInvolvedInAnotherRestoreOperation()) continue;
            throw new IllegalValueException("You cannot mirror sync while the snapshot " + snap + " is copy data");
        }
        return this.getCluster().getCopyOperManager().addCopyOperation(syncSrc, childToSync, vSwitchToSet, VolumeOperationType.VOL_OPER_MIRROR_SYNC);
    }

    protected VSwitchImpl getVSwitchToSetForMirrSync(MirrorVolumeImpl mirrVol, VolumeNodeImpl childToSync) throws RemoteException, IllegalValueException, CopyAlreadyExistException {
        VSwitchImpl vSwitchToSet = mirrVol.getDominantVswitch();
        if (vSwitchToSet == null) {
            VSwitchImpl[] vswitches;
            for (VSwitchImpl vs : vswitches = this.getConnectedVSwitches()) {
                if (!childToSync.isKnownByVSwitch(vs)) continue;
                return vs;
            }
        } else if (!childToSync.isKnownByVSwitch(vSwitchToSet)) {
            throw new IllegalValueException(" You cannot activate mirror sync, since the child is not defined on " + ClassID.VSWITCH + " " + vSwitchToSet);
        }
        return vSwitchToSet;
    }

    @Override
    public SrFuture<Void> offlineCopy(CommKeyClassId dst) throws RemoteException, IllegalValueException {
        VSwitchImpl vSwitchToSet;
        DRAsyncPairImpl pair = (DRAsyncPairImpl)DRRootImpl.getInstance().getPairUsingLocalCopy((VolumeNodeImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(dst.getCommKeys(), dst.getClassID()));
        if (pair != null) {
            if (!pair.getLocalSnapshot().equals(this)) {
                throw new IllegalValueException("Cannot do offline copy on a local copy volume of pair " + pair);
            }
            if (pair.getLocalSnapshot().isInvolvedInCopy()) {
                return new CompleteFuture("VolumeNodeImpl.offlineCopy");
            }
        }
        if ((vSwitchToSet = this.getVSwitchToSetForOfflineCopy()) == null) {
            vSwitchToSet = this.getFirstVSwitch();
        }
        if (!vSwitchToSet.isConnected()) {
            vSwitchToSet = this.cluster.getOtherVSwitch(vSwitchToSet);
        }
        if (vSwitchToSet == null || !vSwitchToSet.isConnected()) {
            throw new IllegalValueException("Cannot find vSwitch for the Copy operation.");
        }
        VolumeNodeImpl dstNode = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(dst);
        try {
            return this.getCluster().getCopyOperManager().addCopyOperation(this, dstNode, vSwitchToSet, VolumeOperationType.VOL_OPER_OFFLINE_COPY);
        }
        catch (CopyAlreadyExistException copyE) {
            throw new IllegalValueException(copyE.getMessage());
        }
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        SnapshotManager snapshotMgr;
        SynchronizeableImpl parent;
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        SrType myParent = this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_PARENT);
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getAlias();
        if (aCED.containsParameter(ParameterCode.VOLUME_STATE)) {
            parent = this.getParentVolume();
            if (parent == null) {
                parent = this.getParentLU();
            }
            if (parent != null) {
                parent.childVolumeStateWasChanged();
            }
        }
        if (aCED.containsParameter(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS) || aCED.containsParameter(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS)) {
            parent = this.getParentVolume();
            if (parent == null) {
                parent = this.getParentLU();
            }
            if (parent != null) {
                parent.childCapacityWasChanged();
            }
        }
        if (changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_PARENT) && (myParent == null || myParent != null && !myParent.equals(changedValues.get(ParameterCode.VIRTUAL_VOLUME_PARENT))) && (snapshotMgr = this.cluster.getStorage().getVolumeMgr().getSnapshotManager()).isSourceOfSnapshot(this)) {
            List<SnapshotVolumeImpl> snapshots = snapshotMgr.getSnapshotsForSourceVolume(this);
            for (SnapshotVolumeImpl snapshotVol : snapshots) {
                if (!snapshotVol.isKnownByVSwitch(vSwitch) || !vSwitch.isConnected()) continue;
                ConfigElementData element = new ConfigElementData(snapshotVol.getCommKeyClassId());
                element.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (SrType)null);
                CommKeyClassId[] vSwitchData = new CommKeyClassId[]{vSwitch.getCommKeyClassId()};
                element.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchData);
                ErrorAssertingListener.listenTo(this.refreshFields(element));
            }
        }
        return changedValues;
    }

    public VolumeImpl getParentInVSwitch(VSwitchImpl vSwitch) {
        CommKeyClassId parent = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_PARENT, vSwitch == null);
        return (VolumeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parent);
    }

    public Integer getPositionInParent(VSwitchImpl vSwitch) {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.VOLUME_POSITION, vSwitch == null);
    }

    @Override
    public Integer getPositionInParent() {
        return this.getPositionInParent(null);
    }

    public boolean isIllegalDownHierarchy() {
        return false;
    }

    public boolean isIllegalUpHierarchy() {
        if (this.volumeParent != null) {
            return this.volumeParent.isIllegalUpHierarchy();
        }
        if (this.parentLU != null) {
            return !this.getHeadLU().isLegitimateForVolumeOperation();
        }
        return false;
    }

    @Override
    public boolean isLegitimateForVolumeOperation() throws RemoteException {
        return !this.isIllegalDownHierarchy() && !this.isIllegalUpHierarchy();
    }

    public boolean isDiskMissingDownHierarchy(VSwitchImpl vswitch) {
        return this.isInState(vswitch, (SrType)PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_MISSING);
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                int retVal = this.synchronizeMe();
                switch (retVal) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        this.errorInSynchronizing();
                    }
                }
                return;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    @Override
    public void doneSynchronizing() throws RemoteException {
        super.doneSynchronizing();
        LUImpl luParent = this.getParentLU();
        try {
            if (luParent != null) {
                luParent.synchronizeMe();
            }
        }
        catch (IllegalValueException e) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)e), new Object[]{"got an illegal value exception."});
        }
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        if (this.volumeParent != null) {
            return this.getParentVolume().getDominantVswitch();
        }
        VSwitchImpl[] vswitches = this.getConnectedVSwitches();
        LUImpl parentLu = this.getParentLU();
        if (parentLu != null) {
            String result = parentLu.getParentTarget().getExposedOnVSwitch();
            for (int i = 0; i < vswitches.length; ++i) {
                if (!vswitches[i].getName().equals(result) || !vswitches[i].isConnected()) continue;
                return vswitches[i];
            }
        }
        return super.getDominantVswitch();
    }

    public boolean isUsedByAPair() {
        return DRRootImpl.getInstance().getPairUsingVolume(this) != null;
    }

    public boolean isDROfflineLocalCopy() {
        return DRRootImpl.getInstance().getPairUsingLocalCopy(this) != null;
    }

    public ConfigElementData getDuplicationConfigElementData(HashMap devices, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"building CED for ", this});
        ConfigElementData element = new ConfigElementData(ClassID.VOLUME_OPERATION);
        List<VolumeNodeImpl> children = this.getChildren();
        if (children != null && !children.isEmpty()) {
            ConfigElementDataList childrenElementList = new ConfigElementDataList();
            for (VolumeNodeImpl child : children) {
                childrenElementList.add((ElementData)child.getDuplicationConfigElementData(devices, remoteCluster));
            }
            element.setValue(ParameterCode.VOLUME_CHILDREN, childrenElementList);
        } else {
            try {
                this.createIscsiDisk(devices, element, remoteCluster);
            }
            catch (IllegalAccessException e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"got an illegal value exception."});
            }
        }
        this.updateElementWithCreationParameters(element, remoteCluster);
        return element;
    }

    protected void createIscsiDisk(HashMap devices, ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalAccessException, IllegalValueException {
        this.updateElementWithCreationParameters(element, remoteCluster);
    }

    @Override
    public void updateElementWithCreationParameters(ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
        String alias = this.getAliasForRemote(remoteCluster, this.getAlias());
        element.addParameter(new Parameter(this.getParameterCode((ParameterCodes)MasterParameterCode.ALIAS), (Object)new SrString(alias)));
    }

    private String getAliasForRemote(ClusterImpl remoteCluster, String alias) throws RemoteException, IllegalValueException {
        if (this.isAliasAlreadyExsist(remoteCluster, alias)) {
            alias = this.getAliasForRemote(remoteCluster, alias + "_cfg");
        }
        return alias;
    }

    protected boolean isAliasAlreadyExsist(ClusterImpl remoteCluster, String alias) throws RemoteException, IllegalValueException {
        Storageable remoteStorage = remoteCluster.getStorage().getStorageByAlias(alias);
        return remoteStorage != null;
    }

    @Override
    protected LogicObjectImpl findEquivelentElement(ClusterImpl cluster, LogicObjectImpl volChild) throws RemoteException, IllegalValueException {
        if (volChild != null) {
            if (this.equals(((VolumeNodeImpl)volChild).getParentVolume())) {
                return ((VolumeNodeImpl)volChild).getParentVolume();
            }
            throw new IllegalValueException(" the configured volume you gave has already exsist with a diffrent parameters");
        }
        return null;
    }

    public ConfigElementDataList removeVolumeTree() throws RemoteException {
        ConfigElementDataList elementList = new ConfigElementDataList();
        if (this.isExposed()) {
            ConfigElementData element = new ConfigElementData(this.getParentLU().getCommKeyClassId());
            element.setValue(ParameterCode.LU_VOLUME_ID, (SrType)this.getCommKeyClassId());
            elementList.add((ElementData)element);
        }
        elementList = this.buildCedListForRemoveVolumeTree(new Vector(), elementList);
        elementList.removeEqualElements();
        return elementList;
    }

    public ConfigElementDataList removeVolumeTree(SnapshotVolumeImpl sns) throws RemoteException {
        ConfigElementDataList elementList = new ConfigElementDataList();
        elementList.add((ElementData)new ConfigElementData(sns.getCommKeyClassId()));
        elementList.addAll((Collection)this.buildCedListForRemoveVolumeTree(new Vector(), elementList));
        elementList.removeEqualElements();
        return elementList;
    }

    public VolumeNodeImpl findEquivelentInternalVolume(ClusterImpl cluster) {
        List<? extends VolumeNodeImpl> volumes = cluster.getStorage().getInteranlVolumesByType(this.getClassId());
        for (int i = 0; i < volumes.size(); ++i) {
            VolumeNodeImpl vol = volumes.get(i);
            if (!this.equals(vol)) continue;
            return vol;
        }
        return null;
    }

    public VolumeNodeImpl getRootVolume() {
        VolumeImpl parent = this.getParentVolume();
        if (parent != null) {
            return parent.getRootVolume();
        }
        return this;
    }

    public abstract ConfigElementDataList buildCedListForRemoveVolumeTree(Vector var1, ConfigElementDataList var2) throws RemoteException;

    public GeneralSCSIDevice[] getDisksOfVolume() {
        List<VolumeNodeImpl> devices = this.getDevicesOfVolume();
        ArrayList<GeneralSCSIDevice> disks = new ArrayList<GeneralSCSIDevice>();
        for (VolumeNodeImpl device : devices) {
            if (device instanceof SubDirectAccessDeviceImpl) {
                disks.add(((SubDirectAccessDeviceImpl)device).getDirectAccessDeviceParent());
                continue;
            }
            disks.add((GeneralSCSIDevice)((Object)device));
        }
        return disks.toArray(new GeneralSCSIDevice[disks.size()]);
    }

    public List<VolumeNodeImpl> getDevicesOfVolume() {
        ArrayList<VolumeNodeImpl> devices = new ArrayList<VolumeNodeImpl>();
        if (this.getClassId().isStorage()) {
            devices.add(this);
        } else {
            for (VolumeNodeImpl child : this.getChildren()) {
                devices.addAll(child.getDevicesOfVolume());
            }
        }
        return devices;
    }

    public boolean isPreventLocalCopy(HashSet set, ClusterImpl remoteCluster) throws IllegalValueException {
        if (this.isExposed() || this.getClassId().equals((Object)ClassID.JOURNAL_VOLUME) || this.getClassId().equals((Object)ClassID.SNAPSHOT_VOLUME) || this.isUsedByAPair() || this.isSnapshotSource() || this.isInvolvedInCopy()) {
            return false;
        }
        if (this.getPairUseingLocalCopy() != null && this.getPairUseingLocalCopy().getRemoteElement() != null && !this.getPairUseingLocalCopy().getRemoteElement().getCluster().equals(remoteCluster)) {
            return false;
        }
        if (this.getChildren() != null) {
            DRRootImpl.getInstance().localCopyAllowed(set, this, remoteCluster);
        }
        return true;
    }

    public DRAsyncPairImpl getPairUseingLocalCopy() {
        return (DRAsyncPairImpl)DRRootImpl.getInstance().getPairUsingLocalCopy(this);
    }

    @Override
    public abstract BigInteger getAccessibleSpace();

    public abstract List<VolumeNodeImpl> getChildren();

    @Override
    public abstract boolean isProvisioned();

    @Override
    public abstract String getAlias();

    @Override
    public abstract int getChildrenOfVirtualVolumeTypeCount();

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VIRTUAL_VOLUME_PARENT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.VOLUME_POSITION, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

