/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeForest;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class VolumeManager {
    private static SrLogger theLogger = SrLogger.getLogger();
    private VolumeForest volumeForest;
    private TargetList targetList;
    private ClusterImpl cluster;
    private SnapshotManager snapshotManger = new SnapshotManager();

    public VolumeManager(TargetList targetList, VolumeForest volumeForest, ClusterImpl cluster) {
        this.volumeForest = volumeForest;
        this.targetList = targetList;
        this.cluster = cluster;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManger;
    }

    public void clear() {
        this.volumeForest.removeAll();
        this.targetList.removeAll();
        this.snapshotManger.removeAll();
    }

    public VolumeImpl getVolumeByAlias(String aAlias) {
        if (aAlias == null || aAlias.equals("")) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given alias is invalid. aAlias = ", aAlias});
            return null;
        }
        VolumeImpl retVal = null;
        retVal = this.volumeForest.getVolumeByAlias(aAlias);
        if (retVal != null) {
            return retVal;
        }
        retVal = this.targetList.getVolumeByAlias(aAlias);
        if (retVal != null) {
            return retVal;
        }
        return null;
    }

    public <T> List<T> getRootVolumeByType(Class<T> aType, ClassID aClassId) {
        if (aType == null || aClassId == null) {
            throw new IllegalArgumentException("The given arguments should not be null. aType = " + aType + "; aClassId = " + aClassId);
        }
        ArrayList<VolumeNodeImpl> retVal = new ArrayList<VolumeNodeImpl>();
        for (VolumeTreeImpl curVol : this.volumeForest.getAll()) {
            VolumeNodeImpl curVolNode = curVol.getRoot();
            if (!aClassId.equals((Object)curVolNode.getClassId())) continue;
            retVal.add(curVolNode);
        }
        for (ISCSITargetImpl target : this.targetList.getAll()) {
            for (LUImpl lu : target.getLUs()) {
                VolumeNodeImpl volume = lu.getVolumeChild();
                if (!aClassId.equals((Object)volume.getClassId())) continue;
                retVal.add(volume);
            }
        }
        return retVal;
    }

    public boolean isAliasExist(String alias) {
        if (this.volumeForest.isAliasExist(alias)) {
            return true;
        }
        if (this.targetList.isVolumeAliasExist(alias)) {
            return true;
        }
        for (GeneralSCSIDeviceImpl device : this.cluster.getStoragePool().getAll()) {
            SubDirectAccessDeviceImpl subDisk;
            if (device instanceof DirectAccessDeviceImpl && (subDisk = ((DirectAccessDeviceImpl)device).getSubDirectAccessDevice(alias)) != null) {
                CopyOperationImpl copyOper = this.cluster.getCopyOperManager().getCopyForNode(subDisk.getCommKeyClassId());
                if (subDisk.getParentLU() != null || subDisk.getParentVolume() != null || copyOper != null) {
                    return true;
                }
            }
            CopyOperationImpl copyOper = this.cluster.getCopyOperManager().getCopyForNode(device.getCommKeyClassId());
            if (!device.getAlias().equals(alias) || device.getParentLU() == null && device.getParentVolume() == null && copyOper == null) continue;
            return true;
        }
        return false;
    }

    public int getTotalVolumeCount(TargetList targetList) throws RemoteException {
        return this.volumeForest.getTotalVolumeCount() + targetList.getTotalVolumeCount();
    }

    public boolean removeVolumeFromForest(VolumeNodeImpl volume) {
        if (volume instanceof Volume) {
            ((VolumeImpl)volume).unRegisterToPropagatedStateListenerForAllLeafs(this.cluster);
            return this.volumeForest.removeVolumeTree((Volume)((Object)volume));
        }
        this.cluster.removePropagationStateDependentObjectAndListener(volume);
        return false;
    }

    public SrFuture<Void> readSnapshotVolumes() throws RemoteException {
        if (!this.cluster.getVSwitches().isEmpty()) {
            ConfigElementData element = new ConfigElementData(ClassID.SNAPSHOT_VOLUME);
            element.setValue(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, (SrType)null);
            List<VSwitchImpl> vSwitches = this.cluster.getConnectedVSwitchesAsList();
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.size()];
            for (int i = 0; i < vSwitches.size(); ++i) {
                vSwitchesData[i] = new CommKeyClassId(((VSwitch)vSwitches.get(i)).getCommKeys(), ((VSwitch)vSwitches.get(i)).getClassId());
            }
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchesData));
            return DataMgrAdapter.getInstance().refreshTableFields(element);
        }
        return new CompleteFuture("VolumeManager.readSnapshotVolumes");
    }

    private List<String> getAllVolumeAliases(VolumeNodeImpl aVolume) {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(aVolume.getAlias());
        List<VolumeNodeImpl> children = aVolume.getChildren();
        if (children != null) {
            for (VolumeNodeImpl child : children) {
                aliases.addAll(this.getAllVolumeAliases(child));
            }
        }
        return aliases;
    }

    public List<String> getAllVolumesAliases() {
        ArrayList<String> allAliasesList = new ArrayList<String>();
        for (VolumeNodeImpl exposedVolume : this.targetList.getAllVolumeRoots()) {
            allAliasesList.addAll(this.getAllVolumeAliases(exposedVolume));
        }
        for (VolumeTreeImpl volumeTree : this.volumeForest.getAll()) {
            allAliasesList.addAll(this.getAllVolumeAliases(volumeTree.getRoot()));
        }
        return allAliasesList;
    }
}

