/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.TransparentVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.NonVirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.TransparentVolume;
import com.sanrad.nms.server.logic.volume.validators.TransparentVolumeSyncValidator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TransparentVolumeImpl
extends NonVirtualVolumeImpl
implements TransparentVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public TransparentVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.TRANSPARENT_VOLUME, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        TransparentVolumeSyncValidator validator = new TransparentVolumeSyncValidator(this.cluster, this.getAlias(), (GeneralSCSIDeviceImpl)this.getChildren().get(0), storage.getVolumeMgr(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ErrorAssertingListener.listenTo(storage.createTransparentVolume(this.getAlias(), (GeneralSCSIDeviceImpl)this.getChildren().get(0), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getConnectedVSwitches()[0], this.getCommKeyClassId()));
        return 2;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return TransparentVolumeAlarmGenerator.getInstance();
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

