/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.SnapshotAlarmGenerator;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.RestoreOperationImpl;
import com.sanrad.nms.server.logic.volume.snapshot.SnapshotSchedulerImpl;
import com.sanrad.nms.server.logic.volume.validators.SnapshotVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnapshotVolumeImpl
extends VirtualVolumeImpl
implements SnapshotVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private RestoreOperationImpl m_restoreOperation = null;

    public SnapshotVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SNAPSHOT_VOLUME, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public Long getDateAndTime() throws RemoteException {
        return this.getDateAndTime(this.getSourceExposedOnVSwitch());
    }

    public Long getDateAndTime(VSwitchImpl vSwitch) {
        Long dateAndTime = (Long)this.getValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, vSwitch == null);
        return dateAndTime;
    }

    @Override
    public int getPercentageLoad() throws RemoteException {
        return this.getPercentageLoad(this.getSourceExposedOnVSwitch());
    }

    public int getPercentageLoad(VSwitchImpl vSwitch) {
        Integer percentLoad = (Integer)this.getValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, vSwitch == null);
        if (percentLoad != null) {
            return percentLoad;
        }
        return -1;
    }

    @Override
    public int getPercentageThreshold() throws RemoteException {
        return this.getPercentageThreshold(this.getSourceExposedOnVSwitch());
    }

    public int getPercentageThreshold(VSwitchImpl vSwitch) {
        Integer percentThresh = (Integer)this.getValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, vSwitch == null);
        if (percentThresh != null) {
            return percentThresh;
        }
        return -1;
    }

    @Override
    public VolumeNodeImpl getSourceVolume() {
        return this.getSourceVolume(null);
    }

    public VolumeNodeImpl getSourceVolume(VSwitchImpl vSwitch) {
        CommKeyClassId sourceCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_SOURCE, vSwitch == null);
        if (sourceCommKeyClassId == null) {
            return null;
        }
        VolumeNodeImpl source = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(sourceCommKeyClassId);
        if (source == null) {
            source = this.cluster.getVolumeMgr().getSnapshotManager().getSourceOfSnapshot(this, vSwitch);
        }
        return source;
    }

    public SnapshotConfigFlagsConstant getConfigFlags() {
        return (SnapshotConfigFlagsConstant)this.getSrValueOf(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS);
    }

    @Override
    public boolean isOutOfSync() throws RemoteException {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isOutOfSync(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isOutOfSync(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, (SrType)VolumeStateConstant.VOLUME_STATE_OUT_OF_SYNC);
    }

    public boolean isModified() throws RemoteException {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isModified(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isModified(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, (SrType)VolumeStateConstant.VOLUME_STATE_WRITTEN);
    }

    public boolean isIllegalSnapshotSource() throws RemoteException {
        VSwitchImpl[] connectedVs = this.getConnectedVSwitches();
        VolumeNodeImpl source = this.getSourceVolume(connectedVs[0]);
        if (source == null) {
            return true;
        }
        for (int i = 1; i < connectedVs.length; ++i) {
            if (source.equals(this.getSourceVolume(connectedVs[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return SnapshotAlarmGenerator.getInstance();
    }

    @Override
    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws IllegalValueException {
        if (parameterList.containsKey(ClientParameterCode.SNAPSHOT_ACTIVATE)) {
            SnapshotActivateTypeConstants sat = (SnapshotActivateTypeConstants)parameterList.get(ClientParameterCode.SNAPSHOT_ACTIVATE);
            VSwitchImpl[] connectedVswitch = this.getConnectedVSwitches();
            ArrayList<CommKeyClassId> vswitchesToChangeSnapshotActiveState = new ArrayList<CommKeyClassId>(connectedVswitch.length);
            for (VSwitchImpl currentVSwitch : connectedVswitch) {
                SnapshotActivateTypeConstants currentActiveStateByVSwitch = this.getActivatedState(currentVSwitch);
                if (currentActiveStateByVSwitch.equals((Object)sat)) continue;
                vswitchesToChangeSnapshotActiveState.add(new CommKeyClassId(currentVSwitch.getCommKeys(), currentVSwitch.getClassId()));
            }
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[vswitchesToChangeSnapshotActiveState.size()];
            vSwitchCommKeyClassId = vswitchesToChangeSnapshotActiveState.toArray(vSwitchCommKeyClassId);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchCommKeyClassId));
        }
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        SnapshotVolumeSyncValidator validator = new SnapshotVolumeSyncValidator(this.cluster, this.getSourceVolume(), this.getAlias(), this.getChildren().get(0), this.getPercentageThreshold(), storage.getVolumeMgr(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ErrorAssertingListener.listenTo(storage.createSnapshotVolume(this.getAlias(), this.getSourceVolume(), this.getChildren().get(0), this.getPercentageThreshold(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getConnectedVSwitches()[0], this.getCommKeyClassId()));
        return 2;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String valid = super.isValid(parameterList);
        if (valid == null) {
            SnapshotActivateTypeConstants activateOpType;
            Integer threshold = (Integer)parameterList.get(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD);
            if (threshold != null) {
                int val = threshold;
                if (val < 0 || val > 100) {
                    return ErrorMessage.SNAPSHOT_THRESHOLD_INVALID.getMessage(threshold.toString());
                }
                parameterList.put(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, new SrInteger(threshold));
            }
            if ((activateOpType = (SnapshotActivateTypeConstants)parameterList.get(ClientParameterCode.SNAPSHOT_ACTIVATE)) != null) {
                boolean isNowInActiveOp = this.getActivatedState().equals((Object)SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
                if (activateOpType.equals((Object)SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE) && isNowInActiveOp || activateOpType.equals((Object)SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE) && !isNowInActiveOp) {
                    String[] parts = new String[]{this.toString(), activateOpType.toString()};
                    return ErrorMessage.SNAPSHOT_ACTIVATE_INVALID.getMessage(parts);
                }
                parameterList.put(ClientParameterCode.SNAPSHOT_ACTIVATE, activateOpType);
            }
        }
        return valid;
    }

    @Override
    public BigInteger getAccessibleSpace() {
        return this.getAccessibleSpace(this.getSourceExposedOnVSwitch());
    }

    @Override
    public BigInteger getAccessibleSpace(VSwitchImpl vSwitch) {
        VolumeNodeImpl sourceVolume = this.getSourceVolume(vSwitch);
        if (sourceVolume != null) {
            return sourceVolume.getAccessibleSpace();
        }
        return null;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        boolean isVSwitchAddedForRedundancy;
        VolumeNodeImpl newSourceVolume;
        int oldNumberOfVSwitches = this.getConnectedVSwitchCounter();
        Long oldDate = this.getDateAndTime();
        int oldPercentageLoad = this.getPercentageLoad();
        int oldPercentageThreshold = this.getPercentageThreshold();
        SnapshotActivateTypeConstants oldActivate = this.getActivatedState();
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        VolumeNodeImpl oldSource = this.getSourceVolume(vSwitch);
        HashMap changedValues = super.changeParameterList(aCED);
        if (changedValues.containsKey(ParameterCode.SNAPSHOT_VOLUME_SOURCE) && (newSourceVolume = this.getSourceVolume(vSwitch)) != null) {
            this.cluster.getVolumeMgr().getSnapshotManager().addSnapshot(newSourceVolume, this, vSwitch);
            newSourceVolume.addSynchronizeListener(this);
            if (oldSource != null && !oldSource.equals(newSourceVolume)) {
                this.cluster.getVolumeMgr().getSnapshotManager().removeSnapshotBySource(this, oldSource, vSwitch);
                VolumeNodeImpl otherVsSource = this.getSourceVolume(this.cluster.getOtherVSwitch(vSwitch));
                if (!oldSource.equals(otherVsSource)) {
                    oldSource.removeSynchronizeListener(this);
                }
            }
        }
        int newNumberOfVSwitches = this.getConnectedVSwitchCounter();
        boolean bl = isVSwitchAddedForRedundancy = oldNumberOfVSwitches > 0 && oldNumberOfVSwitches < newNumberOfVSwitches;
        if (isVSwitchAddedForRedundancy) {
            HashMap<Object, Number> paramsForChangeEvent = new HashMap<Object, Number>();
            Long newDate = this.getDateAndTime();
            int newPercentageLoad = this.getPercentageLoad();
            int newPercentageThreshold = this.getPercentageThreshold();
            SnapshotActivateTypeConstants newActivate = this.getActivatedState();
            if (oldDate == null && newDate != null) {
                paramsForChangeEvent.put(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, newDate);
            }
            if (oldPercentageLoad < 0 && newPercentageLoad >= 0) {
                paramsForChangeEvent.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, new Integer(newPercentageLoad));
            }
            if (oldPercentageThreshold < 0 && newPercentageThreshold >= 0) {
                paramsForChangeEvent.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, new Integer(newPercentageThreshold));
            }
            if (oldActivate == null && newActivate != null) {
                paramsForChangeEvent.put(ClientParameterCode.SNAPSHOT_ACTIVATE, (Number)newActivate);
            }
            if (!paramsForChangeEvent.isEmpty()) {
                ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
                elementEvent.setParameterList(paramsForChangeEvent);
                LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
            }
        }
        return changedValues;
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        VolumeNodeImpl sourceVol;
        String msg = super.canBeSynchronized();
        if (msg == null && (sourceVol = this.getSourceVolume()).isNeedToSynchronize()) {
            if (!sourceVol.isSynchronizePending()) {
                StringBuffer message = new StringBuffer("Cannot synchronize Snapshot volume ");
                message.append(this.getAlias());
                message.append(". Source volume ");
                message.append(sourceVol.getAlias());
                message.append(" need to be synchronized first.");
                msg = message.toString();
                throw new IllegalValueException(msg.toString());
            }
            return sourceVol.getClassId() + " " + sourceVol + " is not synchronized yet";
        }
        return msg;
    }

    @Override
    protected String canBeDeleted() {
        String errorMsg = super.canBeDeleted();
        if (errorMsg != null) {
            return errorMsg;
        }
        SnapshotSchedulerImpl scheduler = this.cluster.getSnapshotSchedulerMgr().getSchedulerForSnapshot(this);
        if (scheduler != null && scheduler.isRunning()) {
            return this.getClassId().toString() + " " + this.getAlias() + " belongs to a running " + ClassID.SNAPSHOT_SCHEDULER + ".  You have to stop the " + ClassID.SNAPSHOT_SCHEDULER + " first";
        }
        return null;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        List<VolumeNodeImpl> childrenVec = this.getChildren();
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[childrenVec.size()];
        for (int i = 0; i < childrenVec.size(); ++i) {
            VolumeNodeImpl child = childrenVec.get(i);
            childrenCommKeyClassId[i] = new CommKeyClassId(child.getCommKeys(), child.getClassId());
        }
        Parameter childrenParameter = new Parameter(ParameterCode.VOLUME_CHILDREN, (Object)childrenCommKeyClassId);
        ced.addParameter(childrenParameter);
        VolumeNodeImpl srcVol = this.getSourceVolume();
        ced.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (SrType)srcVol.getCommKeyClassId());
        return this.deleteElement(ced);
    }

    public boolean isOverUsed(VSwitchImpl vSwitch) {
        int thresh;
        int load = this.getPercentageLoad(vSwitch);
        return load >= (thresh = this.getPercentageThreshold(vSwitch));
    }

    public boolean isFull(VSwitchImpl vSwitch) {
        int load = this.getPercentageLoad(vSwitch);
        return this.isOutOfSync(vSwitch) && load == 100;
    }

    @Override
    public SrFuture<Void> setActivedState(SnapshotActivateTypeConstants state) {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_ACTIVATE, (Object)state));
        return DataMgrAdapter.getInstance().changeElement(element);
    }

    @Override
    public SnapshotActivateTypeConstants getActivatedState() {
        return this.getActivatedState(this.getSourceExposedOnVSwitch());
    }

    public SnapshotActivateTypeConstants getActivatedState(VSwitchImpl vSwitch) {
        SnapshotActivateTypeConstants snapShotActiveState = (SnapshotActivateTypeConstants)this.getSrValueOf(vSwitch, ParameterCode.SNAPSHOT_ACTIVATE, vSwitch == null);
        return snapShotActiveState;
    }

    public boolean isInActiveState() {
        SnapshotActivateTypeConstants snapshotActiveState = this.getActivatedState();
        return snapshotActiveState != null && snapshotActiveState.equals((Object)SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
    }

    private VSwitchImpl getSourceExposedOnVSwitch() {
        VSwitchImpl vSwitch = null;
        VolumeNodeImpl sourceVolume = this.getSourceVolume();
        if (sourceVolume != null && sourceVolume.isExposed() && sourceVolume.getParentLU() != null && sourceVolume.getParentLU().getParentTarget() != null) {
            String vSwitchName = sourceVolume.getParentLU().getParentTarget().getExposedOnVSwitch();
            ClusterImpl cluster = this.getCluster();
            vSwitch = cluster.getVSwitchByName(vSwitchName);
            if (vSwitch != null && !vSwitch.isConnected()) {
                vSwitch = cluster.getOtherVSwitch(vSwitch);
            }
        }
        return vSwitch;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap list = super.getClientParameterList();
        list.put(ClientParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, this.getDateAndTime());
        list.put(ClientParameterCode.SNAPSHOT_VOLUME_LOAD, new Integer(this.getPercentageLoad()));
        list.put(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, new Integer(this.getPercentageThreshold()));
        list.put(ClientParameterCode.SNAPSHOT_ACTIVATE, this.getActivatedState());
        if (this.m_restoreOperation != null) {
            list.put(ClientParameterCode.SNAPSHOT_RESTORE_OPERATION, this.m_restoreOperation);
        }
        return list;
    }

    @Override
    public SrFuture<Void> restore() throws RemoteException, IllegalValueException {
        VSwitchImpl vSwitchToSet = this.getExposedOnVSwitch();
        if (vSwitchToSet == null) {
            vSwitchToSet = this.getFirstVSwitch();
        }
        if (!vSwitchToSet.isConnected()) {
            vSwitchToSet = this.cluster.getOtherVSwitch(vSwitchToSet);
        }
        if (vSwitchToSet == null || !vSwitchToSet.isConnected()) {
            throw new IllegalValueException("Cannot find a V-Switch for the Restore operation.");
        }
        try {
            return this.getCluster().getCopyOperManager().addCopyOperation(this, this.getSourceVolume(), vSwitchToSet, VolumeOperationType.VOL_OPER_RESTORE);
        }
        catch (CopyAlreadyExistException copyE) {
            throw new IllegalValueException(copyE.getMessage());
        }
    }

    public void setRestoreOperation(RestoreOperationImpl restoreOperation) {
        this.m_restoreOperation = restoreOperation;
    }

    public RestoreOperationImpl getRestoreOperation() {
        return this.m_restoreOperation;
    }

    public boolean isInvolvedInAnotherRestoreOperation() {
        if (this.getRestoreOperation() != null) {
            VSwitchImpl[] connectedVswitches;
            for (VSwitchImpl vswitch : connectedVswitches = this.m_restoreOperation.getConnectedVSwitches()) {
                if (!vswitch.isConnected()) continue;
                return !this.getRestoreOperation().getCopyStatus().equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK);
            }
        }
        return false;
    }

    @Override
    public VSwitchImpl getVSwitchToSetForOfflineCopy() throws RemoteException {
        VSwitchImpl vswitch = super.getExposedOnVSwitch();
        if (vswitch == null) {
            VolumeNodeImpl snapshotSource = this.getSourceVolume();
            return snapshotSource.getExposedOnVSwitch();
        }
        return null;
    }

    @Override
    public synchronized boolean isNeedToSynchronize() throws RemoteException {
        boolean isVolumeNeedToSync = super.isNeedToSynchronize();
        if (!isVolumeNeedToSync) {
            return !this.isConsistentBetweenVSwitches(ParameterCode.SNAPSHOT_ACTIVATE);
        }
        return true;
    }

    @Override
    protected synchronized int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isNeedToSynchronize()) {
            if (!this.isConsistentBetweenVSwitches(ParameterCode.SNAPSHOT_ACTIVATE)) {
                SnapshotActivateTypeConstants activeVSwitchActivate = (SnapshotActivateTypeConstants)this.getParameters(this.getActiveVswitch()).get(ParameterCode.SNAPSHOT_ACTIVATE).getValue();
                HashMap<ParameterCode, SnapshotActivateTypeConstants> activateParamList = new HashMap<ParameterCode, SnapshotActivateTypeConstants>();
                activateParamList.put(ParameterCode.SNAPSHOT_ACTIVATE, SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
                ParameterList list = new ParameterList(activateParamList);
                if (activeVSwitchActivate.equals((Object)SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE)) {
                    ErrorAssertingListener.listenTo(this.changeElementInInactiveVswitch(list));
                } else {
                    ErrorAssertingListener.listenTo(this.changeElementForActiveVswitch(list));
                }
                return 2;
            }
            return 0;
        }
        return super.synchronizeMe();
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (this.isConsistentBetweenVSwitches(ParameterCode.SNAPSHOT_ACTIVATE)) {
            super.syncDataWasChanged();
        }
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        if (this.isInternal()) {
            VSwitchImpl result;
            CommKeyClassId volCommKeyClassId = this.getCommKeyClassIdValueOf(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(volCommKeyClassId);
            if (vol != null && this.isKnownByVSwitch(result = vol.getActiveVswitch())) {
                return result;
            }
        }
        return super.getDominantVswitch();
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = super.getParamsForCreation();
        params.add(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        params.add(ParameterCode.SNAPSHOT_ACTIVATE);
        params.add(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH);
        return params;
    }

    @Override
    public List<ConfigElementData> getCedForDeletion() {
        SnapshotConfigFlagsConstant configFlags;
        List<ConfigElementData> deletionCedList = super.getCedForDeletion();
        if (SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE.equals((Object)this.getActivatedState())) {
            ConfigElementData deactivateCed = new ConfigElementData(this.getCommKeyClassId(), ConfigOperation.CHANGE);
            deactivateCed.setValue(ParameterCode.SNAPSHOT_ACTIVATE, (SrType)SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE);
            deletionCedList.add(0, deactivateCed);
        }
        if ((configFlags = this.getConfigFlags()) != null) {
            ConfigElementData flagsCed = new ConfigElementData(this.getCommKeyClassId(), ConfigOperation.CHANGE);
            SnapshotConfigFlagsConstant newFlags = (SnapshotConfigFlagsConstant)configFlags.turnOffBitConstant((SrBITSConstant)SnapshotConfigFlagsConstant.SCHEDULED_BASED);
            newFlags = (SnapshotConfigFlagsConstant)newFlags.turnOffBitConstant((SrBITSConstant)SnapshotConfigFlagsConstant.EXTERNAL_SCHEDULER);
            flagsCed.setValue(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, (SrType)newFlags);
            deletionCedList.add(0, flagsCed);
        }
        return deletionCedList;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_VOLUME_SOURCE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_ACTIVATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

