/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class SnapshotMap {
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<VolumeNodeImpl, List<SnapshotVolumeImpl>> snapshotMap = new HashMap();

    public void removeAll() {
        this.snapshotMap.clear();
    }

    public void addSnapshot(VolumeNodeImpl sourceVolume, SnapshotVolumeImpl snapshotVolume) {
        if (sourceVolume == null) {
            return;
        }
        List<Object> snapshotList = null;
        if (this.snapshotMap.containsKey(sourceVolume)) {
            snapshotList = this.snapshotMap.get(sourceVolume);
            if (!snapshotList.contains(snapshotVolume)) {
                snapshotList.add(snapshotVolume);
            }
            return;
        }
        snapshotList = new ArrayList<SnapshotVolumeImpl>();
        snapshotList.add(snapshotVolume);
        this.snapshotMap.put(sourceVolume, snapshotList);
    }

    public List<SnapshotVolumeImpl> getSnapshotsForSourceVolume(VolumeNodeImpl sourceVolume) {
        return this.snapshotMap.get(sourceVolume);
    }

    public boolean isSourceOfSnapshot(VolumeNodeImpl sourceVolume) {
        return this.snapshotMap.containsKey(sourceVolume);
    }

    public void removeSnapshot(SnapshotVolumeImpl snapshotVolume) {
        block3: {
            block2: {
                VolumeNodeImpl source = snapshotVolume.getSourceVolume();
                if (source == null) break block2;
                if (!this.snapshotMap.containsKey(source)) break block3;
                List<SnapshotVolumeImpl> sourceEntry = this.snapshotMap.get(source);
                sourceEntry.remove(snapshotVolume);
                if (sourceEntry.isEmpty()) {
                    this.snapshotMap.remove(source);
                }
                break block3;
            }
            Iterator<VolumeNodeImpl> i = this.snapshotMap.keySet().iterator();
            while (i.hasNext()) {
                VolumeNodeImpl snapSource = i.next();
                List<SnapshotVolumeImpl> snapList = this.snapshotMap.get(snapSource);
                if (!snapList.contains(snapshotVolume)) continue;
                i.remove();
                break;
            }
        }
    }

    public void removeSnapshotBySource(SnapshotVolume snapshotVolume, VolumeNode source) {
        if (this.snapshotMap.containsKey(source)) {
            List<SnapshotVolumeImpl> sourceEntry = this.snapshotMap.get(source);
            sourceEntry.remove(snapshotVolume);
            if (sourceEntry.isEmpty()) {
                this.snapshotMap.remove(source);
            }
        }
    }

    public VolumeNodeImpl getSourceOfSnapshot(SnapshotVolumeImpl snap) {
        VolumeNodeImpl source;
        block1: {
            List<SnapshotVolumeImpl> snapsOfSource;
            source = null;
            source = snap.getSourceVolume();
            if (source != null) break block1;
            Iterator<VolumeNodeImpl> itr = this.snapshotMap.keySet().iterator();
            while (itr.hasNext() && !(snapsOfSource = this.snapshotMap.get(source = itr.next())).contains(snap)) {
            }
        }
        return source;
    }
}

