/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.MirrorVolumeAlarmGenerator;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.validators.AddMirrorValidator;
import com.sanrad.nms.server.logic.volume.validators.ExpandVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.MirrorVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MirrorVolumeImpl
extends VirtualVolumeImpl
implements MirrorVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static SrLogger theLogger;

    public MirrorVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.MIRROR_VOLUME, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        List<VSwitchImpl> vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        Vector<VolumeNodeImpl> childrenForSync = this.getChildrenListForClusterSync(vSwitchToSync.get(0));
        MirrorVolumeSyncValidator validator = new MirrorVolumeSyncValidator(this.cluster, this.getAlias(), childrenForSync, storage.getVolumeMgr(), vSwitchToSync);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ErrorAssertingListener.listenTo(storage.createMirrorVolume(this.getAlias(), childrenForSync, vSwitchToSync, this.getConnectedVSwitches()[0], this.getCommKeyClassId()));
        return 2;
    }

    public boolean isMirrorMirroring(VSwitchImpl vSwitch) {
        List<VolumeNodeImpl> nonFuncChildre = this.getNonFunctionalChildren(vSwitch);
        return this.getChildren(vSwitch).size() - nonFuncChildre.size() > 1;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return MirrorVolumeAlarmGenerator.getInstance();
    }

    public VolumeNodeImpl getSyncSource(VSwitchImpl vSwitch) throws RemoteException {
        for (VolumeNodeImpl child : this.getChildren()) {
            if (child.isNeedSync(vSwitch) || child.isNonFunctional(vSwitch)) continue;
            return child;
        }
        return null;
    }

    public VolumeNodeImpl getSyncSource(VSwitchImpl vSwitch, VolumeNodeImpl childToSync) throws RemoteException {
        CopyOperationManagerImpl copyOperationsManger = this.getCluster().getCopyOperManager();
        for (VolumeNodeImpl child : this.getChildren()) {
            if (child.isNeedSync(vSwitch) || child.isNonFunctional(vSwitch) || child.equals(childToSync) || copyOperationsManger.isExistedAsDstInOtherActivrCopyOperation(child.getCommKeyClassId())) continue;
            return child;
        }
        return null;
    }

    private VolumeNodeImpl getSyncDestination() throws RemoteException {
        CopyOperationManagerImpl copyOperationsManger = this.getCluster().getCopyOperManager();
        for (VolumeNodeImpl child : this.getChildren()) {
            if (!child.isNeedSync() || child.isNonFunctional() || copyOperationsManger.isExistedAsDstInOtherActivrCopyOperation(child.getCommKeyClassId()) || copyOperationsManger.isExistedAsSrcInOtherActivrCopyOperation(child.getCommKeyClassId())) continue;
            return child;
        }
        return null;
    }

    @Override
    public SrFuture<Void> mirrorSync() throws RemoteException, IllegalValueException {
        try {
            VolumeNodeImpl syncDst = this.getSyncDestination();
            if (syncDst == null) {
                throw new IllegalValueException("Could not find the destination volume for the mirror sync operation for " + this.getClassId() + " " + this);
            }
            return this.mirrorSync(this, syncDst);
        }
        catch (CopyAlreadyExistException ile) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)ile, new Object[]{"got a copy already exist exception."});
            return new FailedFuture((Exception)((Object)ile), "MirrorVolumeImpl.mirrorSync");
        }
    }

    @Override
    public SrFuture<Void> breakMirror(CommKeyClassId[] children) throws RemoteException, IllegalValueException {
        return this.removeChildren(children);
    }

    @Override
    public SrFuture<Void> addMirror(CommKeyClassId newChild, String mirrVolAlias, boolean autoSync) throws RemoteException, IllegalValueException {
        final VolumeNodeImpl childToAdd = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newChild);
        SrFuture retFuture = this.addChild(childToAdd, VolumeOperationType.VOL_OPER_ADD_MIRROR, null, null);
        if (autoSync) {
            SrFuture futureToUpdate;
            final MirrorVolumeImpl mir = this;
            SrFuture addChildFuture = retFuture;
            retFuture = futureToUpdate = new SrFuture("MirrorVolumeImpl.addMirror");
            Runnable syncChildRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.getInstance().addMirrorFollowUp(mir, childToAdd, (SrFuture<Void>)futureToUpdate);
                }
            };
            DefaultFutureListener.listenTo((Runnable)syncChildRun, (IFuture[])new IFuture[]{addChildFuture});
        }
        return retFuture;
    }

    public Void addMirrorFollowUp(VolumeNodeImpl aChild, MirrorVolumeImpl aMirrorVolume, final SrFuture<Void> aFutureToUpdate) {
        try {
            final SrFuture<Void> mirSyncFuture = this.mirrorSync(aMirrorVolume, aChild);
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(mirSyncFuture, aFutureToUpdate);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{mirSyncFuture});
        }
        catch (RemoteException exp) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{exp, "Failed to Sync new Mirror Child :", aChild});
            aFutureToUpdate.setException((Throwable)exp);
        }
        catch (IllegalValueException exp) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{exp, "Failed to Sync new Mirror Child :", aChild});
            aFutureToUpdate.setException((Throwable)((Object)exp));
        }
        catch (CopyAlreadyExistException exp) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{exp, "Failed to Sync new Mirror Child :", aChild});
            aFutureToUpdate.setException((Throwable)exp);
        }
        return null;
    }

    @Override
    protected boolean setChildren(VSwitchImpl vSwitch, Vector oldChildrenVector) throws RemoteException {
        return super.setChildren(vSwitch, null);
    }

    @Override
    public SrFuture<Void> addChild(VolumeNodeImpl newChild, VolumeOperationType oper, CommKeyClassId[] vSwitchesToSet, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        AddMirrorValidator validator = new AddMirrorValidator(this.cluster, (VolumeNodeImpl)this, this.getAlias(), this.getChildren(), storage.getVolumeMgr(), newChild);
        validator.turnOffAliasValidation();
        CommKeyClassId[] vSToSet = validator.forWhichVswitchIsValidData(vSwitchesToSet);
        if (vSToSet == null || vSToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return super.addChild(newChild, oper, vSToSet, operationInvoker);
    }

    public SrFuture<Void> removeChildren(CommKeyClassId[] childrenToRemove) throws RemoteException, IllegalValueException {
        return super.removeChildren(childrenToRemove, VolumeOperationType.VOL_OPER_BREAK_MIRROR);
    }

    @Override
    protected VolumeStateConstant getMyTypeSpecialStateAfterAddChild() {
        return VolumeStateConstant.VOLUME_STATE_NEED_SYNC;
    }

    @Override
    public SrFuture<Void> expand() throws RemoteException {
        StorageImpl storage = this.cluster.getStorage();
        ExpandVolumeValidator validator = new ExpandVolumeValidator(this.cluster, this, this.getAlias(), this.getChildren(), storage.getVolumeMgr());
        CommKeyClassId[] vSwitchToSet = validator.forWhichVswitchIsValidData();
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchToSet));
        return DataMgrAdapter.getInstance().operate(element, VolumeOperationType.VOL_OPER_EXPAND);
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

