/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.volume.JournalAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.validators.JournalVolumeSyncValidator;
import com.sanrad.nms.server.logic.volume.validators.JournalVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JournalVolumeImpl
extends VirtualVolumeImpl
implements JournalVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static SrLogger theLogger;
    private ArrayList m_connectedPairs = new ArrayList();

    public JournalVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.JOURNAL_VOLUME, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String result = super.isValid(parameterList);
        if (result == null) {
            SrString alias = (SrString)parameterList.get(ClientParameterCode.VOLUME_ALIAS);
            Integer threshold = (Integer)parameterList.get(ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
            CommKeyClassId activeOnVswitchId = (CommKeyClassId)parameterList.get(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
            VSwitchImpl activeOnVswitch = null;
            List<VSwitchImpl> otherVSwitches = null;
            if (activeOnVswitchId != null) {
                activeOnVswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(activeOnVswitchId);
                ArrayList<VSwitchImpl> activeOnVswitchVec = new ArrayList<VSwitchImpl>();
                activeOnVswitchVec.add(activeOnVswitch);
                otherVSwitches = this.getCluster().getOtherVSwitches(activeOnVswitchVec);
            }
            JournalVolumeValidator validator = new JournalVolumeValidator(this.cluster, alias == null ? null : (String)alias.value(), threshold, null, activeOnVswitchId != null, activeOnVswitch, otherVSwitches != null ? (VSwitchImpl)otherVSwitches.get(0) : null, this.getCluster().getStorage().getVolumeMgr());
            result = validator.isValid(parameterList);
        }
        return result;
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        List<VSwitchImpl> currentExistedOnVSwitches = this.getVSwitches();
        List<VSwitchImpl> otherVSwitches = this.cluster.getOtherVSwitches(currentExistedOnVSwitches);
        VSwitchImpl alreadyExistedOnVswitch = currentExistedOnVSwitches.get(0);
        JournalVolumeSyncValidator validator = new JournalVolumeSyncValidator(this.cluster, this.getAlias(), this.getChildren(), this.getPercentageThreshold(), storage.getVolumeMgr(), otherVSwitches);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        JournalVolumeActivityConstants journalActivityOnExistedVSwitch = this.getActivityState(alreadyExistedOnVswitch);
        if (journalActivityOnExistedVSwitch.equals((Object)JournalVolumeActivityConstants.ACTIVE)) {
            ErrorAssertingListener.listenTo(storage.createJournalVolume(this.getAlias(), this.getPercentageThreshold(), this.getChildren(), null, otherVSwitches.get(0), false));
        } else if (journalActivityOnExistedVSwitch.equals((Object)JournalVolumeActivityConstants.INACTIVE)) {
            ErrorAssertingListener.listenTo(storage.createJournalVolume(this.getAlias(), this.getPercentageThreshold(), this.getChildren(), otherVSwitches.get(0), null, false));
        }
        return 2;
    }

    @Override
    protected String canBeDeleted() {
        if (this.isConnectedToPairs()) {
            return "You cannot delete the journal volume " + this.getAlias() + " because it has pairs connected to it.";
        }
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return JournalAlarmGenerator.getInstance();
    }

    public boolean isOutOfSync(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, (SrType)VolumeStateConstant.VOLUME_STATE_OUT_OF_SYNC);
    }

    public boolean isFull(VSwitchImpl vSwitch) {
        Integer load = this.getPercentageUtilization(vSwitch);
        return this.isOutOfSync(vSwitch) && load == 100;
    }

    public boolean isOverUsed(VSwitchImpl vSwitch) {
        Integer load = this.getPercentageUtilization(vSwitch);
        Integer thresh = this.getPercentageThreshold(vSwitch);
        return load >= thresh;
    }

    @Override
    public Long getDateAndTime() throws RemoteException {
        return this.getDateAndTime(null);
    }

    public Long getDateAndTime(VSwitchImpl vSwitch) {
        Long dateAndTime = (Long)this.getValueOf(vSwitch, ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, vSwitch == null);
        return dateAndTime;
    }

    @Override
    public Integer getPercentageUtilization() throws RemoteException {
        return this.getPercentageUtilization(null);
    }

    public Integer getPercentageUtilization(VSwitchImpl vSwitch) {
        Integer precentage = (Integer)this.getValueOf(vSwitch, ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, vSwitch == null);
        return precentage;
    }

    @Override
    public Integer getPercentageThreshold() throws RemoteException {
        return this.getPercentageThreshold(null);
    }

    public Integer getPercentageThreshold(VSwitchImpl vSwitch) {
        Integer precentage = (Integer)this.getValueOf(vSwitch, ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, vSwitch == null);
        return precentage;
    }

    @Override
    public JournalVolumeActivityConstants getActivityState(CommKeyClassId vswitchCommKeyClassId) {
        VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vswitchCommKeyClassId);
        JournalVolumeActivityConstants activity = this.getActivityState(vswitch);
        return activity;
    }

    public JournalVolumeActivityConstants getActivityState(VSwitchImpl vswitch) {
        return (JournalVolumeActivityConstants)this.getSrValueOf(vswitch, ParameterCode.JOURNAL_VOLUME_ACTIVITY, false);
    }

    @Override
    public VSwitchImpl getActiveOnVSwitch() {
        VSwitchImpl[] clusterVswitches;
        for (VSwitchImpl vswitch : clusterVswitches = this.getConnectedVSwitches()) {
            JournalVolumeActivityConstants activeState = this.getActivityState(vswitch);
            if (!JournalVolumeActivityConstants.ACTIVE.equals((Object)activeState) && !JournalVolumeActivityConstants.SWITCHED.equals((Object)activeState)) continue;
            return vswitch;
        }
        return null;
    }

    @Override
    public boolean isInternal(VSwitchImpl vSwitch) {
        return false;
    }

    public VSwitchImpl getInactiveOnVSwitch() {
        VSwitchImpl[] clusterVswitches;
        for (VSwitchImpl vswitch : clusterVswitches = this.getConnectedVSwitches()) {
            JournalVolumeActivityConstants activeState = this.getActivityState(vswitch.getCommKeyClassId());
            if (!activeState.equals((Object)JournalVolumeActivityConstants.INACTIVE)) continue;
            return vswitch;
        }
        return null;
    }

    public void addConnectedPair(Object pair) throws RemoteException {
        this.m_connectedPairs.add(pair);
        this.updateJournalAlarms();
    }

    public void removeConnectedPair(Object pair) throws RemoteException {
        this.m_connectedPairs.remove(pair);
        this.updateJournalAlarms();
    }

    public Object[] getConnectedPairs() {
        return this.m_connectedPairs.toArray();
    }

    public void clearConnectedPairs() throws RemoteException {
        this.m_connectedPairs.clear();
        this.updateJournalAlarms();
    }

    public boolean isConnectedToPairs() {
        return this.m_connectedPairs.size() > 0;
    }

    private void updateJournalAlarms() throws RemoteException {
        VSwitchImpl[] connectedVSwitches;
        if (this.getCluster().isInDeletionProcess()) {
            return;
        }
        for (VSwitchImpl connectedVSwitch : connectedVSwitches = this.getConnectedVSwitches()) {
            if (connectedVSwitch.isInDeletionProcess()) continue;
            if (this.getCluster() != null) {
                AlarmMgrImpl.getInstance().generateAlarms(this.getCluster(), 18, (GeneralLogicObjectImpl)this, connectedVSwitch);
                continue;
            }
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The journal ", this, " contains null instead of a cluster."});
        }
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        VSwitchImpl vSwitch = this.getActiveOnVSwitch();
        params.put(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, vSwitch);
        return params;
    }

    @Override
    public SrFuture<Void> refreshPercentUtilization() throws RemoteException {
        return this.refreshFields(new ParameterCode[]{ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION});
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        return this.getActiveOnVSwitch();
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = super.getParamsForCreation();
        params.add(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
        params.add(ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        return params;
    }

    static {
        theLogger = SrLogger.getLogger();
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_ACTIVITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_OPER_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_ERROR_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

