/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.ConcatenationVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.ConcatinationVolumeSyncValidator;
import com.sanrad.nms.server.logic.volume.validators.ExpandVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.ResizeVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ConcatinationVolumeImpl
extends VirtualVolumeImpl
implements ConcatinationVolume {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    protected boolean isExpandable = false;
    private static SrLogger theLogger;
    protected boolean isRetractable = false;

    public ConcatinationVolumeImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        this(cluster, ClassID.CONCAT_VOLUME, aCED);
    }

    protected ConcatinationVolumeImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        List<VSwitchImpl> vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        Vector<VolumeNodeImpl> childrenForSync = this.getChildrenListForClusterSync(vSwitchToSync.get(0));
        ConcatinationVolumeSyncValidator validator = new ConcatinationVolumeSyncValidator(this.cluster, this.getAlias(), childrenForSync, storage.getVolumeMgr(), vSwitchToSync);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ErrorAssertingListener.listenTo(storage.createConcatinationVolume(this.getAlias(), childrenForSync, vSwitchToSync, this.getConnectedVSwitches()[0], this.getCommKeyClassId()));
        return 2;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return ConcatenationVolumeAlarmGenerator.getInstance();
    }

    @Override
    public SrFuture<Void> resize(CommKeyClassId newChild, String alias) throws RemoteException, IllegalValueException {
        return this.addChild((VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newChild), VolumeOperationType.VOL_OPER_RESIZE, null, null);
    }

    @Override
    public SrFuture<Void> expand() throws RemoteException {
        StorageImpl storage = this.cluster.getStorage();
        ExpandVolumeValidator validator = new ExpandVolumeValidator(this.cluster, this, this.getAlias(), this.getChildren(), storage.getVolumeMgr());
        CommKeyClassId[] vSwitchToSet = validator.forWhichVswitchIsValidData();
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchToSet));
        return DataMgrAdapter.getInstance().operate(element, VolumeOperationType.VOL_OPER_EXPAND);
    }

    @Override
    public SrFuture<Void> retract() throws RemoteException, IllegalValueException {
        CommKeyClassId[] childrenToRetract = this.getRetractableChildren();
        return this.removeChildren(childrenToRetract);
    }

    public boolean isExpandable(VSwitchImpl vs) {
        return this.isInState(vs, (SrType)VolumeStateConstant.VOLUME_STATE_EXPANDABLE);
    }

    public boolean calcExpandable() throws RemoteException {
        if (this.isIllegal() || this.isInconsistent()) {
            return false;
        }
        boolean expandable = false;
        VSwitchImpl[] connectedVswitch = this.getConnectedVSwitches();
        for (int i = 0; i < connectedVswitch.length; ++i) {
            if (!this.isExpandable(connectedVswitch[i])) continue;
            expandable = true;
            CommKeyClassId[] oneVSwitchChildren = (CommKeyClassId[])this.getSrArrayValueOf(connectedVswitch[i], ParameterCode.VOLUME_CHILDREN);
            for (int j = 0; j < oneVSwitchChildren.length; ++j) {
                VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(oneVSwitchChildren[j]);
                if (child == null || !child.isInState(connectedVswitch[i], (SrType)VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) continue;
                return false;
            }
        }
        return expandable;
    }

    public boolean calcRetractable() throws RemoteException {
        if (this.isIllegal()) {
            return false;
        }
        boolean inExpandableState = false;
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isInState(vSwitches[i], (SrType)VolumeStateConstant.VOLUME_STATE_EXPANDABLE)) continue;
            inExpandableState = true;
            break;
        }
        if (!inExpandableState) {
            return false;
        }
        try {
            CommKeyClassId[] retractable = this.getRetractableChildren();
            return retractable.length > 0;
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            return false;
        }
    }

    @Override
    public boolean isExpandable() throws RemoteException {
        return this.isExpandable;
    }

    @Override
    public boolean isRetractable() throws RemoteException {
        return this.isRetractable;
    }

    public CommKeyClassId[] getRetractableChildren() throws RemoteException, IllegalValueException {
        Vector<CommKeyClassId> retractableChildren = new Vector<CommKeyClassId>();
        HashMap<Object, CommKeyClassId[]> childrenListByVSwitch = this.getChildrenCommKeyClassIdListByVSwitch();
        CommKeyClassId[] existInAll = childrenListByVSwitch.get(BELONG_TO_ALL_VSWITCHES);
        for (int i = 0; i < existInAll.length; ++i) {
            VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(existInAll[i]);
            VSwitchImpl[] childVSwitch = this.getConnectedVSwitches();
            boolean childRetractable = child.isRetractable(childVSwitch[0]);
            for (int j = 1; j < childVSwitch.length; ++j) {
                if (childRetractable == child.isRetractable(childVSwitch[j])) continue;
                StringBuffer errMsg = new StringBuffer("Child ");
                errMsg.append(child.getClassId());
                errMsg.append(" ");
                errMsg.append(child);
                errMsg.append(" is not retractable on ");
                errMsg.append(ClassID.VSWITCH);
                errMsg.append(" ");
                errMsg.append(childVSwitch[j]);
                throw new IllegalValueException(errMsg.toString());
            }
            if (!childRetractable) continue;
            retractableChildren.add(existInAll[i]);
        }
        for (Object key : childrenListByVSwitch.keySet()) {
            if (key.equals(BELONG_TO_ALL_VSWITCHES)) continue;
            VSwitchImpl vSwitch = (VSwitchImpl)key;
            CommKeyClassId[] childrenList = childrenListByVSwitch.get(vSwitch);
            for (int i = 0; i < childrenList.length; ++i) {
                VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(childrenList[i]);
                if (!child.isRetractable(vSwitch)) {
                    StringBuffer errMsg = new StringBuffer("Child ");
                    errMsg.append(child.getClassId());
                    errMsg.append(" ");
                    errMsg.append(child);
                    errMsg.append(" is not retractable on ");
                    errMsg.append(ClassID.VSWITCH);
                    errMsg.append(" ");
                    errMsg.append(vSwitch);
                    throw new IllegalValueException(errMsg.toString());
                }
                retractableChildren.add(childrenList[i]);
            }
        }
        CommKeyClassId[] retVal = new CommKeyClassId[retractableChildren.size()];
        retractableChildren.toArray(retVal);
        return retVal;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        HashMap parameterList = aCED.getParametersList();
        if (this.getCluster().isDiscoverCompleted() && (parameterList.containsKey(ParameterCode.VOLUME_CHILDREN) || parameterList.containsKey(ParameterCode.VOLUME_STATE))) {
            this.updateExpandAndRetractStatus();
        }
        return changedValues;
    }

    public void updateExpandAndRetractStatus() throws RemoteException {
        boolean isExpand;
        boolean isRetract = this.calcRetractable();
        HashMap<ParameterCode, SrBoolean> changedValues = new HashMap<ParameterCode, SrBoolean>();
        if (isRetract != this.isRetractable) {
            this.isRetractable = isRetract;
            changedValues.put(ParameterCode.VOLUME_RETRACTABLE, new SrBoolean(this.isRetractable));
        }
        if ((isExpand = this.calcExpandable()) != this.isExpandable) {
            this.isExpandable = isExpand;
            changedValues.put(ParameterCode.VOLUME_EXPANDABLE, new SrBoolean(this.isExpandable));
        }
        if (changedValues.size() > 0) {
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
            elementEvent.setParameterList(changedValues);
            LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
            ErrorAssertingListener.listenTo(this.reReadVolumeCapacity());
        }
    }

    @Override
    public void childVolumeStateWasChanged() throws RemoteException {
        this.updateExpandAndRetractStatus();
        ErrorAssertingListener.listenTo(this.reReadVolumeCapacity());
    }

    @Override
    public SrFuture<Void> addChild(VolumeNodeImpl newChild, VolumeOperationType oper, CommKeyClassId[] vSwitchesToSet, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        StorageImpl storage = this.cluster.getStorage();
        ResizeVolumeValidator validator = new ResizeVolumeValidator(this.cluster, (VolumeNodeImpl)this, this.getAlias(), this.getChildren(), storage.getVolumeMgr(), newChild);
        validator.turnOffAliasValidation();
        CommKeyClassId[] vSToSet = validator.forWhichVswitchIsValidData(vSwitchesToSet);
        if (vSToSet == null || vSToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return super.addChild(newChild, oper, vSToSet, operationInvoker);
    }

    public SrFuture<Void> removeChildren(CommKeyClassId[] childrenToRetract) throws RemoteException, IllegalValueException {
        return super.removeChildren(childrenToRetract, VolumeOperationType.VOL_OPER_RETRACT);
    }

    @Override
    protected VolumeStateConstant getMyTypeSpecialStateAfterAddChild() {
        return VolumeStateConstant.VOLUME_STATE_RETRACTABLE;
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

