/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.volume;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.BundleKeysInterface;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VolumeCreationValidator
extends CreationValidator {
    public static final List<Character> INVALID_ALIAS_CHARS = Arrays.asList(Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('*'));
    public static final String INVALID_ALIAS_CHARS_REGEX = "[\\&#\\+\\-!\\*]";

    protected VolumeCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.VOLUME_ALIAS);
        this.addMandatoryParameter(ClientParameterCode.VOLUME_CHILDREN);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new CreationValidator.AliasValidation(aCed, ClientParameterCode.VOLUME_ALIAS));
        validations.add(new VolumeChildrenTypeValidation(aCed));
        validations.add(new VolumeAliasValidation(aCed));
        validations.add(new VolumeChildCopyOperValidation(aCed));
        validations.add(new VolumeDiskChildValidation(aCed));
        validations.add(new NonFunctionalChildrenValidation(aCed));
        validations.add(new DrOfflineCopyValidation(aCed));
        validations.add(new SnapshotSourceValidation(aCed));
        validations.add(new ChildExposedValidation(aCed));
        validations.add(new DRPairVolumeValidation(aCed));
        return this.executeValidations(validations);
    }

    protected static List<VolumeNodeImpl> getAlreadyCreatedChildren(ClientConfigElementData aCed) {
        CommKeyClassId[] childrenIds = null;
        if (aCed.isNested(ClientParameterCode.VOLUME_CHILDREN)) {
            ClientConfigElementData[] childrenCeds;
            ArrayList<CommKeyClassId> childIdList = new ArrayList<CommKeyClassId>();
            for (ClientConfigElementData volChildCed : childrenCeds = (ClientConfigElementData[])aCed.getValue(ClientParameterCode.VOLUME_CHILDREN)) {
                if (!volChildCed.isCreated()) continue;
                childIdList.add(volChildCed.getCommKeyClassId());
            }
            childrenIds = childIdList.toArray(new CommKeyClassId[childIdList.size()]);
        } else {
            childrenIds = (CommKeyClassId[])aCed.getValue(ClientParameterCode.VOLUME_CHILDREN);
        }
        ArrayList<VolumeNodeImpl> children = new ArrayList<VolumeNodeImpl>();
        for (CommKeyClassId id : childrenIds) {
            VolumeNodeImpl volumeChild = (VolumeNodeImpl)VolumeCreationValidator.getLogicObject(id);
            if (volumeChild == null) {
                throw new IllegalStateException("Volume child not found for ID " + id);
            }
            children.add(volumeChild);
        }
        return children;
    }

    protected static class ChildrenCountValidation
    extends CreationValidator.ElementValidation {
        static final int NO_LIMIT = -1;
        int myChildMaxCount;
        int myChildMinCount;

        ChildrenCountValidation(ClientConfigElementData aCed, int aChildMaxCount, int aChildMinCount) {
            super(aCed);
            if (aChildMaxCount < 1 && aChildMaxCount != -1) {
                throw new IllegalArgumentException("Ilegal max child count - " + aChildMaxCount);
            }
            if (aChildMinCount < 0 && aChildMinCount != -1) {
                throw new IllegalArgumentException("Ilegal min child count - " + aChildMinCount);
            }
            this.myChildMaxCount = aChildMaxCount;
            this.myChildMinCount = aChildMinCount;
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.VOLUME_CHILDREN;
        }

        @Override
        protected String validate() {
            String[] msg;
            ClientConfigElementData[] children;
            boolean isTooMuch = false;
            boolean isTooLess = false;
            if (this.myCed.isNested(ClientParameterCode.VOLUME_CHILDREN)) {
                children = (ClientConfigElementData[])this.myCed.getValue(ClientParameterCode.VOLUME_CHILDREN);
                isTooMuch = children.length > this.myChildMaxCount;
                isTooLess = children.length < this.myChildMinCount;
            } else {
                children = (CommKeyClassId[])this.myCed.getValue(ClientParameterCode.VOLUME_CHILDREN);
                isTooMuch = children.length > this.myChildMaxCount;
                boolean bl = isTooLess = children.length < this.myChildMinCount;
            }
            if (this.myChildMaxCount != -1 && isTooMuch) {
                msg = new String[]{this.myCed.getClassId().toString(), Integer.toString(this.myChildMaxCount)};
                return ErrorMessage.CANNOT_CREATE_VOLUME_WITH_MORE_THEN_X_CHILDREN.getMessage(msg);
            }
            if (this.myChildMinCount != -1 && isTooLess) {
                msg = new String[]{this.myCed.getClassId().toString(), Integer.toString(this.myChildMinCount)};
                return ErrorMessage.CANNOT_CREATE_VOLUME_WITH_LESS_THEN_X_CHILDREN.getMessage(msg);
            }
            return null;
        }
    }

    private static class DRPairVolumeValidation
    extends VolumeChildrenValidation {
        private static String PART_OF_PAIR_MSG = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.CANNOT_CREATE_VOLUME_BECAUSE_CHILD_IS_PART_OF_PAIR_ERR_MSG);
        String alias;

        DRPairVolumeValidation(ClientConfigElementData aCed) {
            super(aCed);
            this.alias = (String)this.myCed.getValue(ClientParameterCode.VOLUME_ALIAS);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(aChild);
            if (pair == null) {
                pair = DRRootImpl.getInstance().getPairContainsISCSIDisk(aChild);
            }
            if (pair != null) {
                Object[] msgArgs = new Object[]{this.alias, aChild.getAlias(), pair};
                return MessageFormat.format(PART_OF_PAIR_MSG, msgArgs);
            }
            return null;
        }
    }

    protected static class StorageMissingValidation
    extends VolumeChildrenValidation {
        StorageMissingValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            GeneralSCSIDeviceImpl disk = null;
            if (aChild instanceof GeneralSCSIDeviceImpl) {
                disk = (GeneralSCSIDeviceImpl)aChild;
            } else if (aChild instanceof SubDirectAccessDeviceImpl) {
                disk = ((SubDirectAccessDeviceImpl)aChild).getDirectAccessDeviceParent();
            }
            if (disk != null && disk.isMissing()) {
                String[] msgParama = new String[]{this.myCed.getClassId().toString(), aChild.getClassId().toString(), aChild.getAlias()};
                return ErrorMessage.VOLUME_OVER_MISSING_STORAGE.getMessage(msgParama);
            }
            return null;
        }
    }

    private static class ChildExposedValidation
    extends VolumeChildrenValidation {
        ChildExposedValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            if (aChild.isExposed()) {
                return "Volume " + aChild + " cannot be a volume child because it is exposed";
            }
            return null;
        }
    }

    private static class SnapshotSourceValidation
    extends VolumeChildrenValidation {
        SnapshotSourceValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            if (aChild.isSnapshotSource()) {
                return "Volume " + aChild + " cannot be a trasparent volume child because it is a snapshot volume source";
            }
            return null;
        }
    }

    private static class DrOfflineCopyValidation
    extends VolumeChildrenValidation {
        DrOfflineCopyValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            if (aChild.isDROfflineLocalCopy()) {
                return "Volume " + aChild + " is used for DR offline local copy";
            }
            return null;
        }
    }

    private static class NonFunctionalChildrenValidation
    extends VolumeChildrenValidation {
        NonFunctionalChildrenValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            VSwitchImpl[] vSwitches = aChild.getConnectedVSwitches();
            for (int i = 0; i < vSwitches.length; ++i) {
                if (!aChild.isNonFunctional(vSwitches[i])) continue;
                String[] msgParams = new String[]{this.myCed.getClassId().toString(), aChild.getClassId().toString(), aChild.getAlias()};
                return ErrorMessage.VOLUME_OVER_NONFUNCTIONAL_VOLUME.getMessage(msgParams);
            }
            return null;
        }
    }

    private static class VolumeDiskChildValidation
    extends VolumeChildrenValidation {
        VolumeDiskChildValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            DirectAccessDeviceImpl disk;
            if (ClassID.DIRECT_ACCESS_DEVICE.equals((Object)aChild.getClassId()) && (disk = (DirectAccessDeviceImpl)aChild).hasSubdisks()) {
                return ClassID.DIRECT_ACCESS_DEVICE + " " + disk.getAlias() + " is split - it cannot be a child of a volume";
            }
            return null;
        }
    }

    private static class VolumeChildCopyOperValidation
    extends VolumeChildrenValidation {
        ClusterImpl cluster;
        String alias;

        VolumeChildCopyOperValidation(ClientConfigElementData aCed) {
            super(aCed);
            this.cluster = (ClusterImpl)VolumeCreationValidator.getLogicObject(this.myCed.getClusterId());
            this.alias = (String)this.myCed.getValue(ClientParameterCode.VOLUME_ALIAS);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            if (this.cluster.getCopyOperManager().isInvolvedInActiveCopyOper(aChild.getCommKeyClassId())) {
                String[] msg = new String[]{this.alias, aChild.getAlias()};
                return ErrorMessage.CHILD_VOLUME_IS_PART_OF_COPY_OPER.getMessage(msg);
            }
            return null;
        }
    }

    protected static abstract class VolumeChildrenValidation
    extends CreationValidator.ElementValidation {
        VolumeChildrenValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.VOLUME_CHILDREN;
        }

        @Override
        protected final String validate() {
            List<VolumeNodeImpl> allChildren = VolumeCreationValidator.getAlreadyCreatedChildren(this.myCed);
            for (VolumeNodeImpl volChild : allChildren) {
                String error = this.validateChild(volChild);
                if (error == null) continue;
                return error;
            }
            return null;
        }

        protected abstract String validateChild(VolumeNodeImpl var1);
    }

    static class VolumeAliasValidation
    extends CreationValidator.ElementValidation {
        VolumeAliasValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.VOLUME_ALIAS;
        }

        @Override
        protected String validate() {
            String alias = (String)this.myCed.getValue(ClientParameterCode.VOLUME_ALIAS);
            boolean isSameAsNestedChildAlias = false;
            if (this.myCed.isNested(ClientParameterCode.VOLUME_CHILDREN)) {
                ClientConfigElementData[] children;
                for (ClientConfigElementData volChild : children = (ClientConfigElementData[])this.myCed.getValue(ClientParameterCode.VOLUME_CHILDREN)) {
                    String childAlias = (String)volChild.getValue(ClientParameterCode.VOLUME_ALIAS);
                    if (alias.equals(childAlias)) continue;
                    isSameAsNestedChildAlias = true;
                    break;
                }
            }
            ClusterImpl cluster = (ClusterImpl)VolumeCreationValidator.getLogicObject(this.myCed.getClusterId());
            if (isSameAsNestedChildAlias || cluster.getVolumeMgr().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            return null;
        }
    }

    protected static class VolumeChildrenTypeValidation
    extends CreationValidator.ElementValidation {
        VolumeChildrenTypeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.VOLUME_CHILDREN;
        }

        @Override
        protected String validate() {
            ClassID illegalClassID = null;
            if (this.myCed.isNested(ClientParameterCode.VOLUME_CHILDREN)) {
                ClientConfigElementData[] children;
                for (ClientConfigElementData volChild : children = (ClientConfigElementData[])this.myCed.getValue(ClientParameterCode.VOLUME_CHILDREN)) {
                    if (this.isValidType(volChild.getClassId())) continue;
                    illegalClassID = volChild.getClassId();
                    break;
                }
            } else {
                CommKeyClassId[] children;
                for (CommKeyClassId volChildId : children = (CommKeyClassId[])this.myCed.getValue(ClientParameterCode.VOLUME_CHILDREN)) {
                    if (this.isValidType(volChildId.getClassID())) continue;
                    illegalClassID = volChildId.getClassID();
                    break;
                }
            }
            if (illegalClassID != null) {
                return "Element of type " + illegalClassID + " cannot be a volume child";
            }
            return null;
        }

        protected boolean isValidType(ClassID aType) {
            return aType.isVolumeNode() && !aType.equals((Object)ClassID.SNAPSHOT_VOLUME) && !aType.equals((Object)ClassID.JOURNAL_VOLUME);
        }
    }
}

