/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.volume;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.validation.volume.VolumeCreationValidator;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.util.ClientConfigElementData;
import java.math.BigInteger;
import java.util.ArrayList;

public class StripeVolumeCreationValidator
extends VolumeCreationValidator {
    public StripeVolumeCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.STRIPE_VOLUME_STRIPE_SIZE);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        String superError = super.innerValidate(aCed);
        if (superError != null) {
            return superError;
        }
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new StripeSizeValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class StripeSizeValidation
    extends VolumeCreationValidator.VolumeChildrenValidation {
        StripeSizeValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateChild(VolumeNodeImpl aChild) {
            BigInteger stripeSize = (BigInteger)this.myCed.getValue(ClientParameterCode.STRIPE_VOLUME_STRIPE_SIZE);
            if (aChild.getAccessibleSpace().compareTo(stripeSize) < 1) {
                return ErrorMessage.STRIPE_SIZE_IS_TOO_HIGH.getMessage(stripeSize.toString() + " Bytes");
            }
            return null;
        }
    }
}

