/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.storage;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.util.ArrayList;

public class SubdiskCreationValidator
extends CreationValidator {
    public SubdiskCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        this.addMandatoryParameter(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_SIZE);
        this.addMandatoryParameter(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_PARENT);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new CreationValidator.AliasValidation(aCed, ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS));
        validations.add(new AliasUniqueValidation(aCed));
        validations.add(new DiskVolumeChildValidation(aCed));
        validations.add(new DiskExposureValidation(aCed));
        validations.add(new DiskGdrValidation(aCed));
        validations.add(new DiskCopyOperationValidation(aCed));
        validations.add(new DiskSnapshotSourceValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class DiskSnapshotSourceValidation
    extends DiskParentValidation {
        DiskSnapshotSourceValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateParentDisk(DirectAccessDeviceImpl aParent) {
            if (aParent.isSnapshotSource()) {
                return "Parent disk " + aParent.getAlias() + " is a snapshot volume source";
            }
            return null;
        }
    }

    private static class DiskCopyOperationValidation
    extends DiskParentValidation {
        DiskCopyOperationValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateParentDisk(DirectAccessDeviceImpl aParent) {
            ClusterImpl cluster = (ClusterImpl)SubdiskCreationValidator.getLogicObject(this.myCed.getClusterId());
            if (cluster.getCopyOperManager().isInvolvedInCopyOper(aParent.getCommKeyClassId())) {
                return "Parent disk " + aParent.getAlias() + " involved in copy operation";
            }
            return null;
        }
    }

    private static class DiskGdrValidation
    extends DiskParentValidation {
        DiskGdrValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateParentDisk(DirectAccessDeviceImpl aParent) {
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(aParent);
            if (pair == null) {
                pair = DRRootImpl.getInstance().getPairContainsISCSIDisk(aParent);
            }
            if (pair != null) {
                return "Parent disk " + aParent.getAlias() + " is part of a GDR pair";
            }
            return null;
        }
    }

    private static class DiskExposureValidation
    extends DiskParentValidation {
        DiskExposureValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateParentDisk(DirectAccessDeviceImpl aParent) {
            if (aParent.isExposed()) {
                return "The disk " + aParent.getAlias() + " is exposed";
            }
            return null;
        }
    }

    private static class DiskVolumeChildValidation
    extends DiskParentValidation {
        DiskVolumeChildValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected String validateParentDisk(DirectAccessDeviceImpl aParent) {
            VolumeImpl volParent = aParent.getParentVolume();
            if (volParent != null) {
                String[] msgBody = new String[]{aParent.getAlias(), volParent.getClassId() + " " + volParent.getAlias()};
                return ErrorMessage.DISK_HAS_VOLUME_CANNOT_CREATE_SUB_DISK.getMessage(msgBody);
            }
            return null;
        }
    }

    private static abstract class DiskParentValidation
    extends CreationValidator.ElementValidation {
        DiskParentValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_PARENT;
        }

        @Override
        protected String validate() {
            if (!this.myCed.isNested(this.getParameterCode())) {
                DirectAccessDeviceImpl parent = (DirectAccessDeviceImpl)SubdiskCreationValidator.getLogicObject((CommKeyClassId)this.myCed.getValue(this.getParameterCode()));
                return this.validateParentDisk(parent);
            }
            return null;
        }

        protected abstract String validateParentDisk(DirectAccessDeviceImpl var1);
    }

    private static class AliasUniqueValidation
    extends CreationValidator.ElementValidation {
        AliasUniqueValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS;
        }

        @Override
        protected String validate() {
            ClusterImpl cluster = (ClusterImpl)SubdiskCreationValidator.getLogicObject(this.myCed.getClusterId());
            String alias = (String)this.myCed.getValue(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
            DirectAccessDeviceImpl device = cluster.getStoragePool().getSubDirectAccessDevice(alias);
            if (device != null) {
                String[] msgParts = new String[]{alias, device.getAlias()};
                return ErrorMessage.SUB_DISK_ALIAS_ALREADY_IN_USE.getMessage(msgParts);
            }
            return null;
        }
    }
}

