/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation.raid;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrIpAddress;
import java.util.ArrayList;

public class AttachedRaidCreationValidator
extends CreationValidator {
    public AttachedRaidCreationValidator() {
        this.addMandatoryParameter(ClientParameterCode.VSWITCH_ID);
    }

    @Override
    protected String innerValidate(ClientConfigElementData aCed) {
        ArrayList<CreationValidator.ElementValidation> validations = new ArrayList<CreationValidator.ElementValidation>();
        validations.add(new RaidExistenceValidation(aCed));
        return this.executeValidations(validations);
    }

    private static class RaidExistenceValidation
    extends CreationValidator.ElementValidation {
        RaidExistenceValidation(ClientConfigElementData aCed) {
            super(aCed);
        }

        @Override
        protected ClientParameterCode getParameterCode() {
            return ClientParameterCode.ATTACHED_RAID_NAME;
        }

        @Override
        protected String validate() {
            String raidName = (String)this.myCed.getValue(ClientParameterCode.ATTACHED_RAID_NAME);
            SrEntityNameFormat raidWwn = (SrEntityNameFormat)this.myCed.getValue(ClientParameterCode.ATTACHED_RAID_UNIQUE_NAME);
            String ipStr1 = (String)this.myCed.getValue(ClientParameterCode.ATTACHED_RAID_CTRL_IP1);
            String ipStr2 = (String)this.myCed.getValue(ClientParameterCode.ATTACHED_RAID_CTRL_IP2);
            SrIpAddress ip1 = ipStr1 != null && !ipStr1.isEmpty() ? new SrIpAddress(ipStr1) : null;
            SrIpAddress ip2 = ipStr2 != null && !ipStr2.isEmpty() ? new SrIpAddress(ipStr2) : null;
            ClusterImpl cluster = (ClusterImpl)AttachedRaidCreationValidator.getLogicObject(this.myCed.getClusterId());
            if (cluster.getAttachedRaidsMgr().isExists(raidName, raidWwn, ip1, ip2)) {
                return null;
            }
            StringBuilder error = new StringBuilder();
            error.append("RAID with parameters name=");
            error.append(raidName).append(", ");
            error.append("wwn=").append(raidWwn).append(", ");
            error.append("first-control-IP=").append(ip1).append(", ");
            error.append("second-control-IP=").append(ip2).append(' ');
            error.append("does not exist");
            return error.toString();
        }
    }
}

