/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.validation.AlarmValidationKey;
import com.sanrad.nms.server.logic.validation.ValidatorKey;
import com.sanrad.nms.server.logic.validation.dr.DRAbortInitialSyncValidator;
import com.sanrad.nms.server.logic.validation.dr.DRAbortReplicateValidator;
import com.sanrad.nms.server.logic.validation.dr.DRDeleteCGValidator;
import com.sanrad.nms.server.logic.validation.dr.DRDeletePairValidator;
import com.sanrad.nms.server.logic.validation.dr.DRDisasterGroupValidation;
import com.sanrad.nms.server.logic.validation.dr.DREndInitialSyncValidator;
import com.sanrad.nms.server.logic.validation.dr.DRFallBackValidator;
import com.sanrad.nms.server.logic.validation.dr.DRGeneralValidation;
import com.sanrad.nms.server.logic.validation.dr.DRISyncTypeValidation;
import com.sanrad.nms.server.logic.validation.dr.DRPlanedFailOverValidator;
import com.sanrad.nms.server.logic.validation.dr.DRStartInitialSyncValidator;
import com.sanrad.nms.server.logic.validation.dr.DRStartReplicateValidator;
import com.sanrad.nms.server.logic.validation.dr.DRValidationKey;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRStateConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Validator {
    private ValidatorTable m_table = new ValidatorTable();
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Validator theInstance = new Validator();

    private Validator() {
    }

    public static Validator getInstance() {
        return theInstance;
    }

    public void isValidAccordingToAlarm(GeneralLogicObjectImpl aGeneralLogicObjectImpl, ParameterList state) throws IllegalValueException {
        Class<?> objClass = aGeneralLogicObjectImpl.getClass();
        ValidatorKey key = null;
        key = state != null ? new DRValidationKey(objClass, state) : new ValidatorKey(objClass);
        HashMap validator = (HashMap)this.m_table.get(key);
        if (validator == null) {
            return;
        }
        for (Map.Entry entry : validator.entrySet()) {
            Boolean alarmValue;
            AlarmType alarmType = (AlarmType)entry.getKey();
            if (this.validAlarm(aGeneralLogicObjectImpl, alarmType, alarmValue = (Boolean)entry.getValue())) continue;
            String shouldBe = "";
            if (alarmValue.booleanValue()) {
                shouldBe = ", required state";
            }
            if (state == null || aGeneralLogicObjectImpl == null) {
                throw new IllegalValueException("Cannot delete the item " + shouldBe + ": " + alarmType);
            }
            if (aGeneralLogicObjectImpl instanceof DRActivate && DRActivateConstant.ABORT_REPLICATE.equals(state.getParameter(0).getValue())) {
                DRClusterLogicObjectImpl inactiveDrClusterLogicObjectImpl = ((DRLogicObjectImpl)aGeneralLogicObjectImpl).getInactiveElement();
                this.handleInconsistentDrStateBetweenSites(aGeneralLogicObjectImpl, inactiveDrClusterLogicObjectImpl);
                DRClusterLogicObjectImpl activeDrClusterLogicObjectImpl = ((DRLogicObjectImpl)aGeneralLogicObjectImpl).getActiveElement();
                this.handleInconsistentDrStateBetweenSites(aGeneralLogicObjectImpl, activeDrClusterLogicObjectImpl);
            }
            throw new IllegalValueException("Cannot perform this action on " + aGeneralLogicObjectImpl + shouldBe + ": " + alarmType);
        }
    }

    private void handleInconsistentDrStateBetweenSites(GeneralLogicObjectImpl aGeneralLogicObjectImpl, DRClusterLogicObjectImpl drClusterElement) throws IllegalValueException {
        if (drClusterElement != null && !drClusterElement.isParameterEqual((Parameters)new MasterParameter((ParameterCodes)((DRLogicObjectImpl)aGeneralLogicObjectImpl).getParameterCode((ParameterCodes)MasterParameterCode.DR_REPLICATION_STATE), (Object)DRReplicationStateConstant.INACTIVE), drClusterElement.getActiveVswitch())) {
            ErrorAssertingListener.listenTo(drClusterElement.changeElementForActiveVswitch(new MasterParameter((ParameterCodes)drClusterElement.getActivateParameterCode(), (Object)DRActivateConstant.ABORT_REPLICATE)));
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{DRActivateConstant.ABORT_REPLICATE, " active state is not the same in local and remote"});
            throw new UnsupportedOperationException();
        }
    }

    private boolean validAlarm(GeneralLogicObjectImpl drObj, AlarmType alarm, Boolean alarmValue) {
        List vecAlarm = new ArrayList();
        vecAlarm = !(drObj instanceof DRLogicObject) ? AlarmMgrImpl.getInstance().getAlarms(drObj) : DrAlarmMgrImpl.getInstance().getAlarms(drObj);
        if (vecAlarm != null) {
            for (int i = 0; i < vecAlarm.size(); ++i) {
                AlarmImpl check = (AlarmImpl)vecAlarm.get(i);
                if (!check.getType().equals((Object)alarm) || check.getVSwitch() != null && !check.getVSwitch().isConnected()) continue;
                return alarmValue;
            }
        }
        return alarmValue == false;
    }

    public Boolean validAccordingToParameter(GeneralLogicObjectImpl source, AlarmType alarm, VSwitchImpl vswitch) throws RemoteException {
        AlarmValidationKey key = new AlarmValidationKey(source.getClass(), alarm);
        Object obj = this.m_table.get(key);
        if (obj == null || !(obj instanceof ParameterList)) {
            return null;
        }
        ParameterList params = (ParameterList)obj;
        GeneralLogicObjectImpl logicSource = source;
        if (source instanceof DRLogicObjectImpl) {
            DRClusterLogicObjectImpl remoteDRElement;
            DRClusterLogicObjectImpl drLogicSource = null;
            DRLogicObjectImpl drObject = (DRLogicObjectImpl)source;
            DRClusterLogicObjectImpl localDRElement = drObject.getLocalElement();
            if (localDRElement != null && vswitch != null && (vswitch.equals(localDRElement.getActiveVswitch()) || vswitch.equals(localDRElement.getInactiveVSwitch()))) {
                drLogicSource = localDRElement;
            }
            if (drLogicSource == null && (remoteDRElement = drObject.getRemoteElement()) != null && vswitch != null && (vswitch.equals(remoteDRElement.getActiveVswitch()) || vswitch.equals(remoteDRElement.getInactiveVSwitch()))) {
                drLogicSource = remoteDRElement;
            }
            if (drLogicSource != null) {
                logicSource = drLogicSource;
            }
        }
        for (int i = 0; i < params.getLength(); ++i) {
            if (logicSource.isParameterEqual(params.getParameter(i), vswitch)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean validAccordingToBitSet(GeneralLogicObjectImpl source, AlarmType alarm) throws RemoteException {
        return !source.isStateOn(alarm);
    }

    public class ValidatorTable
    extends Hashtable<ValidatorKey, Object> {
        public ValidatorTable() {
            this.put(DRValidationKey.START_REPLICATE_DR_CG, DRStartReplicateValidator.START_REPLICATE_VALIDATOR);
            this.put(DRValidationKey.START_REPLICATE_DR_PAIR, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.ABORT_REPLICATE_DR_CG, DRAbortReplicateValidator.ABORT_REPLICATE_VALIDATOR);
            this.put(DRValidationKey.ABORT_REPLICATE_DR_PAIR, DRAbortReplicateValidator.ABORT_REPLICATE_VALIDATOR);
            this.put(DRValidationKey.FORCE_REPLICATE_DR_CG, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.FORCE_REPLICATE_DR_PAIR, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.SWITCH_DR_CG, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.SWITCH_DR_PAIR, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.PLANNED_FAIL_OVER_DR_CG, DRPlanedFailOverValidator.PLANED_FAIL_OVER_VALIDATOR);
            this.put(DRValidationKey.PLANNED_FAIL_OVER_DR_PAIR, DRPlanedFailOverValidator.PLANED_FAIL_OVER_VALIDATOR);
            this.put(DRValidationKey.FALL_BACK_DR_CG, DRFallBackValidator.FALL_BACK_VALIDATOR);
            this.put(DRValidationKey.FALL_BACK_DR_PAIR, DRFallBackValidator.FALL_BACK_VALIDATOR);
            this.put(DRValidationKey.DISASTER_CG, DRDisasterGroupValidation.DISASTER_VALIDATOR);
            this.put(DRValidationKey.ABORT_INITIAL_SYNC_DR_PAIR, DRAbortInitialSyncValidator.ABORT_INITIAL_SYNC_VALIDATOR);
            this.put(DRValidationKey.END_INITIAL_SYNC_DR_PAIR, DREndInitialSyncValidator.END_INITIAL_SYNC_VALIDATOR);
            this.put(DRValidationKey.START_INITIAL_SYNC_DR_PAIR, DRStartInitialSyncValidator.START_INITIAL_SYNC_VALIDATOR);
            this.put(DRValidationKey.NONE_INITIAL_SYNC_DR_PAIR, DRISyncTypeValidation.ISYNC_TYPE_VALIDATOR);
            this.put(DRValidationKey.OFFLINE_INITIAL_SYNC_DR_PAIR, DRISyncTypeValidation.ISYNC_TYPE_VALIDATOR);
            this.put(DRValidationKey.ONLINE_INITIAL_SYNC_DR_PAIR, DRISyncTypeValidation.ISYNC_TYPE_VALIDATOR);
            this.put(ValidatorKey.DELETE_PAIR, DRDeletePairValidator.DELETE_PAIR_VALIDATOR);
            this.put(ValidatorKey.DELETE_CG, DRDeleteCGValidator.DELETE_CG_VALIDATOR);
            this.put(AlarmValidationKey.INVERT_ROLE, MasterParameterCode.DR_ROLE);
            this.put(AlarmValidationKey.ILLEGAL_PAIR_CG, Boolean.TRUE);
            this.put(AlarmValidationKey.INCONS_REPLICATION, MasterParameterCode.DR_REPLICATION_STATE);
            this.put(AlarmValidationKey.NEED_SYNC, new ParameterList((ParameterCodes)MasterParameterCode.DR_INITIAL_SYNC_STATE, (Object)DRInitialSyncStateConstant.NEED_SYNC));
            this.put(AlarmValidationKey.CG_DR_UNKNOWN, new ParameterList((ParameterCodes)MasterParameterCode.DR_MODE, (Object)DRModeConstant.UNKNOWN));
            this.put(AlarmValidationKey.PAIR_STATE_ERROR, new ParameterList((ParameterCodes)ParameterCode.DR_PAIR_STATE, (Object)DRStateConstant.ERROR));
            this.put(AlarmValidationKey.IILEGAL_VOL_PAIR, Boolean.TRUE);
            this.put(AlarmValidationKey.INVERTED_PAIR, Boolean.TRUE);
            this.put(AlarmValidationKey.UNEQUIVELENT_PAIR, Boolean.TRUE);
        }
    }
}

