/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.TargetQosGroup;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TargetQosGroupImpl
extends LogicObjectImpl
implements TargetQosGroup {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public TargetQosGroupImpl(ClusterImpl aCluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(aCluster, ClassID.ISCSI_TARGET_QOS_GROUP, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.VSWITCH_ID, this.getActiveVswitch().getCommKeyClassId());
        return params;
    }

    public SrString getAlias() {
        return (SrString)this.getSrValueOf(ParameterCode.TARGET_QOS_GROUP_ALIAS);
    }

    public SrGauge getRateLimit() {
        return (SrGauge)this.getSrValueOf(ParameterCode.TARGET_QOS_GROUP_RATE_LIMIT);
    }

    @Override
    protected String isValid(HashMap parameterList) {
        Long rateLimit;
        String alias = (String)parameterList.get(ClientParameterCode.TARGET_QOS_GROUP_ALIAS);
        if (alias != null) {
            parameterList.put(ClientParameterCode.TARGET_QOS_GROUP_ALIAS, new SrString(alias));
        }
        if ((rateLimit = (Long)parameterList.get(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT)) != null) {
            parameterList.put(ClientParameterCode.TARGET_QOS_GROUP_RATE_LIMIT, new SrGauge(rateLimit.longValue()));
        }
        return null;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClassId()).append("]:").append(this.hashKey());
        sb.append(" Alias = ").append(this.getAlias());
        sb.append(" Rate Limit = ").append(this.getRateLimit());
        return sb.toString();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.TARGET_QOS_GROUP_ALIAS, new ParameterCode.Flags(false, false));
        parameterCodeFlagsMap.put(ParameterCode.TARGET_QOS_GROUP_RATE_LIMIT, new ParameterCode.Flags(false, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

