/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.target.ISCSITargetAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatisticsImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.ISCSITargetLoginFailureTypeConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ISCSITargetImpl
extends TargetImpl
implements ISCSITarget,
SitesSynchronizeable {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private ArrayList<ISCSISessionImpl> mySessions = new ArrayList();
    private ArrayList<ISCSIRemoteInitiatorImpl> myRemoteInitiators = new ArrayList();
    private CredentialsImpl myCredentials;
    private static SrLogger theLogger;

    public ISCSITargetImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_TARGET, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        final SrFuture retFuture = new SrFuture("ISCSITargetImpl.changeElement");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        Object userName = parameterList.get(ClientParameterCode.TARGET_USER_NAME);
        Object password = parameterList.get(ClientParameterCode.TARGET_PASSWORD);
        if (parameterList.containsKey(ClientParameterCode.TARGET_NAME)) {
            throw new IllegalValueException("The parameters to change include the target name which can not be changed.");
        }
        if (userName != null || password != null) {
            HashMap map = new HashMap();
            if (userName != null) {
                map.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, userName);
            }
            if (password != null) {
                map.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, password);
            }
            if (this.getCredentials() != null) {
                midFutures.add(this.getCredentials().changeElement(map));
            } else {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Credentials of ", this.getClassId(), " ", this, " at cluster ", this.getCluster(), " is null - change cannot be made"});
            }
        }
        midFutures.add(super.changeElement(parameterList));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public void clear() throws RemoteException {
        this.mySessions.clear();
        this.myRemoteInitiators.clear();
        this.setCredentials(null);
        super.clear();
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_TARGET_REMOTE_INITIATORS, this.getISCSIRemoteInitiators());
        parameterList.put(ClientParameterCode.TARGET_SESSIONS, this.getISCSISessions());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, this.getNumberOfLoginFailure());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, this.getLastLoginFailureTime());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, this.getLastLoginFailureType());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, this.getLastLoginFailureInitiatorName());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, this.getLastLoginFailureInitiatorIP());
        return parameterList;
    }

    public String getPassword() {
        return "";
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        for (int i = 0; i < this.getConnectedVSwitchCounter(); ++i) {
            if (this.getConnectedVSwitches()[i] == null || !this.getConnectedVSwitches()[i].getName().equals(this.getExposedOnVSwitch(this.getConnectedVSwitches()[i]))) continue;
            return this.getConnectedVSwitches()[i];
        }
        return super.getDominantVswitch();
    }

    private VSwitchImpl getVSwitchToCheck() {
        VSwitchImpl vswitchUnderTakeOver;
        VSwitchImpl vswitchToCheck = null;
        String vswitchNameExposedOn = this.getExposedOnVSwitch();
        VSwitchImpl vswitchExposedOn = this.getCluster().getVSwitchByName(vswitchNameExposedOn);
        vswitchToCheck = this.getCluster().isSingleVSwitchMode() ? vswitchExposedOn : ((vswitchUnderTakeOver = this.getCluster().getVSwitchUnderTakeover()) == null ? vswitchExposedOn : vswitchUnderTakeOver);
        return vswitchToCheck;
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_TARGET_ALIAS, vSwitch == null);
    }

    @Override
    public String getName(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_TARGET_NAME, vSwitch == null);
    }

    @Override
    public BigInteger getNumberOfLoginFailure() {
        VSwitchImpl vswitchToCheck = this.getVSwitchToCheck();
        BigInteger num = (BigInteger)this.getValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, false);
        if (num == null && !this.getCluster().isSingleVSwitchMode()) {
            VSwitchImpl otherVswitch = this.getCluster().getOtherVSwitch(vswitchToCheck);
            num = (BigInteger)this.getValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, false);
        }
        if (num == null) {
            num = new BigInteger("0", 10);
        }
        return num;
    }

    @Override
    public Long getLastLoginFailureTime() {
        VSwitchImpl vswitchToCheck = this.getVSwitchToCheck();
        Long time = (Long)this.getValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME);
        if (time == null && !this.getCluster().isSingleVSwitchMode()) {
            VSwitchImpl otherVswitch = this.getCluster().getOtherVSwitch(vswitchToCheck);
            time = (Long)this.getValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, false);
        }
        if (time == null) {
            time = new Long(0L);
        }
        return time;
    }

    @Override
    public ISCSITargetLoginFailureTypeConstant getLastLoginFailureType() {
        VSwitchImpl vswitchToCheck = this.getVSwitchToCheck();
        ISCSITargetLoginFailureTypeConstant type = (ISCSITargetLoginFailureTypeConstant)this.getSrValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, false);
        if (type == null && !this.getCluster().isSingleVSwitchMode()) {
            VSwitchImpl otherVswitch = this.getCluster().getOtherVSwitch(vswitchToCheck);
            type = (ISCSITargetLoginFailureTypeConstant)this.getSrValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, false);
        }
        return type;
    }

    @Override
    public String getLastLoginFailureInitiatorName() {
        VSwitchImpl vswitchToCheck = this.getVSwitchToCheck();
        String name = (String)this.getValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, false);
        if (name == null && !this.getCluster().isSingleVSwitchMode()) {
            VSwitchImpl otherVswitch = this.getCluster().getOtherVSwitch(vswitchToCheck);
            name = (String)this.getValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, false);
        }
        return name;
    }

    @Override
    public String getLastLoginFailureInitiatorIP() {
        VSwitchImpl vswitchToCheck = this.getVSwitchToCheck();
        String ip = this.getDisplayStringOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP);
        if (ip == null && !this.getCluster().isSingleVSwitchMode()) {
            VSwitchImpl otherVswitch = this.getCluster().getOtherVSwitch(vswitchToCheck);
            ip = this.getDisplayStringOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP);
        }
        return ip;
    }

    @Override
    public String getUserName() {
        return this.myCredentials == null ? null : this.myCredentials.getUserName();
    }

    public void setCredentials(CredentialsImpl credentials) {
        this.myCredentials = credentials;
    }

    public CredentialsImpl getCredentials() {
        return this.myCredentials;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return ISCSITargetAlarmGenerator.getInstance();
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        StorageImpl storage = this.cluster.getStorage();
        AclImpl acl = this.getAclForTarget();
        if (acl != null && !this.isInSynchronizingMode()) {
            AclEntryImpl firstEntry = acl.getFirstEntry();
            ErrorAssertingListener.listenTo(storage.createISCSITarget(this.getName(), this.getAlias(), firstEntry.getPermission(), this.getExposedOnVSwitch(), this.cluster.getOtherVSwitches(this.getVSwitches())));
            this.setSynchronizingMode(true);
            return 2;
        }
        return 3;
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.getAclForTarget().synchronizeMe();
            Vector<LUImpl> lus = this.getLUs();
            int numOfLuns = lus.size();
            for (int i = 0; i < numOfLuns; ++i) {
                LUImpl currLu = lus.get(i);
                currLu.synchronizeMe();
            }
        }
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String result = super.isValid(parameterList);
        if (result == null) {
            String password;
            String userName = (String)parameterList.get(ClientParameterCode.TARGET_USER_NAME);
            if (userName != null) {
                parameterList.put(ClientParameterCode.TARGET_USER_NAME, new SrString(userName));
            }
            if ((password = (String)parameterList.get(ClientParameterCode.TARGET_PASSWORD)) != null) {
                parameterList.put(ClientParameterCode.TARGET_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    public String getTargetDeviceKey() throws RemoteException {
        String targetDeviceKey = "";
        CommKey[] commKeys = this.getCommKeys();
        String targetkey = commKeys[0].getKey();
        targetDeviceKey = targetkey.substring(targetkey.indexOf(".") + 1);
        return targetDeviceKey;
    }

    @Override
    public ISCSIRemoteInitiator[] getISCSIRemoteInitiators() throws RemoteException {
        ISCSIRemoteInitiator[] array = new ISCSIRemoteInitiator[this.myRemoteInitiators.size()];
        return this.myRemoteInitiators.toArray(array);
    }

    public void addRemoteInitiator(ISCSIRemoteInitiatorImpl remoteInitiator) {
        this.myRemoteInitiators.add(remoteInitiator);
    }

    public boolean initiatorKnownByTarget(ISCSIRemoteInitiatorImpl initiatorImpl) {
        for (int index = 0; index < this.myRemoteInitiators.size(); ++index) {
            if (!initiatorImpl.equals(this.myRemoteInitiators.get(index))) continue;
            return true;
        }
        return false;
    }

    private CommKeyClassId[] getSessionsKeys(ParameterCode code) throws RemoteException {
        CommKeyClassId[] initiatorsKeys = (CommKeyClassId[])this.getSrArrayValueOf(code);
        return initiatorsKeys;
    }

    @Override
    public ISCSISession[] getISCSISessions() throws RemoteException {
        ISCSISession[] array = new ISCSISession[this.mySessions.size()];
        return this.mySessions.toArray(array);
    }

    public void addSession(ISCSISessionImpl session) {
        this.mySessions.add(session);
    }

    public void removeSession(ISCSISessionImpl session) {
        this.mySessions.remove(session);
    }

    public void removeSessionStatisticsElement(ISCSISessionStatisticsImpl sessionImpl) throws RemoteException {
        try {
            LogicObject[] sessions = this.getISCSISessionsStatistics();
            for (int i = 0; i < sessions.length; ++i) {
                ISCSISessionStatisticsImpl session = (ISCSISessionStatisticsImpl)sessions[i];
                if (session == null || !sessionImpl.equals(session)) continue;
                sessions[i] = null;
                break;
            }
            CommKeyClassId[] leftSessionCommkeys = this.convertSessionsVecToCommkeysClassIds(sessions);
            this.setOneParameter(ParameterCode.ISCSI_SESSION_STATISTICS_ID, leftSessionCommkeys, null);
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Cannot set left sessions statistics of target! ", ive.getMessage()});
        }
    }

    public ISCSISessionStatistics[] getISCSISessionsStatistics() throws RemoteException {
        ArrayList<ISCSISessionStatisticsImpl> allSessions = new ArrayList<ISCSISessionStatisticsImpl>();
        CommKeyClassId[] sessionsKeys = this.getSessionsKeys(ParameterCode.ISCSI_SESSION_STATISTICS_ID);
        if (sessionsKeys != null) {
            for (int i = 0; i < sessionsKeys.length; ++i) {
                ISCSISessionStatisticsImpl sessionImpl;
                if (sessionsKeys[i] == null || (sessionImpl = (ISCSISessionStatisticsImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sessionsKeys[i])) == null) continue;
                allSessions.add(sessionImpl);
            }
        }
        ISCSISessionStatistics[] array = new ISCSISessionStatistics[allSessions.size()];
        return allSessions.toArray(array);
    }

    public void addSessionStatisticsElement(ISCSISessionStatisticsImpl sessionImpl) throws RemoteException {
        try {
            LogicObject[] sessions = this.getISCSISessionsStatistics();
            CommKeyClassId[] leftSessionsCommkeys = this.convertAndAddSessionsVecToCommkeysClassIds(sessions, sessionImpl);
            this.setOneParameter(ParameterCode.ISCSI_SESSION_STATISTICS_ID, leftSessionsCommkeys, null);
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive, "Cannot set Session statistics of target! "});
        }
    }

    private CommKeyClassId[] convertSessionsVecToCommkeysClassIds(LogicObject[] array) throws RemoteException {
        CommKeyClassId[] arr = new CommKeyClassId[array.length];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            LogicObjectImpl session = (LogicObjectImpl)array[i];
            CommKeyClassId sessionCommkeyClassId = session.getCommKeyClassId();
            arr[index++] = sessionCommkeyClassId;
        }
        return arr;
    }

    private CommKeyClassId[] convertAndAddSessionsVecToCommkeysClassIds(LogicObject[] array, LogicObjectImpl newObject) throws RemoteException {
        CommKeyClassId[] arr = new CommKeyClassId[array.length];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            LogicObjectImpl session = (LogicObjectImpl)array[i];
            CommKeyClassId sessionCommkeyClassId = session.getCommKeyClassId();
            arr[index++] = sessionCommkeyClassId;
        }
        arr[index++] = newObject.getCommKeyClassId();
        return arr;
    }

    public boolean sessionStatisticsKnownByTarget(ISCSISessionStatisticsImpl sessionImpl) throws RemoteException {
        ISCSISessionStatistics[] sessions = this.getISCSISessionsStatistics();
        for (int index = 0; index < sessions.length; ++index) {
            if (!sessionImpl.equals((ISCSISessionStatisticsImpl)sessions[index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public SrFuture<Void> synchronizeDiscoveryElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        VSwitchImpl vswitch = this.getExposedOnVSwitchObject();
        ArrayList<PortalTableRowImpl> clusterPortals = this.getCluster().getAllTargetPortals(vswitch);
        String[] remoteTargetPortalIPs = new String[clusterPortals.size()];
        BigInteger[] remoteTargetPortalPorts = new BigInteger[clusterPortals.size()];
        Integer[] remoteTargetPortalGroupTags = new Integer[clusterPortals.size()];
        this.parseClusterPortalsToArrays(clusterPortals, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags);
        try {
            return remoteCluster.getStorage().createISCSIRemoteTarget(this.getName(), this.getAlias(), null, null, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, false);
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)ive), new Object[]{"impossible to reach here, and if so, that means this remote target is already configured on the remote site"});
            return new FailedFuture((Exception)((Object)ive), "ISCSITargetImpl.synchronizeDiscoveryElementOnRemoteCluster");
        }
    }

    private void parseClusterPortalsToArrays(ArrayList clusterPortals, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags) throws RemoteException {
        for (int index = 0; index < clusterPortals.size(); ++index) {
            PortalTableRowImpl portal = (PortalTableRowImpl)clusterPortals.get(index);
            remoteTargetPortalIPs[index] = new String(portal.getIPAddress());
            remoteTargetPortalPorts[index] = new BigInteger(String.valueOf(portal.getPort()), 10);
            remoteTargetPortalGroupTags[index] = new Integer(portal.getTag());
        }
    }

    @Override
    public SrFuture<Void> synchronizeNewElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        ISCSIRemoteTargetImpl equivalentRemoteTarget = this.getCluster().findLocalTargetInRemoteCluster(remoteCluster, this.getName());
        if (equivalentRemoteTarget != null) {
            ISCSIRemoteTargetImpl remoteTarget = equivalentRemoteTarget;
            VSwitchImpl[] connectedVSwitches = remoteTarget.getConnectedVSwitches();
            VSwitchImpl vswitch = this.getExposedOnVSwitchObject();
            ArrayList<PortalTableRowImpl> clusterPortals = this.getCluster().getAllTargetPortals(vswitch);
            return remoteTarget.createAllLocalPortalsInRemoteCluster(clusterPortals, connectedVSwitches);
        }
        return new CompleteFuture("ISCSITargetImpl.synchronizeNewElementOnRemoteCluster");
    }

    @Override
    public void synchronizeChangeElementOnRemoteCluster(ClusterImpl remoteCluster, HashMap changedValues) throws RemoteException {
    }

    @Override
    public SrFuture<Void> synchronizePreRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
        ISCSIRemoteTargetImpl equivalentRemoteTarget = this.getCluster().findLocalTargetInRemoteCluster(remoteCluster, this.getName());
        if (equivalentRemoteTarget == null) {
            theLogger.warn(SrLogCategories.INFORMATIVE, new Object[]{"Got null ISCSIRemoteTarget for remoteCluster ", remoteCluster, "; name: ", this.getName()});
            return new CompleteFuture("ISCSITargetImpl.synchronizePreRemoveElementOnRemoteCluster");
        }
        FailedFuture retVal = null;
        try {
            retVal = equivalentRemoteTarget.siteSynchronizationDelete();
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.EXCEPTION, new Object[]{"Cannot delete remote target due to delete of a local target for site synch. Exception: ", ive.getMessage()});
            retVal = new FailedFuture((Exception)((Object)ive), "ISCSITargetImpl.synchronizePreRemoveElementOnRemoteCluster");
        }
        return retVal;
    }

    @Override
    public void synchronizePostRemoveElementOnRemoteCluster(ClusterImpl remoteCluster) throws RemoteException {
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() throws RemoteException {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.ISCSI_TARGET_ALIAS);
        params.add(ParameterCode.ISCSI_TARGET_NAME);
        params.add(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON);
        if (this.getSrValueOf(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS) != null) {
            params.add(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS);
        }
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_ALIAS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_TARGET_PORT_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_STATISTICS_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_STATISTICS_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_DEVICE_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

