/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.target.ISCSIRemoteTargetPortalAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ISCSIRemoteTargetPortalImpl
extends SynchronizeableImpl
implements ISCSIRemoteTargetPortal {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public ISCSIRemoteTargetPortalImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_REMOTE_TARGET_PORTAL, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public ISCSIRemoteTarget getRemoteTarget() throws RemoteException {
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        if (targetCommKeyClassId != null) {
            ISCSIRemoteTargetImpl targetImpl = (ISCSIRemoteTargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
            return targetImpl;
        }
        return null;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.toStringValue = this.getIPAddress() + ":" + this.getPort();
        return changedValues;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.getRemoteTarget();
        ced.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_ID, (Object)remoteTarget.getCommKeyClassId()));
        if (remoteTarget.isInDeletionProcess()) {
            ced.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_IN_DELETE_PROCESS, (Object)new SrBoolean(true)));
        }
        return this.deleteElement(ced);
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start Sync of remote target portal ", this.toString()});
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Already synchronizing ", this.getClassId(), " ", this.toString()});
            return 1;
        }
        int retVal = 0;
        try {
            retVal = super.synchronize();
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of remote target portal ", this.toString(), " After Super completion status ", retVal});
            if (retVal != 3) {
                if (!this.isNeedToSynchronize()) {
                    this.setSynchronizePending(false);
                    return retVal;
                }
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of ISCSI remote target portal ", this.toString(), " SyncMe status ", retVal});
            }
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        List<VSwitchImpl> vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        VSwitchImpl[] vswitch = new VSwitchImpl[]{vSwitchToSync.get(0)};
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.getRemoteTarget();
        ErrorAssertingListener.listenTo(remoteTarget.createISCSIRemoteTargetPortal(this.getIPAddress(), this.getPort().intValue(), this.getPortalGroupTag(), vswitch, null));
        return 2;
    }

    public boolean isSynchronizedBetweenVSwitches(VSwitchImpl sourceVSwitch) throws RemoteException {
        boolean reply = true;
        VSwitchImpl[] vswitches = this.getConnectedVSwitches();
        if (vswitches.length > 1) {
            VSwitchImpl vswitch1 = sourceVSwitch;
            VSwitchImpl vswitch2 = vswitches[0].equals(sourceVSwitch) ? vswitches[1] : vswitches[0];
            Integer groupTagVSwitch1 = this.getPortalGroupTag(vswitch1);
            Integer groupTagVSwitch2 = this.getPortalGroupTag(vswitch2);
            String ipVSwitch1 = this.getIPAddress(vswitch1);
            String ipVSwitch2 = this.getIPAddress(vswitch2);
            BigInteger portVSwitch1 = this.getPort(vswitch1);
            BigInteger portVSwitch2 = this.getPort(vswitch2);
            if (!(groupTagVSwitch1.equals(groupTagVSwitch2) && ipVSwitch1.equals(ipVSwitch2) && portVSwitch1.equals(portVSwitch2))) {
                reply = false;
            }
        }
        return reply;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return ISCSIRemoteTargetPortalAlarmGenerator.getInstance();
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.getRemoteTarget();
        if (remoteTarget.isNeedToSynchronize()) {
            if (!remoteTarget.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("Remote Target portal ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(remoteTarget.getClassId().toString());
                msg.append(" ");
                msg.append(remoteTarget.getName());
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Remote Target " + remoteTarget.getName() + " is not synchronized.";
            return msg;
        }
        return null;
    }

    @Override
    public Integer getPortalGroupTag() throws RemoteException {
        return this.getPortalGroupTag(null);
    }

    public Integer getPortalGroupTag(VSwitch vswitch) throws RemoteException {
        return (Integer)this.getValueOf(vswitch, ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, vswitch == null);
    }

    @Override
    public String getIPAddress() {
        return this.getIPAddress(null);
    }

    public String getIPAddress(VSwitchImpl vswitch) {
        Inet4Address ipAddress = (Inet4Address)this.getValueOf(vswitch, ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, vswitch == null);
        if (ipAddress != null) {
            String ipAddressStr = ipAddress.toString();
            if (ipAddressStr.startsWith("/")) {
                ipAddressStr = ipAddressStr.substring(1);
            }
            return ipAddressStr;
        }
        return null;
    }

    @Override
    public BigInteger getPort() throws RemoteException {
        return this.getPort(null);
    }

    public BigInteger getPort(VSwitch vswitch) throws RemoteException {
        return (BigInteger)this.getValueOf(vswitch, ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, vswitch == null);
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRedundant() {
        return true;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, this.getIPAddress());
        return parameterList;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> retVal = new ArrayList<ParameterCode>();
        retVal.add(ParameterCode.VSWITCH_ID);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        retVal.add(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_ID);
        return retVal;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_TARGET_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

