/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryStateConstant;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class ISCSIRemotePortalDiscoveryImpl
extends SynchronizeableImpl
implements ISCSIRemotePortalDiscovery {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String IDLE = "Idle";
    private static final String DISCOVERING = "Discovering";
    private static final String COMPLETED = "Completed";
    private static final String FAILED = "Failed";
    private static final String ALL = "all";
    private String m_clusterDisplayedState;
    private HashMap m_vswitchDisplayedStates = new HashMap();
    private boolean m_isOnInitProcess = false;
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public ISCSIRemotePortalDiscoveryImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    public void setOnInitProcess(boolean flag) {
        this.m_isOnInitProcess = flag;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_CLUSTER_STATE, this.getClusterDisplayedState());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_STATE, this.getVSwitchDisplayedState());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_LAST_FAILURE, this.getLastFailureType());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_LAST_SUCCESSFUL_DISCOVERY, this.getLastSuccessfulDiscovery());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_NEXT_PLANNED_DISCOVERY, this.getNextPlannedDiscovery());
        return parameterList;
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        HashMap changedValues = super.changeParameterList(aCED);
        if (changedValues.containsKey(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE)) {
            changedValues.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, this.getLastFailureType());
        }
        if (changedValues.containsKey(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME)) {
            changedValues.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, this.getLastSuccessfulDiscovery());
        }
        if (changedValues.containsKey(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY)) {
            changedValues.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, this.getNextPlannedDiscovery());
        }
        this.toStringValue = this.getIPAddress() + ":" + this.getPort();
        this.setDisplayedState(vSwitch, changedValues);
        return changedValues;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start Sync of remote discovery portal ", this.toString()});
        int retVal = 0;
        try {
            retVal = super.synchronize();
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of remote discovery portal ", this.toString(), " After Super completion status ", retVal});
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive.getMessage()});
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        VSwitchImpl otherVSwitchInCluster = this.getCluster().getOtherVSwitch(this.getActiveVswitch());
        ISCSIInitiatorImpl iscsiInitiator = (ISCSIInitiatorImpl)otherVSwitchInCluster.getISCSIInitiators()[0];
        ErrorAssertingListener.listenTo(iscsiInitiator.createRemoteDiscoveryPortal(this.getIPAddress(), this.getPort(), this.getPeriod()));
        return 2;
    }

    public boolean isSynchronizedBetweenVSwitches(VSwitchImpl sourceVSwitch) throws RemoteException {
        boolean reply = true;
        VSwitchImpl[] vswitches = this.getConnectedVSwitches();
        if (vswitches.length > 1) {
            VSwitchImpl vswitch1 = sourceVSwitch;
            VSwitchImpl vswitch2 = vswitches[0].equals(sourceVSwitch) ? vswitches[1] : vswitches[0];
            String ipVSwitch1 = this.getIPAddress(vswitch1);
            String ipVSwitch2 = this.getIPAddress(vswitch2);
            Integer portVSwitch1 = this.getPort(vswitch1);
            Integer portVSwitch2 = this.getPort(vswitch2);
            if (!ipVSwitch1.equals(ipVSwitch2) || !portVSwitch1.equals(portVSwitch2)) {
                reply = false;
            }
        }
        return reply;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public ISCSIInitiator[] getAllConnectedInitiators() throws RemoteException {
        ArrayList<ISCSIInitiator> initiators = new ArrayList<ISCSIInitiator>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            ISCSIInitiator initiator = this.getInitiator(connectedVswitches[index]);
            initiators.add(initiator);
        }
        ISCSIInitiator[] array = new ISCSIInitiator[initiators.size()];
        return initiators.toArray(array);
    }

    public ISCSIInitiator getInitiator(VSwitch vswitch) throws RemoteException {
        ISCSIInitiator[] initiators = vswitch.getISCSIInitiators();
        return initiators[0];
    }

    @Override
    public String getIPAddress() throws RemoteException {
        return this.getIPAddress(null);
    }

    public String getIPAddress(VSwitchImpl vswitch) {
        SrIpAddress ipAddress = (SrIpAddress)this.getSrValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_ADDRESS, vswitch == null);
        String ipAddressStr = ipAddress.toString();
        if (ipAddressStr.startsWith("/")) {
            ipAddressStr = ipAddressStr.substring(1);
        }
        return ipAddressStr;
    }

    @Override
    public Integer getPort() throws RemoteException {
        return this.getPort(null);
    }

    public Integer getPort(VSwitch vswitch) throws RemoteException {
        return (Integer)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_PORT, vswitch == null);
    }

    private void setDisplayedState(VSwitchImpl changedOnVSwitch, HashMap changedValues) throws RemoteException {
        Long lastSuccessfulDiscoveryOnVSwitch;
        Date newDate;
        String newDateStr;
        HashMap lastSuccessfulDiscovery;
        ISCSIRemotePortalDiscoveryFailureTypeConstant failureTypeOnVSwitch;
        HashMap failureType;
        ISCSIRemotePortalDiscoveryStateConstant state;
        if (this.m_isOnInitProcess) {
            state = this.getState(changedOnVSwitch);
            if (state != null) {
                this.m_clusterDisplayedState = state.toString();
            }
            this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), state.toString());
        }
        if ((state = (ISCSIRemotePortalDiscoveryStateConstant)changedValues.get(ParameterCode.REMOTE_PORTAL_DISC_STATE)) != null && state.equals((Object)ISCSIRemotePortalDiscoveryStateConstant.DISCOVERING)) {
            if (this.getConnectedVSwitches().length == 1) {
                this.m_clusterDisplayedState = state.toString();
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), state.toString());
            } else {
                StringBuffer sb;
                if (this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 && this.m_clusterDisplayedState.indexOf(ClassID.VSWITCH.toString()) > -1) {
                    sb = new StringBuffer();
                    sb.append(DISCOVERING);
                    sb.append(" [on ");
                    sb.append(ALL);
                    sb.append(" ");
                    sb.append(VSwitch.VSWITCHES_DISPLAY_STRING);
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                } else {
                    sb = new StringBuffer();
                    sb.append(DISCOVERING);
                    sb.append(" [on ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append(" ");
                    sb.append(changedOnVSwitch.getName());
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                }
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), state.toString());
            }
        }
        if ((failureType = (HashMap)changedValues.get(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE)) != null && !(failureTypeOnVSwitch = (ISCSIRemotePortalDiscoveryFailureTypeConstant)failureType.get(changedOnVSwitch.getName())).isNoFailure()) {
            StringBuffer sb;
            if (this.getConnectedVSwitches().length == 1) {
                sb = new StringBuffer();
                sb.append(FAILED);
                sb.append(". Failure type: ");
                sb.append(failureTypeOnVSwitch.toString());
                this.m_clusterDisplayedState = sb.toString();
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            } else {
                if ((this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 || this.m_clusterDisplayedState.indexOf(COMPLETED) > -1) && this.m_clusterDisplayedState.indexOf(ALL) > -1) {
                    sb = new StringBuffer();
                    sb.append(DISCOVERING);
                    sb.append(" [on ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append(" ");
                    sb.append(changedOnVSwitch.getName());
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                } else if (this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 || this.m_clusterDisplayedState.indexOf(FAILED) > -1 && this.m_clusterDisplayedState.indexOf(changedOnVSwitch.getName()) == -1) {
                    sb = new StringBuffer();
                    sb.append(FAILED);
                    sb.append(" [on ");
                    sb.append(ALL);
                    sb.append(" ");
                    sb.append(VSwitch.VSWITCHES_DISPLAY_STRING);
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                }
                sb = new StringBuffer();
                sb.append(FAILED);
                sb.append(". Failure type: ");
                sb.append(failureTypeOnVSwitch.toString());
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            }
        }
        if ((lastSuccessfulDiscovery = (HashMap)changedValues.get(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME)) != null && (newDateStr = this.convertToDisplayedSuccessfulTime(newDate = new Date(lastSuccessfulDiscoveryOnVSwitch = (Long)lastSuccessfulDiscovery.get(changedOnVSwitch.getName())))) != null && newDateStr != "N/A") {
            if (this.getConnectedVSwitches().length == 1) {
                StringBuffer sb = new StringBuffer();
                sb.append(COMPLETED);
                sb.append(" at ");
                sb.append(newDate.toString());
                this.m_clusterDisplayedState = sb.toString();
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            } else {
                StringBuffer sb;
                if (this.m_clusterDisplayedState.indexOf(IDLE) > -1 || this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 || this.m_clusterDisplayedState.indexOf(FAILED) > -1) {
                    sb = new StringBuffer();
                    sb.append(COMPLETED);
                    sb.append(" [on ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append(" ");
                    sb.append(changedOnVSwitch.getName());
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                } else if (this.m_clusterDisplayedState.indexOf(COMPLETED) > -1) {
                    sb = new StringBuffer();
                    sb.append(COMPLETED);
                    sb.append(" [on ");
                    sb.append(ALL);
                    sb.append(" ");
                    sb.append(VSwitch.VSWITCHES_DISPLAY_STRING);
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                }
                sb = new StringBuffer();
                sb.append(COMPLETED);
                sb.append(" at ");
                sb.append(newDate.toString());
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            }
        }
    }

    private String convertToDisplayedSuccessfulTime(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        if (hour == 0 && min == 0 && sec == 0) {
            return "N/A";
        }
        return time.toString();
    }

    @Override
    public String getClusterDisplayedState() throws RemoteException {
        return this.m_clusterDisplayedState;
    }

    public String getVSwitchDisplayedState(VSwitch vswitch) throws RemoteException {
        return (String)this.m_vswitchDisplayedStates.get(vswitch.getName());
    }

    @Override
    public HashMap getVSwitchDisplayedState() throws RemoteException {
        return this.m_vswitchDisplayedStates;
    }

    @Override
    public HashMap getState() throws RemoteException {
        VSwitchImpl[] connectedVswitches;
        HashMap<String, ISCSIRemotePortalDiscoveryStateConstant> states = new HashMap<String, ISCSIRemotePortalDiscoveryStateConstant>();
        for (VSwitchImpl vswitch : connectedVswitches = this.getConnectedVSwitches()) {
            ISCSIRemotePortalDiscoveryStateConstant state = this.getState(vswitch);
            states.put(vswitch.getName(), state);
        }
        return states;
    }

    public ISCSIRemotePortalDiscoveryStateConstant getState(VSwitchImpl vswitch) throws RemoteException {
        return (ISCSIRemotePortalDiscoveryStateConstant)this.getSrValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_STATE, vswitch == null);
    }

    @Override
    public Integer getPeriod() throws RemoteException {
        return this.getPeriod(null);
    }

    public Integer getPeriod(VSwitch vswitch) throws RemoteException {
        return (Integer)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_PERIOD, vswitch == null);
    }

    @Override
    public HashMap getLastFailureType() throws RemoteException {
        HashMap<String, ISCSIRemotePortalDiscoveryFailureTypeConstant> types = new HashMap<String, ISCSIRemotePortalDiscoveryFailureTypeConstant>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            ISCSIRemotePortalDiscoveryFailureTypeConstant type = this.getLastFailureType(vswitch);
            types.put(vswitch.getName(), type);
        }
        return types;
    }

    public ISCSIRemotePortalDiscoveryFailureTypeConstant getLastFailureType(VSwitch vswitch) throws RemoteException {
        return (ISCSIRemotePortalDiscoveryFailureTypeConstant)this.getSrValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, vswitch == null);
    }

    @Override
    public HashMap getLastSuccessfulDiscovery() throws RemoteException {
        HashMap<String, Long> times = new HashMap<String, Long>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            Long time = this.getLastSuccessfulDiscovery(vswitch);
            times.put(vswitch.getName(), time);
        }
        return times;
    }

    public Long getLastSuccessfulDiscovery(VSwitch vswitch) throws RemoteException {
        return (Long)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, vswitch == null);
    }

    @Override
    public HashMap getNextPlannedDiscovery() throws RemoteException {
        HashMap<String, BigInteger> times = new HashMap<String, BigInteger>();
        VSwitchImpl[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitchImpl vswitch = connectedVswitches[index];
            BigInteger time = this.getNextPlannedDiscovery(vswitch);
            times.put(vswitch.getName(), time);
        }
        return times;
    }

    public BigInteger getNextPlannedDiscovery(VSwitch vswitch) throws RemoteException {
        return (BigInteger)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, vswitch == null);
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(String ip, int port) throws RemoteException {
        return this.getIPAddress().equals(ip) && this.getPort() == port;
    }

    @Override
    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws IllegalValueException {
        CommKeyClassId[] vswitches = this.getConnectedVswitchesData();
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vswitches));
    }

    @Override
    public SrFuture<Void> discoverRemoteTargets() throws RemoteException, IllegalValueException {
        return this.changeElement(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_ACTIVATE, ISCSIRemotePortalDiscoveryStateConstant.DISCOVERING);
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_ACTIVATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_PERIOD, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.REMOTE_PORTAL_DISC_STATE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

