/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage.pooling;

import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceImpl;
import com.sanrad.nms.server.logic.storage.StoragePoolMgr;
import com.sanrad.nms.server.logic.storage.pooling.StorageAllocation;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.util.Util;
import com.sanrad.util.virtualization.Allocable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class StorageResource
implements Allocable {
    private BigInteger myRemainingFreeSpace;
    private VSwitchImpl myAttachedVswitch;
    private DirectAccessDeviceImpl myDisk;
    private List<StorageSpaceImpl> myFreeSpaceFragments;
    private List<VSwitchImpl> myExposedOnVswitches;
    private ArrayList<BigInteger> myAllocations = new ArrayList();
    private ArrayList<BigInteger> myAllocationsStartAddresses = new ArrayList();

    StorageResource(DirectAccessDeviceImpl aDisk) {
        Util.validateInputNotNull((Object)aDisk, (String)"Disk");
        this.myDisk = aDisk;
        this.myRemainingFreeSpace = aDisk.getAllocationSpace();
        this.myAttachedVswitch = StoragePoolMgr.getRaidAttachedVswitch(aDisk.getCluster(), aDisk.getEntityNameValue());
        this.myFreeSpaceFragments = aDisk.getFreeSpaceFragments();
        this.myExposedOnVswitches = this.myDisk.getExposedOnVswitches();
    }

    public DirectAccessDeviceImpl getDisk() {
        return this.myDisk;
    }

    public BigInteger getAllocationSpace() {
        return this.myRemainingFreeSpace;
    }

    public VSwitchImpl getRaidAttachedVswitch() {
        return this.myAttachedVswitch;
    }

    public StorageAllocation allocateVirtualSpace(BigInteger aSize, VSwitchImpl aExposedOnVswitch) {
        Util.validateInputNotNull((Object)aSize, (String)"Size");
        if (this.myRemainingFreeSpace.compareTo(aSize) < 0) {
            throw new IllegalArgumentException("Allocation size cannot be bigger than the remaining size");
        }
        this.myAllocations.add(aSize);
        this.myExposedOnVswitches.add(aExposedOnVswitch);
        BigInteger startAddress = this.getRemainingSpaceStartAddress();
        this.myAllocationsStartAddresses.add(startAddress);
        this.myRemainingFreeSpace = this.myRemainingFreeSpace.subtract(aSize);
        return new StorageAllocation(this, aSize, startAddress);
    }

    public void freeLastAllocation() {
        if (!(this.myAllocations.isEmpty() || this.myAllocationsStartAddresses.isEmpty() || this.myExposedOnVswitches.isEmpty())) {
            BigInteger size = this.myAllocations.remove(this.myAllocations.size() - 1);
            this.myRemainingFreeSpace = this.myRemainingFreeSpace.add(size);
            this.myAllocationsStartAddresses.remove(this.myAllocationsStartAddresses.size() - 1);
            this.myExposedOnVswitches.remove(this.myExposedOnVswitches.size() - 1);
        }
    }

    public boolean isExposedOnVswitch(VSwitchImpl aVswitch) {
        Util.validateInputNotNull((Object)aVswitch, (String)"V-Switch");
        return this.myExposedOnVswitches.contains(aVswitch);
    }

    public List<VSwitchImpl> getExposedOnVswitches() {
        return new ArrayList<VSwitchImpl>(this.myExposedOnVswitches);
    }

    private BigInteger getRemainingSpaceStartAddress() {
        BigInteger blockSize = new BigInteger(String.valueOf(this.myDisk.getBlockSize()));
        if (this.myRemainingFreeSpace.compareTo(blockSize) < 0) {
            return null;
        }
        BigInteger virtualAllocatedSpace = this.myDisk.getAllocationSpace().subtract(this.myRemainingFreeSpace);
        for (StorageSpaceImpl fragment : this.myFreeSpaceFragments) {
            BigInteger curFragmentLeftover = fragment.getAllocationSpace().subtract(virtualAllocatedSpace);
            if (curFragmentLeftover.compareTo(blockSize) > 0) {
                return fragment.getStartAddress().add(virtualAllocatedSpace);
            }
            if ((virtualAllocatedSpace = virtualAllocatedSpace.subtract(fragment.getAllocationSpace())).compareTo(BigInteger.ZERO) >= 0) continue;
            virtualAllocatedSpace = BigInteger.ZERO;
        }
        return null;
    }

    public String toString() {
        return "StorageResource:" + this.myDisk.toString();
    }

    public boolean hasVirtualAllocations() {
        return !this.myAllocations.isEmpty();
    }
}

