/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.raid.AttachedRaidImpl;
import com.sanrad.nms.server.logic.storage.StoragePool;
import com.sanrad.nms.server.logic.storage.pooling.StorageAllocation;
import com.sanrad.nms.server.logic.storage.pooling.StorageFilter;
import com.sanrad.nms.server.logic.storage.pooling.StoragePoolingTool;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.AllocationPolicy;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.util.CompoundComparator;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SortKeyProvider;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrSortingMap;
import com.sanrad.util.virtualization.Allocable;
import com.sanrad.util.virtualization.AllocableGroup;
import com.sanrad.util.virtualization.AllocationUtil;
import com.sanrad.util.virtualization.ResourceAliasUtil;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StoragePoolMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private StoragePool myStoragePool;
    private ClusterImpl myCluster;
    private StoragePoolingTool myPoolingTool;
    private HashSet<String> myNewVolumeAliases;

    public StoragePoolMgr(ClusterImpl aCluster, StoragePool aStoragePool) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster must not be null");
        }
        if (aStoragePool == null) {
            throw new IllegalArgumentException("StoragePool must not be null");
        }
        this.myCluster = aCluster;
        this.myStoragePool = aStoragePool;
    }

    public void startAllocationRequest() {
        this.myPoolingTool = new StoragePoolingTool(this.getAllAvailableDisks());
        this.myNewVolumeAliases = new HashSet();
    }

    public ConfigElementData getExposeVolumeAllocationCed(ClientConfigElementData aClientCed) throws IllegalValueException {
        BigInteger size = (BigInteger)aClientCed.getValue(ClientParameterCode.VOLUME_SPACE);
        ClassID classId = aClientCed.getClassId();
        String alias = (String)aClientCed.getValue(ClientParameterCode.VOLUME_ALIAS);
        String targetName = (String)aClientCed.getValue(ClientParameterCode.TARGET_NAME);
        Long lun = (Long)aClientCed.getValue(ClientParameterCode.LU_LUN);
        String vswitchName = (String)aClientCed.getValue(ClientParameterCode.VSWITCH_NAME);
        PhysicalStorageDriveTypeConstant type = (PhysicalStorageDriveTypeConstant)aClientCed.getValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE);
        PhysicalStorageRaidLevelConstant raidLevel = (PhysicalStorageRaidLevelConstant)aClientCed.getValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL);
        CommKeyClassId targetQosId = (CommKeyClassId)aClientCed.getValue(ClientParameterCode.ISCSI_TARGET_QOS_GROUP_ID);
        targetQosId = LogicMgrAOImpl.getInstance().getServerCKCI(targetQosId);
        AllocationPolicy policy = (AllocationPolicy)aClientCed.getValue(ClientParameterCode.VOLUME_ALLOCATION_POLICY);
        if (ClassID.GENERAL_VOLUME.equals((Object)classId)) {
            return this.getExposeVolumeAllocationCed(alias, size, type, raidLevel, vswitchName, targetName, lun, targetQosId, policy);
        }
        if (ClassID.MIRROR_VOLUME.equals((Object)classId)) {
            return this.getCedForMirrorAllocation(alias, size, type, raidLevel, vswitchName, targetName, lun, targetQosId);
        }
        throw new UnsupportedOperationException("Auto-allocation for volume type " + classId + "is unsupported");
    }

    private ConfigElementData getExposeVolumeAllocationCed(String aVolumeAlias, BigInteger aSize, PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, String aExposedOnVswitchName, String aTargetName, Long aLun, CommKeyClassId aTargetQosId, AllocationPolicy aPolicy) throws IllegalValueException {
        this.validateVolumeAllocationRequest(aVolumeAlias, aSize, aExposedOnVswitchName, aTargetName, aLun);
        VSwitchImpl exposedOnVswitch = this.myCluster.getVSwitchByName(aExposedOnVswitchName);
        VSwitchImpl targetVswitch = this.getExposedOnVSwitchOfTarget(aTargetName);
        VSwitchImpl vswitch = exposedOnVswitch != null ? exposedOnVswitch : targetVswitch;
        VolumeSimpleAllocation allocData = this.getPreferredVolumeAllocation(aSize, aDriveType, aRaidLevel, vswitch, aPolicy);
        if (allocData == null) {
            throw new IllegalValueException(this.getAllocErrorMsg(aVolumeAlias, aSize));
        }
        Map<StorageAllocation, BigInteger> allocMap = allocData.getAllocation();
        if (allocMap == null) {
            throw new IllegalValueException(this.getAllocErrorMsg(aVolumeAlias, aSize));
        }
        int childIndex = this.getLastAliasIndex(aVolumeAlias);
        childIndex = childIndex < 0 ? 0 : childIndex;
        VolumeChildrenCounter childrenCounter = new VolumeChildrenCounter(childIndex);
        ConfigElementData volCed = this.createCedFromAllocationMap(allocMap, aVolumeAlias, childrenCounter);
        if (targetVswitch == null) {
            if (exposedOnVswitch == null) {
                exposedOnVswitch = allocData.getExposedOnVswitch();
            }
            return this.createExposeVolumeCed(volCed, aTargetName, exposedOnVswitch, aLun, aTargetQosId);
        }
        ISCSITargetImpl targetImpl = this.myCluster.getTargetListMgr().getTargetByName(aTargetName);
        if (targetImpl == null) {
            throw new IllegalValueException("Target " + aTargetName + " doesn't exist");
        }
        ConfigElementData lunCed = new ConfigElementData(ClassID.LUN, ConfigOperation.CREATE);
        lunCed.setValue(ParameterCode.LU_LUN_NUMBER, (SrType)new SrGauge(aLun.longValue()));
        lunCed.setValue(ParameterCode.LU_PARENT, (SrType)targetImpl.getCommKeyClassId());
        lunCed.setValue(ParameterCode.LU_VOLUME_ID, (ElementData)volCed);
        return lunCed;
    }

    public ConfigElementData getVolumeAllocationCed(ClientConfigElementData aClientCed) throws IllegalValueException {
        BigInteger size = (BigInteger)aClientCed.getValue(ClientParameterCode.VOLUME_SPACE);
        ClassID classId = aClientCed.getClassId();
        String alias = (String)aClientCed.getValue(ClientParameterCode.VOLUME_ALIAS);
        String vswitchName = (String)aClientCed.getValue(ClientParameterCode.VSWITCH_NAME);
        PhysicalStorageDriveTypeConstant driveType = (PhysicalStorageDriveTypeConstant)aClientCed.getValue(ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE);
        PhysicalStorageRaidLevelConstant raidLevel = (PhysicalStorageRaidLevelConstant)aClientCed.getValue(ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL);
        AllocationPolicy policy = (AllocationPolicy)aClientCed.getValue(ClientParameterCode.VOLUME_ALLOCATION_POLICY);
        if (ClassID.GENERAL_VOLUME.equals((Object)classId)) {
            return this.getVolumeAllocationCed(alias, size, driveType, raidLevel, vswitchName, policy);
        }
        if (ClassID.SNAPSHOT_VOLUME.equals((Object)classId)) {
            ConfigElementData snapCed = new ConfigElementData(ClassID.SNAPSHOT_VOLUME, ConfigOperation.CREATE);
            snapCed.setValue(ParameterCode.VOLUME_ALIAS, (SrType)new SrString(alias));
            BigInteger sourceSize = this.getSourceSize(aClientCed);
            BigInteger snapMaxSize = size.multiply(new BigInteger("100"));
            if (snapMaxSize.compareTo(sourceSize) < 1) {
                policy = AllocationPolicy.addPolicy((AllocationPolicy)policy, (AllocationPolicy)AllocationPolicy.EXTRA_BLOCK);
            }
            if (!aClientCed.isNested(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE)) {
                GeneralSCSIDevice[] sourceVolumeDisks;
                CommKeyClassId sourceVolumeId = (CommKeyClassId)aClientCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
                VolumeNodeImpl sourceVolume = (VolumeNodeImpl)LogicMgrAOImpl.getInstance().getLogicObject(sourceVolumeId);
                ArrayList<CommKeyClassId> forbiddenDisks = new ArrayList<CommKeyClassId>();
                for (GeneralSCSIDevice sourceDisk : sourceVolumeDisks = sourceVolume.getDisksOfVolume()) {
                    try {
                        forbiddenDisks.add(sourceDisk.getCommKeyClassId());
                    }
                    catch (RemoteException e) {
                        theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Remote exception inside a server context."});
                    }
                }
                policy = AllocationPolicy.addPolicy((AllocationPolicy)policy, (AllocationPolicy)AllocationPolicy.FORBIDDEN_STORAGES, forbiddenDisks);
            } else {
                policy = AllocationPolicy.addPolicy((AllocationPolicy)policy, (AllocationPolicy)AllocationPolicy.DONT_REUSE_ALLOCATED);
            }
            StringBuilder childAliasPrefix = new StringBuilder(alias);
            childAliasPrefix.append(".resource");
            int childAliasIndex = this.getLastAliasIndex(childAliasPrefix.toString());
            if (childAliasIndex >= 0) {
                childAliasPrefix.append('.').append(childAliasIndex + 1);
            }
            ConfigElementData childCed = this.getVolumeAllocationCed(childAliasPrefix.toString(), size, driveType, raidLevel, vswitchName, policy);
            ConfigElementDataList snapChildren = new ConfigElementDataList(ConfigOperation.CREATE, new ConfigElementData[]{childCed});
            snapCed.setValue(ParameterCode.VOLUME_CHILDREN, snapChildren);
            Integer threshold = (Integer)aClientCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD);
            snapCed.setValue(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, (SrType)new SrInteger(threshold));
            if (!aClientCed.isNested(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE)) {
                CommKeyClassId sourceVolumeId = (CommKeyClassId)aClientCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
                snapCed.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (SrType)LogicMgrAOImpl.getInstance().getServerCKCI(sourceVolumeId));
            }
            SnapshotConfigFlagsConstant flags = (SnapshotConfigFlagsConstant)aClientCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS);
            snapCed.setValue(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, (SrType)flags);
            return snapCed;
        }
        throw new UnsupportedOperationException("Auto-allocation for volume type " + classId + "is unsupported");
    }

    private BigInteger getSourceSize(ClientConfigElementData aClientCed) {
        Util.validateInputNotNull((Object)aClientCed, (String)"ClientCED");
        if (!aClientCed.isNested(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE)) {
            CommKeyClassId sourceVolumeId = (CommKeyClassId)aClientCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
            VolumeNodeImpl sourceVol = (VolumeNodeImpl)LogicMgrAOImpl.getInstance().getLogicObject(sourceVolumeId);
            return sourceVol.getAccessibleSpace();
        }
        ClientConfigElementData sourceCed = (ClientConfigElementData)aClientCed.getValue(ClientParameterCode.SNAPSHOT_VOLUME_SOURCE);
        return (BigInteger)sourceCed.getValue(ClientParameterCode.VOLUME_SPACE);
    }

    private ConfigElementData getVolumeAllocationCed(String aVolumeAlias, BigInteger aSize, PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, String aExposedOnVswitchName, AllocationPolicy aPolicy) throws IllegalValueException {
        VSwitchImpl exposedOnVswitch = this.myCluster.getVSwitchByName(aExposedOnVswitchName);
        VolumeSimpleAllocation allocData = this.getPreferredVolumeAllocation(aSize, aDriveType, aRaidLevel, exposedOnVswitch, aPolicy);
        if (allocData == null) {
            throw new IllegalValueException(this.getAllocErrorMsg(aVolumeAlias, aSize));
        }
        Map<StorageAllocation, BigInteger> allocMap = allocData.getAllocation();
        if (allocMap == null) {
            throw new IllegalValueException(this.getAllocErrorMsg(aVolumeAlias, aSize));
        }
        int childIndex = this.getLastAliasIndex(aVolumeAlias);
        childIndex = childIndex < 0 ? 0 : childIndex;
        VolumeChildrenCounter childrenCounter = new VolumeChildrenCounter(childIndex);
        ConfigElementData volCed = this.createCedFromAllocationMap(allocMap, aVolumeAlias, childrenCounter);
        return volCed;
    }

    private void validateVolumeAllocationRequest(String aVolumeAlias, BigInteger aSize, String aExposedOnVswitchName, String aTargetName, Long aLun) throws IllegalValueException {
        Util.validateInputNotNull((Object)aVolumeAlias, (String)"Volume alias");
        Util.validateInputNotNull((Object)aTargetName, (String)"Target name");
        Util.validateInputNotNull((Object)aLun, (String)"LUN");
        if (aSize == null || aSize.equals(BigInteger.ZERO)) {
            throw new IllegalValueException(this.getSizeErrorMsg(aVolumeAlias, aSize));
        }
        VSwitchImpl exposedOnVswitch = this.myCluster.getVSwitchByName(aExposedOnVswitchName);
        if (exposedOnVswitch == null && aExposedOnVswitchName != null) {
            throw new IllegalValueException(this.getVSwitchErrorMsg(aExposedOnVswitchName));
        }
        VSwitchImpl targetVswitch = this.getExposedOnVSwitchOfTarget(aTargetName);
        if (exposedOnVswitch != null && targetVswitch != null && !exposedOnVswitch.equals(targetVswitch)) {
            throw new IllegalValueException(this.getVSwitchTargetErrorMsg(aExposedOnVswitchName, aTargetName, targetVswitch.getName()));
        }
        List<VSwitchImpl> vsOptions = this.getExposedOnVswitchOptions(exposedOnVswitch, null);
        if (vsOptions.isEmpty()) {
            throw new IllegalValueException("Could not find a " + ClassID.VSWITCH + " to expose volume " + aVolumeAlias + ". Check the connectivity of each " + ClassID.VSWITCH + " in the cluster.");
        }
    }

    private VSwitchImpl getExposedOnVSwitchOfTarget(String aTargetName) {
        String vsName;
        ISCSITargetImpl targetImpl;
        VSwitchImpl vswitchExposedOn = null;
        if (aTargetName != null && (targetImpl = this.myCluster.getTargetListMgr().getTargetByName(aTargetName)) != null && (vsName = targetImpl.getExposedOnVSwitch()) != null) {
            vswitchExposedOn = this.myCluster.getVSwitchByName(vsName);
        }
        return vswitchExposedOn;
    }

    private ConfigElementData getCedForMirrorAllocation(String aVolumeAlias, BigInteger aSize, PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, String aExposedOnVswitchName, String aTargetName, Long aLun, CommKeyClassId aTargetQosId) throws IllegalValueException {
        this.validateVolumeAllocationRequest(aVolumeAlias, aSize, aExposedOnVswitchName, aTargetName, aLun);
        VSwitchImpl exposedOnVswitch = this.myCluster.getVSwitchByName(aExposedOnVswitchName);
        VSwitchImpl targetVswitch = this.getExposedOnVSwitchOfTarget(aTargetName);
        VSwitchImpl vswitch = exposedOnVswitch != null ? exposedOnVswitch : targetVswitch;
        List<VolumeSimpleAllocation> mirrorLegs = this.getPreferredMirrorAllocation(aSize, aDriveType, aRaidLevel, vswitch);
        if (mirrorLegs == null) {
            throw new IllegalValueException(this.getAllocErrorMsg(aVolumeAlias, aSize));
        }
        ConfigElementDataList mirrChildren = new ConfigElementDataList(ConfigOperation.CREATE);
        String mirrChildPrefix = aVolumeAlias + ".mirr";
        int childCount = this.getLastAliasIndex(mirrChildPrefix);
        childCount = childCount < 0 ? 0 : childCount;
        for (VolumeSimpleAllocation disksGroup : mirrorLegs) {
            Map<StorageAllocation, BigInteger> allocMap = disksGroup.getAllocation();
            if (allocMap == null) {
                throw new IllegalValueException(this.getAllocErrorMsg(aVolumeAlias, aSize));
            }
            String mirrChildAlias = mirrChildPrefix + '.' + ++childCount;
            VolumeChildrenCounter childrenCounter = new VolumeChildrenCounter(this.getLastAliasIndex(mirrChildAlias));
            ConfigElementData childCed = this.createCedFromAllocationMap(allocMap, mirrChildAlias, childrenCounter);
            mirrChildren.add((ElementData)childCed);
        }
        ConfigElementData mirrCed = new ConfigElementData(ClassID.MIRROR_VOLUME, ConfigOperation.CREATE);
        mirrCed.setValue(ParameterCode.VOLUME_ALIAS, (SrType)new SrString(aVolumeAlias));
        mirrCed.setValue(ParameterCode.VOLUME_CHILDREN, mirrChildren);
        if (targetVswitch == null) {
            if (exposedOnVswitch == null) {
                exposedOnVswitch = mirrorLegs.get(0).getExposedOnVswitch();
            }
            return this.createExposeVolumeCed(mirrCed, aTargetName, exposedOnVswitch, aLun, aTargetQosId);
        }
        ISCSITargetImpl targetImpl = this.myCluster.getTargetListMgr().getTargetByName(aTargetName);
        if (targetImpl == null) {
            throw new IllegalValueException("Target " + aTargetName + " doesn't exist");
        }
        ConfigElementData lunCed = new ConfigElementData(ClassID.LUN, ConfigOperation.CREATE);
        lunCed.setValue(ParameterCode.LU_LUN_NUMBER, (SrType)new SrGauge(aLun.longValue()));
        lunCed.setValue(ParameterCode.LU_PARENT, (SrType)targetImpl.getCommKeyClassId());
        lunCed.setValue(ParameterCode.LU_VOLUME_ID, (ElementData)mirrCed);
        return lunCed;
    }

    private ConfigElementData createExposeVolumeCed(ConfigElementData aVolumeCed, String aTargetName, VSwitchImpl aExposedOn, long aLun, CommKeyClassId aTargetQosId) {
        Util.validateInputNotNull((Object)aVolumeCed, (String)"Volume CED");
        Util.validateInputNotNull((Object)aTargetName, (String)"Target Name");
        Util.validateInputNotNull((Object)aExposedOn, (String)"V-Switch");
        ConfigElementData lunCed = new ConfigElementData(ClassID.LUN, ConfigOperation.CREATE);
        lunCed.setValue(ParameterCode.LU_LUN_NUMBER, (SrType)new SrGauge(aLun));
        ConfigElementData createTargetCed = new ConfigElementData(ClassID.ISCSI_TARGET, ConfigOperation.CREATE);
        createTargetCed.setValue(ParameterCode.ISCSI_TARGET_ALIAS, (SrType)new SrString(aTargetName));
        createTargetCed.setValue(ParameterCode.ISCSI_TARGET_NAME, (SrType)new SrString(aTargetName));
        createTargetCed.setValue(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, (SrType)new SrString(aExposedOn.getName()));
        if (aTargetQosId != null) {
            ConfigElementData changeTargetCed = new ConfigElementData(ClassID.ISCSI_TARGET, ConfigOperation.CHANGE);
            changeTargetCed.setValue(ParameterCode.ELEMENT_ID, (ElementData)createTargetCed);
            changeTargetCed.setValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, (SrType)aTargetQosId);
            lunCed.setValue(ParameterCode.LU_PARENT, (ElementData)changeTargetCed);
        } else {
            lunCed.setValue(ParameterCode.LU_PARENT, (ElementData)createTargetCed);
        }
        lunCed.setValue(ParameterCode.LU_VOLUME_ID, (ElementData)aVolumeCed);
        return lunCed;
    }

    private String getSizeErrorMsg(String aVolumeAlias, BigInteger aSize) {
        StringBuilder sb = new StringBuilder();
        if (aSize == null) {
            sb.append("Allocation size for volume ");
            sb.append(aVolumeAlias);
            sb.append(" must be supplied");
        } else if (BigInteger.ZERO.equals(aSize)) {
            sb.append("Allocation size must be a non-zero value");
        }
        return sb.toString();
    }

    private String getVSwitchErrorMsg(String aVswitchName) {
        StringBuilder sb = new StringBuilder();
        sb.append("The ");
        sb.append(VSwitch.VSWITCH_DISPLAY_STRING);
        sb.append(' ');
        sb.append(aVswitchName);
        sb.append(" is not part of cluster ");
        sb.append(this.myCluster.getAlias());
        return sb.toString();
    }

    private String getVSwitchTargetErrorMsg(String aVswitchName, String aTargetName, String aTargetVswitchName) {
        StringBuilder sb = new StringBuilder();
        sb.append("The ");
        sb.append(VSwitch.VSWITCH_DISPLAY_STRING);
        sb.append(' ');
        sb.append(aVswitchName);
        sb.append(" is not compatible with the ");
        sb.append(ClassID.ISCSI_TARGET);
        sb.append(' ');
        sb.append(aTargetName);
        sb.append(" which is exposed on ");
        sb.append(VSwitch.VSWITCH_DISPLAY_STRING);
        sb.append(' ');
        sb.append(aTargetVswitchName);
        return sb.toString();
    }

    private String getAllocErrorMsg(String aVolumeAlias, BigInteger aSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("Allocation of size ");
        sb.append(aSize);
        sb.append(" for volume ");
        sb.append(aVolumeAlias);
        sb.append(" failed");
        return sb.toString();
    }

    private ConfigElementData createCedFromAllocationMap(Map<StorageAllocation, BigInteger> aAllocMap, String aVolumeAlias, VolumeChildrenCounter aChildrenCounter) throws IllegalValueException {
        this.myNewVolumeAliases.add(aVolumeAlias);
        if (aAllocMap.size() == 1) {
            StorageAllocation resource = aAllocMap.keySet().iterator().next();
            BigInteger allocSize = aAllocMap.get(resource);
            ConfigElementData ced = this.buildCedForAllocationOnDisk(aVolumeAlias, allocSize, resource);
            this.extractAndStoreNewVolumeNodesAliases(ced);
            return ced;
        }
        ConfigElementDataList volumeChildren = new ConfigElementDataList(ConfigOperation.CREATE);
        for (StorageAllocation resource : aAllocMap.keySet()) {
            aChildrenCounter.increment();
            String alias = aVolumeAlias + '.' + aChildrenCounter.getCount();
            BigInteger diskAllocSize = aAllocMap.get(resource);
            ConfigElementData child = this.buildCedForAllocationOnDisk(alias, diskAllocSize, resource);
            volumeChildren.add((ElementData)child);
        }
        ConfigElementData concatCed = new ConfigElementData(ClassID.CONCAT_VOLUME, ConfigOperation.CREATE);
        concatCed.setValue(ParameterCode.VOLUME_ALIAS, (SrType)new SrString(aVolumeAlias));
        concatCed.setValue(ParameterCode.VOLUME_CHILDREN, volumeChildren);
        this.extractAndStoreNewVolumeNodesAliases(concatCed);
        return concatCed;
    }

    private ConfigElementData buildCedForAllocationOnDisk(String aAlias, BigInteger aSize, StorageAllocation aStorageAlloc) throws IllegalValueException {
        DirectAccessDeviceImpl disk = aStorageAlloc.getDisk();
        if (disk.getSubDirectAccessDevices().size() == 0 && disk.getAllocationSpace().equals(aSize)) {
            ConfigElementData createAliasCed = new ConfigElementData(disk.getCommKeyClassId(), ConfigOperation.CREATE);
            return createAliasCed;
        }
        return disk.getVolumeAllocationCed(aAlias, aSize, aStorageAlloc.getStartAddress());
    }

    public void extractAndStoreNewVolumeNodesAliases(ConfigElementData aCed) {
        SrString alias = (SrString)aCed.getValue((ParameterCodes)ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        if (alias != null) {
            this.myNewVolumeAliases.add(alias.toString());
        }
        if ((alias = (SrString)aCed.getValue((ParameterCodes)ParameterCode.VOLUME_ALIAS)) != null) {
            this.myNewVolumeAliases.add(alias.toString());
        }
        if (ClassID.SUB_DIRECT_ACCESS_DEVICE.equals((Object)aCed.getClassId())) {
            return;
        }
        for (ParameterCode code : aCed.keySet()) {
            Object value = aCed.getValue((ParameterCodes)code);
            if (value instanceof ConfigElementData) {
                this.extractAndStoreNewVolumeNodesAliases((ConfigElementData)value);
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            ConfigElementDataList nestedList = (ConfigElementDataList)value;
            for (ElementData nestedCed : nestedList) {
                this.extractAndStoreNewVolumeNodesAliases((ConfigElementData)nestedCed);
            }
        }
    }

    private List<DirectAccessDeviceImpl> getAllAvailableDisks() {
        List<DirectAccessDeviceImpl> allDisks = this.myStoragePool.getAllDisks();
        StorageFilter filter = new StorageFilter(allDisks);
        return filter.getFilteredList((SrFilterSimpleRule<DirectAccessDeviceImpl>)new StorageFilter.AllocableDisksFilter());
    }

    private VolumeSimpleAllocation getPreferredVolumeAllocation(BigInteger aSize, PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, VSwitchImpl aRaidAttachedVswitch, AllocationPolicy aPolicy) {
        for (Integer blockSize : this.myPoolingTool.getBlockSizes(aPolicy)) {
            List<DirectAccessDeviceImpl> groupDisks = this.myPoolingTool.getAllDisks(aDriveType, aRaidLevel, blockSize, aPolicy);
            List<VSwitchImpl> exposedOnVswitchOptions = this.getExposedOnVswitchOptions(aRaidAttachedVswitch, groupDisks);
            for (VSwitchImpl exposedOnVswitch : exposedOnVswitchOptions) {
                Map<StorageAllocation, BigInteger> allocationMap = this.myPoolingTool.allocate(aDriveType, aRaidLevel, blockSize, aSize, exposedOnVswitch, exposedOnVswitch, aPolicy);
                if (allocationMap == null) continue;
                return new VolumeSimpleAllocation(allocationMap, exposedOnVswitch);
            }
        }
        return null;
    }

    public static <T extends Allocable, K> List<AllocableGroup> sort(List<T> aAllDisks, SortKeyProvider<K, T> aSorter) {
        SrSortingMap sortedMap = new SrSortingMap(aSorter);
        sortedMap.putAll(aAllDisks);
        List disksGroups = AllocableGroup.convertToGroupList((Collection)sortedMap.values());
        return disksGroups;
    }

    private List<VolumeSimpleAllocation> getPreferredMirrorAllocation(BigInteger aSize, PhysicalStorageDriveTypeConstant aDriveType, PhysicalStorageRaidLevelConstant aRaidLevel, VSwitchImpl aRaidAttachedVswitch) {
        for (Integer blockSize : this.myPoolingTool.getBlockSizes(null)) {
            List<DirectAccessDeviceImpl> groupDisks = this.myPoolingTool.getAllDisks(aDriveType, aRaidLevel, blockSize, null);
            List<VSwitchImpl> exposedOnVswitchOptions = this.getExposedOnVswitchOptions(aRaidAttachedVswitch, groupDisks);
            for (VSwitchImpl exposedOnVswitch : exposedOnVswitchOptions) {
                List<Map<StorageAllocation, BigInteger>> mirrAlloc = this.myPoolingTool.allocateMirror(aDriveType, aRaidLevel, blockSize, aSize, exposedOnVswitch);
                if (mirrAlloc == null) continue;
                ArrayList<VolumeSimpleAllocation> allocList = new ArrayList<VolumeSimpleAllocation>();
                for (Map<StorageAllocation, BigInteger> alloc : mirrAlloc) {
                    allocList.add(new VolumeSimpleAllocation(alloc, exposedOnVswitch));
                }
                return allocList;
            }
        }
        return null;
    }

    private List<VSwitchImpl> getExposedOnVswitchOptions(VSwitchImpl aRequestedRaidAttachedVswitch, List<DirectAccessDeviceImpl> aDisks) {
        if (aRequestedRaidAttachedVswitch != null) {
            if (aRequestedRaidAttachedVswitch.isConnected()) {
                return Collections.singletonList(aRequestedRaidAttachedVswitch);
            }
            return Collections.emptyList();
        }
        List<VSwitchImpl> connectedVswitches = Arrays.asList(this.myCluster.getConnectedVSwitches());
        VswitchRaidDisksComparator raidComparator = new VswitchRaidDisksComparator(aDisks);
        VswitchTargetCountComparator targetCountComparator = new VswitchTargetCountComparator();
        CompoundComparator comparator = new CompoundComparator(CompoundComparator.Mode.SIMPLE, new Comparator[]{raidComparator, targetCountComparator});
        Collections.sort(connectedVswitches, comparator);
        Collections.reverse(connectedVswitches);
        return connectedVswitches;
    }

    private List<String> getAllSystemAliases() {
        ArrayList<String> allAliasesList = new ArrayList<String>();
        for (GeneralSCSIDeviceImpl device : this.myStoragePool.getAll()) {
            allAliasesList.add(device.getAlias());
            if (!ClassID.DIRECT_ACCESS_DEVICE.equals((Object)device.getClassId())) continue;
            DirectAccessDeviceImpl disk = (DirectAccessDeviceImpl)device;
            for (SubDirectAccessDeviceImpl subdisk : disk.getSubDirectAccessDevices()) {
                allAliasesList.add(subdisk.getAlias());
            }
        }
        allAliasesList.addAll(this.myCluster.getVolumeMgr().getAllVolumesAliases());
        allAliasesList.addAll(this.myNewVolumeAliases);
        return allAliasesList;
    }

    public int getLastAliasIndex(String aAliasPrefix) {
        List<String> allAliasesList = this.getAllSystemAliases();
        return ResourceAliasUtil.getLastAliasIndex((String)aAliasPrefix, allAliasesList);
    }

    public String getRecommendedAlias(String aCandidateAlias) {
        List<String> allAliasesList = this.getAllSystemAliases();
        return ResourceAliasUtil.getRecommendedAlias((String)aCandidateAlias, allAliasesList);
    }

    public String getIndexedAlias(String aAliasPrefix) {
        List<String> allAliasesList = this.getAllSystemAliases();
        return ResourceAliasUtil.getRecommendedAlias((String)aAliasPrefix, allAliasesList);
    }

    public static VSwitchImpl getRaidAttachedVswitch(ClusterImpl aCluster, SrEntityNameFormat aEntityName) {
        for (AttachedRaidImpl raid : aCluster.getAttachedRaidsMgr().getAllAttachedRaids()) {
            SrEntityNameFormat raidWwn = raid.getWwn();
            if (raidWwn == null || !raidWwn.equals((Object)aEntityName)) continue;
            return raid.getActiveVswitch();
        }
        return null;
    }

    private class VswitchRaidDisksComparator
    implements Comparator<VSwitchImpl> {
        List<DirectAccessDeviceImpl> myDisks;
        StorageFilter myFilter;

        VswitchRaidDisksComparator(List<DirectAccessDeviceImpl> aDisks) {
            this.myDisks = aDisks;
            if (this.myDisks != null) {
                this.myFilter = new StorageFilter(aDisks);
            }
        }

        @Override
        public int compare(VSwitchImpl o1, VSwitchImpl o2) {
            ClusterImpl cluster2;
            if (this.myDisks == null) {
                return 0;
            }
            ClusterImpl cluster1 = o1.getCluster();
            if (!cluster1.equals(cluster2 = o2.getCluster())) {
                throw new IllegalStateException("V-Switch " + o1 + " and V-Switch " + o2 + " are not same cluster V-Switches");
            }
            if (cluster1.getAttachedRaidsMgr().getAllAttachedRaids().size() == 1) {
                return 0;
            }
            List<DirectAccessDeviceImpl> attachedDisks1 = this.myFilter.getAttachToVswitchDisks(o1, o1);
            BigInteger maxSize1 = AllocationUtil.getMaxSize(attachedDisks1);
            List<DirectAccessDeviceImpl> attachedDisks2 = this.myFilter.getAttachToVswitchDisks(o2, o2);
            BigInteger maxSize2 = AllocationUtil.getMaxSize(attachedDisks2);
            return maxSize1.compareTo(maxSize2);
        }
    }

    private class VswitchTargetCountComparator
    implements Comparator<VSwitchImpl> {
        private VswitchTargetCountComparator() {
        }

        @Override
        public int compare(VSwitchImpl o1, VSwitchImpl o2) {
            int count1 = StoragePoolMgr.this.myCluster.getTargetListMgr().getTargetsExposedOnVSwitch(o1.getName()).size();
            int count2 = StoragePoolMgr.this.myCluster.getTargetListMgr().getTargetsExposedOnVSwitch(o2.getName()).size();
            return count2 - count1;
        }
    }

    public static class VolumeChildrenCounter {
        int myChildrenCount = 0;

        VolumeChildrenCounter() {
        }

        VolumeChildrenCounter(int aCount) {
            this.myChildrenCount = aCount;
        }

        void increment() {
            ++this.myChildrenCount;
        }

        int getCount() {
            return this.myChildrenCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("VolumeChildrenCounter[");
            sb.append(this.myChildrenCount);
            sb.append(']');
            return sb.toString();
        }
    }

    private class VolumeSimpleAllocation {
        private Map<StorageAllocation, BigInteger> myAllocation;
        private VSwitchImpl myExposedOnVswitch;

        VolumeSimpleAllocation(Map<StorageAllocation, BigInteger> aAllocationMap, VSwitchImpl aExposedOnVswitch) {
            if (aExposedOnVswitch == null) {
                throw new IllegalArgumentException("Exposed-on V-Switch must be supplied");
            }
            this.myAllocation = aAllocationMap;
            this.myExposedOnVswitch = aExposedOnVswitch;
        }

        public Map<StorageAllocation, BigInteger> getAllocation() {
            return this.myAllocation;
        }

        public VSwitchImpl getExposedOnVswitch() {
            return this.myExposedOnVswitch;
        }
    }
}

