/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.SrTestUtils;
import com.sanrad.TestServerEventsListener;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.Target;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import junit.framework.TestCase;

public class StorageImplTest
extends TestCase {
    private LogicMgrAOImpl myLogicMgr;
    private Method getLogicObjectCkci;
    private Method getLogicObjectString;
    private static SrTestUtils myTestUtils;
    private Semaphore myTargetCreatedSem = null;
    private String myRetEvent;
    private static final Semaphore theLock;
    private static String EVENT_TYPE_CONTROL;
    private static String EVENT_TYPE_DATA;
    private ServerFacade myFacade = null;
    private static SrLogger theLogger;
    private static final String CONF_FILE;
    private Properties myTestProperties = new Properties();

    public StorageImplTest() {
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
        try {
            this.myTestProperties.load(new FileInputStream("test//config//StorageImplTest.properties"));
        }
        catch (FileNotFoundException exp) {
            exp.printStackTrace();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            theLock.acquire();
        }
        catch (InterruptedException exp) {
            StorageImplTest.fail((String)"Could not acquire the lock in order to run the test.");
        }
        while (!SystemRootImpl.getInstance().isDiscoverCompleted()) {
            Thread.sleep(500L);
        }
        this.myLogicMgr = LogicMgrAOImpl.getInstance();
        this.myTargetCreatedSem = new Semaphore(0);
        this.myFacade = LogicMgrAOImpl.getInstance().openSession((ServerEventsListener)new TestServerEventsListener(((Object)((Object)this)).hashCode()));
        this.myRetEvent = "";
    }

    protected void tearDown() throws Exception {
        this.myFacade.closeSession();
        theLock.release();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateISCSITarget() {
        Target thirdTarget;
        Target secTarget;
        block12: {
            Target origTarget = null;
            secTarget = null;
            thirdTarget = null;
            try {
                Site site1 = myTestUtils.createSite("testSite");
                StorageImplTest.assertNotNull((String)"The site needed for the test could not be created.", (Object)site1);
                ClusterImpl cluster1 = myTestUtils.createCluster("TestCluster1", site1);
                ClusterImpl cluster2 = myTestUtils.createCluster("TestCluster2", site1);
                StorageImplTest.assertNotNull((String)"The first cluster needed for the test could not be created.", (Object)cluster1);
                StorageImplTest.assertNotNull((String)"The second cluster needed for the test could not be created.", (Object)cluster2);
                String firstVsIp = this.myTestProperties.getProperty("FIRST_VS_IP");
                StorageImplTest.assertNotNull((String)"The FIRST_VS_IP property could not be read from the properties file.", (Object)firstVsIp);
                String secondVsIp = this.myTestProperties.getProperty("SECOND_VS_IP");
                StorageImplTest.assertNotNull((String)"The SECOND_VS_IP property could not be read from the properties file.", (Object)secondVsIp);
                StorageImplTest.assertNotNull((String)("Could not add the VS " + firstVsIp), (Object)myTestUtils.createDefaultVswitch(cluster1, firstVsIp));
                StorageImplTest.assertNotNull((String)("Could not add the VS " + secondVsIp), (Object)myTestUtils.createDefaultVswitch(cluster2, secondVsIp));
                origTarget = myTestUtils.createNewTarget(cluster1, "test");
                if (origTarget == null) {
                    StorageImplTest.fail((String)"Could not create the target needed for the test.");
                }
                try {
                    secTarget = myTestUtils.createNewTarget(cluster1, "newName", "test");
                }
                catch (AssertionError exp) {
                    StorageImplTest.assertTrue((boolean)true);
                }
                StorageImplTest.assertNull((String)"the validation allowed a target with the same alias to be created in the same cluster.", (Object)secTarget);
                try {
                    thirdTarget = myTestUtils.createNewTarget(cluster2, "test", "newAlias");
                }
                catch (AssertionError exp) {
                    StorageImplTest.assertTrue((boolean)true);
                }
                StorageImplTest.assertNull((String)"the validation allowed a target with the same name to be created in a different cluster.", (Object)thirdTarget);
                if (origTarget == null) break block12;
            }
            catch (Throwable throwable) {
                if (origTarget != null) {
                    myTestUtils.removeTarget(origTarget);
                }
                if (secTarget != null) {
                    myTestUtils.removeTarget(secTarget);
                }
                if (thirdTarget != null) {
                    myTestUtils.removeTarget(thirdTarget);
                }
                throw throwable;
            }
            myTestUtils.removeTarget(origTarget);
        }
        if (secTarget != null) {
            myTestUtils.removeTarget(secTarget);
        }
        if (thirdTarget != null) {
            myTestUtils.removeTarget(thirdTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        theLock = new Semaphore(1);
        EVENT_TYPE_CONTROL = "Control";
        EVENT_TYPE_DATA = "Data";
        theLogger = null;
        CONF_FILE = "config" + File.separator + "log.properties";
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(CONF_FILE);
            Properties logProps = new Properties();
            logProps.load(inFile);
            SrLogger.init((Properties)logProps);
            theLogger = SrLogger.getLogger();
        }
        catch (FileNotFoundException e1) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        catch (IOException e) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        finally {
            try {
                if (inFile != null) {
                    inFile.close();
                }
            }
            catch (IOException e) {
                System.err.println("Can not close the logger configuration file.");
            }
        }
    }
}

