/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.lu.LUCreateValidator;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.LUValidator;
import com.sanrad.nms.server.logic.lu.SCSILunImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralFiberChannelDeviceValidator;
import com.sanrad.nms.server.logic.physstorage.GeneralISCSIDeviceValidator;
import com.sanrad.nms.server.logic.physstorage.GeneralPSCSIDeviceValidator;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.LUIdentifierImpl;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.storage.StoragePool;
import com.sanrad.nms.server.logic.storage.StoragePoolMgr;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscoveryImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetCHAPCredentialsValidator;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalValidator;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetValidator;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetValidator;
import com.sanrad.nms.server.logic.target.RemoteTargetList;
import com.sanrad.nms.server.logic.target.SCSITargetPortImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.logic.target.TargetValidator;
import com.sanrad.nms.server.logic.volume.ConcatinationVolumeImpl;
import com.sanrad.nms.server.logic.volume.CubeVolumeImpl;
import com.sanrad.nms.server.logic.volume.CubeVolumeValidator;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.StripeVolumeImpl;
import com.sanrad.nms.server.logic.volume.TransparentVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeForest;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.volume.validators.ConcatinationVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.JournalVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.MirrorVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.SnapshotVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.StripeVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.TransparentVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StorageImpl
extends RemoteObjectImpl
implements Storage {
    private StoragePool storagePool = new StoragePool();
    private StoragePoolMgr myStoragePoolMgr;
    private VolumeForest volumeForest = new VolumeForest();
    private TargetList targetList = new TargetList();
    private RemoteTargetList m_remoteTargetList = new RemoteTargetList();
    private VolumeManager volumeManager;
    private ClusterImpl cluster;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static String s_childPartOfPair = Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.CANNOT_CREATE_VOLUME_BECAUSE_CHILD_IS_PART_OF_PAIR_ERR_MSG);

    public StorageImpl(ClusterImpl cluster) throws RemoteException {
        this.volumeManager = new VolumeManager(this.targetList, this.volumeForest, cluster);
        this.cluster = cluster;
        this.myStoragePoolMgr = new StoragePoolMgr(cluster, this.storagePool);
    }

    private ConfigElementData createConfigElementDataForVolume(String volAlias, Object children, ClassID volClassId, VSwitchImpl alreadyExistOnVSwitch, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        if (volAlias == null || "".equals(volAlias.trim())) {
            volAlias = CreateVolumeValidator.getDefaultAlias();
        }
        volAlias = volAlias.trim();
        StorageImpl storage = this.cluster.getStorage();
        CreateVolumeValidator validator = new CreateVolumeValidator(this.cluster, volClassId, volAlias, children, storage.getVolumeMgr());
        CommKeyClassId[] vSwitchesToSetData = null;
        if (alreadyExistOnVSwitch != null) {
            CommKeyClassId[] vSwitchToSet = new CommKeyClassId[]{this.cluster.getOtherVSwitch(alreadyExistOnVSwitch).getCommKeyClassId()};
            vSwitchesToSetData = validator.getLegalVSwitchesForOperation(vSwitchToSet);
        } else {
            vSwitchesToSetData = validator.getLegalVSwitchesForOperation(this.cluster.getVSwitches());
        }
        ConfigElementData element = new ConfigElementData(volClassId);
        Parameter alias = new Parameter(ParameterCode.VOLUME_ALIAS, (Object)new SrString(volAlias));
        element.addParameter(alias);
        CommKeyClassId[] childrenCommKeys = this.getChildrenDataByPosition(children, alreadyExistOnVSwitch);
        element.setValues(ParameterCode.VOLUME_CHILDREN, (SrType[])childrenCommKeys);
        element.setOperationInvoker(operationInvoker);
        element.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchesToSetData);
        return element;
    }

    @Override
    public SrFuture<Void> createConcatinationVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId) throws RemoteException, IllegalValueException {
        Vector<VolumeNodeImpl> children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        ConcatinationVolumeValidator validator = new ConcatinationVolumeValidator(this.cluster, volAlias, children, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(vol);
            if (pair == null) continue;
            Object[] msgArgs = new Object[]{volAlias, vol.getAlias(), pair};
            throw new IllegalValueException(MessageFormat.format(s_childPartOfPair, msgArgs));
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createConcatinationVolume(volAlias, children, null, null, null);
    }

    public SrFuture<Void> createConcatinationVolume(String volAlias, List<VolumeNodeImpl> children, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.CONCAT_VOLUME, alreadyExistOn, operationInvoker);
        return this.cluster.createElement(element, ClassID.CONCAT_VOLUME, volAlias, vSwitches);
    }

    public SrFuture<Void> createCubeVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId) throws RemoteException, IllegalValueException {
        Vector<VolumeNodeImpl> children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        CubeVolumeValidator validator = new CubeVolumeValidator(this.cluster, volAlias, children, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(vol);
            if (pair == null) continue;
            Object[] msgArgs = new Object[]{volAlias, vol.getAlias(), pair};
            throw new IllegalValueException(MessageFormat.format(s_childPartOfPair, msgArgs));
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createCubeVolume(volAlias, children, null, null, null);
    }

    public SrFuture<Void> createCubeVolume(String volAlias, List<VolumeNodeImpl> children, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.CUBE_VOLUME, alreadyExistOn, operationInvoker);
        return this.cluster.createElement(element, ClassID.CUBE_VOLUME, volAlias, vSwitches);
    }

    private Vector<VolumeNodeImpl> convertToVolumeChildrenVector(CommKeyClassId[] childrenCommKeyClassId) throws RemoteException {
        Vector<VolumeNodeImpl> children = new Vector<VolumeNodeImpl>();
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl child = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            children.addElement(child);
        }
        return children;
    }

    @Override
    public SrFuture<Void> createMirrorVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId) throws RemoteException, IllegalValueException {
        Vector<VolumeNodeImpl> children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        MirrorVolumeValidator validator = new MirrorVolumeValidator(this.cluster, volAlias, children, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(vol);
            if (pair == null) continue;
            Object[] msgArgs = new Object[]{volAlias, vol.getAlias(), pair};
            throw new IllegalValueException(MessageFormat.format(s_childPartOfPair, msgArgs));
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createMirrorVolume(volAlias, children, null, null, null);
    }

    public SrFuture<Void> createMirrorVolume(String volAlias, List<VolumeNodeImpl> children, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.MIRROR_VOLUME, alreadyExistOn, operationInvoker);
        return this.cluster.createElement(element, ClassID.MIRROR_VOLUME, volAlias, vSwitches);
    }

    @Override
    public SrFuture<Void> createStripeVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId, BigInteger stripeSize) throws RemoteException, IllegalValueException {
        Vector<VolumeNodeImpl> children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        StripeVolumeValidator validator = new StripeVolumeValidator(this.cluster, volAlias, children, stripeSize, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(vol);
            if (pair == null) continue;
            Object[] msgArgs = new Object[]{volAlias, vol.getAlias(), pair};
            throw new IllegalValueException(MessageFormat.format(s_childPartOfPair, msgArgs));
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createStripeVolume(volAlias, children, stripeSize, null, null, null);
    }

    public SrFuture<Void> createStripeVolume(String volAlias, List<VolumeNodeImpl> children, BigInteger stripeSize, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.STRIPE_VOLUME, alreadyExistOn, operationInvoker);
        int blockSize = children.get(0).getBlockSize();
        BigInteger stripeSizeBlocks = Util.bytesToBlocks((BigInteger)stripeSize, (int)blockSize);
        SrLunFormat stripeSizeValue = new SrLunFormat(stripeSizeBlocks);
        Parameter stripeSizeParam = new Parameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, (Object)stripeSizeValue);
        element.addParameter(stripeSizeParam);
        return this.cluster.createElement(element, ClassID.STRIPE_VOLUME, volAlias, vSwitches);
    }

    public SrFuture<Void> createJournalVolume(String volAlias, Integer threshold, List<VolumeNodeImpl> volumeNodeChildren, VSwitchImpl activeOnVswitch, VSwitchImpl inactiveVswitch, boolean shouldValidate) throws RemoteException, IllegalValueException {
        JournalVolumeValidator validator;
        final SrFuture retFuture = new SrFuture("Site.plannedFailover");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        boolean createActiveJournalOnly = activeOnVswitch != null && inactiveVswitch == null;
        boolean createInActiveJournalOnly = activeOnVswitch == null && inactiveVswitch != null;
        for (VolumeNodeImpl vol : volumeNodeChildren) {
            DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(vol);
            if (pair == null) continue;
            Object[] msgArgs = new Object[]{volAlias, vol.getAlias(), pair};
            throw new IllegalValueException(MessageFormat.format(s_childPartOfPair, msgArgs));
        }
        if (shouldValidate && !(validator = new JournalVolumeValidator(this.cluster, volAlias, threshold, volumeNodeChildren, true, activeOnVswitch, inactiveVswitch, this.volumeManager)).isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData primElement = this.createConfigElementDataForVolume(volAlias, volumeNodeChildren, ClassID.JOURNAL_VOLUME, null, null);
        primElement.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, (Object)new SrInteger(threshold)));
        if (activeOnVswitch != null) {
            CommKeyClassId[] vSwitchesToSet = new CommKeyClassId[]{activeOnVswitch.getCommKeyClassId()};
            primElement.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchesToSet);
            primElement.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY, (Object)JournalVolumeActivityConstants.ACTIVE));
            midFutures.add(this.cluster.createElement(primElement, ClassID.JOURNAL_VOLUME, volAlias));
        }
        if (inactiveVswitch != null) {
            ConfigElementData secElement = new ConfigElementData(primElement);
            CommKeyClassId[] vSwitchesToSet = new CommKeyClassId[]{inactiveVswitch.getCommKeyClassId()};
            secElement.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchesToSet);
            secElement.setValue(ParameterCode.JOURNAL_VOLUME_ACTIVITY, (SrType)JournalVolumeActivityConstants.INACTIVE);
            midFutures.add(this.cluster.createElement(secElement, ClassID.JOURNAL_VOLUME, volAlias));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> createJournalVolume(String volAlias, Integer threshold, Vector volumeNodeChilds, VSwitchImpl activeOnVswitch, VSwitchImpl inActiveOnVswitch) throws RemoteException, IllegalValueException {
        return this.createJournalVolume(volAlias, threshold, volumeNodeChilds, activeOnVswitch, inActiveOnVswitch, true);
    }

    @Override
    public SrFuture<Void> createJournalVolume(String volAlias, Integer threshold, CommKeyClassId volumeNodeChildId, CommKeyClassId activeOnVswitchId) throws RemoteException, IllegalValueException {
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[]{volumeNodeChildId};
        Vector<VolumeNodeImpl> children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        VSwitchImpl vswitch = (VSwitchImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(activeOnVswitchId);
        VSwitchImpl otherVswitch = this.getCluster().getOtherVSwitch(vswitch);
        return this.createJournalVolume(volAlias, threshold, children, vswitch, otherVswitch);
    }

    @Override
    public SrFuture<Void> createTransparentVolume(String volAlias, CommKeyClassId childCommKeyClassId) throws RemoteException, IllegalValueException {
        GeneralSCSIDeviceImpl child = (GeneralSCSIDeviceImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childCommKeyClassId);
        TransparentVolumeValidator validator = new TransparentVolumeValidator(this.cluster, volAlias, child, this.volumeManager);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createTransparentVolume(volAlias, child, null, null, null);
    }

    public SrFuture<Void> createTransparentVolume(String volAlias, GeneralSCSIDevice child, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, child, ClassID.TRANSPARENT_VOLUME, alreadyExistOn, operationInvoker);
        return this.cluster.createElement(element, ClassID.TRANSPARENT_VOLUME, volAlias, vSwitches);
    }

    @Override
    public SrFuture<Void> createSnapshotVolume(String volAlias, CommKeyClassId sourceVolumeCommKeyClassId, CommKeyClassId childCommKeyClassId, int threshold) throws RemoteException, IllegalValueException {
        return this.createSnapshotVolume(volAlias, sourceVolumeCommKeyClassId, childCommKeyClassId, threshold, SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE);
    }

    @Override
    public SrFuture<Void> createSnapshotVolume(String volAlias, CommKeyClassId sourceVolumeCommKeyClassId, CommKeyClassId childCommKeyClassId, int threshold, SnapshotActivateTypeConstants aSnapActType) throws RemoteException, IllegalValueException {
        VolumeNodeImpl child = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childCommKeyClassId);
        VolumeNodeImpl source = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(sourceVolumeCommKeyClassId);
        if (source.isDROfflineLocalCopy() || child.isDROfflineLocalCopy()) {
            throw new IllegalValueException("cannot create snapshot since source or child are local copy");
        }
        SnapshotVolumeValidator validator = new SnapshotVolumeValidator(this.cluster, source, volAlias, child, threshold, this.volumeManager);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createSnapshotVolume(volAlias, source, child, threshold, null, null, null, aSnapActType);
    }

    public SrFuture<Void> createSnapshotVolume(String volAlias, VolumeNode source, VolumeNode child, int threshold, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        return this.createSnapshotVolume(volAlias, source, child, threshold, vSwitches, alreadyExistOn, operationInvoker, SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE);
    }

    public SrFuture<Void> createSnapshotVolume(String volAlias, VolumeNode source, VolumeNode child, int threshold, List<VSwitchImpl> vSwitches, VSwitchImpl alreadyExistOn, CommKeyClassId operationInvoker, SnapshotActivateTypeConstants aSnapActType) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, child, ClassID.SNAPSHOT_VOLUME, alreadyExistOn, operationInvoker);
        CommKeyClassId[] vSwitchToSet = (CommKeyClassId[])element.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
        CommKeyClassId[] vSwitchSourceVolExistOn = this.getVSwitchesAllChildrenExistIn(source);
        Vector<CommKeyClassId> vses = new Vector<CommKeyClassId>();
        block0: for (int i = 0; i < vSwitchToSet.length; ++i) {
            for (int j = 0; j < vSwitchSourceVolExistOn.length; ++j) {
                if (!vSwitchToSet[i].equals((Object)vSwitchSourceVolExistOn[j])) continue;
                VSwitch vs = (VSwitch)SystemRootImpl.getInstance().getRefByStub(vSwitchToSet[i]);
                if (vSwitches != null && !vSwitches.contains(vs)) continue block0;
                vses.add(vSwitchToSet[i]);
                continue block0;
            }
        }
        if (vSwitchToSet.length != vses.size()) {
            vSwitchToSet = new CommKeyClassId[vses.size()];
            vses.toArray(vSwitchToSet);
            element.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchToSet);
        }
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (Object)source.getCommKeyClassId()));
        if (threshold > -1) {
            element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, (Object)new SrInteger(threshold)));
        }
        return this.cluster.createElement(element, ClassID.SNAPSHOT_VOLUME, volAlias, vSwitches);
    }

    @Override
    public SrFuture<Void> exposeVolume(int luNumber, CommKeyClassId volumeCommKeyClassId, CommKeyClassId targetCommKeyClassId) throws RemoteException, IllegalValueException {
        return this.exposeVolume(luNumber, volumeCommKeyClassId, targetCommKeyClassId, null);
    }

    @Override
    public SrFuture<Void> exposeVolume(int luNumber, CommKeyClassId volumeCommKeyClassId, CommKeyClassId targetCommKeyClassId, String serialNumber) throws RemoteException, IllegalValueException {
        TargetImpl target = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        VolumeNodeImpl volume = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(volumeCommKeyClassId);
        Vector<VSwitchImpl> vSwitches = new Vector<VSwitchImpl>(Arrays.asList(target.getConnectedVSwitches()));
        LUCreateValidator validator = new LUCreateValidator(this.cluster, luNumber, volume, target);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.exposeVolume(luNumber, volume, target, vSwitches, null, serialNumber);
    }

    public SrFuture<Void> exposeVolume(int luNumber, VolumeNodeImpl volume, TargetImpl target, List<VSwitchImpl> vSwitches, CommKeyClassId operationInvoker, String serialNumber) throws RemoteException, IllegalValueException {
        CommKeyClassId volCommKeyClassId;
        ConfigElementData element = new ConfigElementData(ClassID.LUN);
        element.addParameter(new Parameter(ParameterCode.LU_LUN_NUMBER, (Object)new SrGauge(luNumber)));
        if (serialNumber != null && !serialNumber.trim().equals("")) {
            element.addParameter(new Parameter(ParameterCode.LU_SERIAL_NUMBER, (Object)new SrString(serialNumber)));
        }
        VolumeNodeImpl volumeToExpose = volume;
        CommKeyClassId targetCommKeyClassId = new CommKeyClassId(target.getCommKeys(), target.getClassId());
        element.addParameter(new Parameter(ParameterCode.LU_PARENT, (Object)targetCommKeyClassId));
        LUValidator luValidator = new LUValidator(this.cluster, luNumber, volume, target);
        CommKeyClassId[] vSwitchesToSetData = luValidator.getLegalVSwitchesForOperation(vSwitches);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchesToSetData));
        if (volume instanceof GeneralSCSIDevice && !volume.getClassId().equals((Object)ClassID.DIRECT_ACCESS_DEVICE)) {
            if (volume.getParentVolume() == null) {
                if (!luValidator.isValid()) {
                    throw new IllegalValueException(luValidator.getErrorMsg());
                }
                ConfigElementData transElement = this.createConfigElementDataForVolume(volume.getAlias(), volume, ClassID.TRANSPARENT_VOLUME, null, operationInvoker);
                element.addParameter(new Parameter(ParameterCode.LU_VOLUME_ID, (Object)transElement));
                element.setOperationInvoker(operationInvoker);
                return this.cluster.createElement(element, "", null);
            }
            volumeToExpose = volume.getParentVolume();
        }
        if (ClassID.DIRECT_ACCESS_DEVICE.equals((Object)(volCommKeyClassId = new CommKeyClassId(volumeToExpose.getCommKeys(), volumeToExpose.getClassId())).getClassID())) {
            DirectAccessDeviceImpl disk = (DirectAccessDeviceImpl)volume;
            if (disk.isTotalSpaceSubdisk()) {
                element.addParameter(new Parameter(ParameterCode.LU_VOLUME_ID, (Object)disk.getTotalSpaceSubdisk().getCommKeyClassId()));
            } else {
                element.addParameter(new Parameter(ParameterCode.LU_VOLUME_ID, (Object)disk.getTotalSpaceSubdiskCed()));
            }
        } else {
            element.addParameter(new Parameter(ParameterCode.LU_VOLUME_ID, (Object)volCommKeyClassId));
        }
        element.setOperationInvoker(operationInvoker);
        return this.cluster.createElement(element, "Trying to expose " + volume.getAlias() + " with LUN " + luNumber + " on target " + target.getAlias(), null);
    }

    public SrFuture<Void> createGeneralPhysStorageDevice(PhysicalStorageTypeConstant type, String alias, SrEntityNameFormat targetName, int lun, PhysStorTransportTypeConstant transType, String serialNumber, List<VSwitchImpl> vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.DIRECT_ACCESS_DEVICE);
        element.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, (SrType)targetName);
        element.setValue(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, (SrType)transType);
        element.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, (SrType)GeneralSCSIDeviceImpl.parseSCSIDeviceLUN(lun));
        if (alias != null) {
            element.setValue(ParameterCode.PHYSICAL_STORAGE_ALIAS, (SrType)new SrString(alias));
        }
        if (serialNumber != null) {
            element.setValue(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, (SrType)new SrString(serialNumber));
        }
        return this.cluster.createElement(element, ClassID.DIRECT_ACCESS_DEVICE, alias, vSwitches);
    }

    private SrFuture<Void> createGeneralPhysStorageDevice(PhysicalStorageTypeConstant type, String alias, SrEntityNameFormat targetName, int lun, PhysStorTransportTypeConstant transType, String serialNumber) throws RemoteException, IllegalValueException {
        return this.createGeneralPhysStorageDevice(type, alias, targetName, lun, transType, serialNumber, null);
    }

    @Override
    public SrFuture<Void> createGeneralISCSIDevice(PhysicalStorageTypeConstant type, String alias, String targetName, int lun, String serialNumber) throws RemoteException, IllegalValueException {
        GeneralISCSIDeviceValidator validator = new GeneralISCSIDeviceValidator(this.cluster, this.targetList, type, alias, targetName, lun, serialNumber);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createGeneralPhysStorageDevice(type, alias, new SrEntityNameFormat(targetName), lun, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI, serialNumber);
    }

    @Override
    public SrFuture<Void> createGeneralParallelSCSIDevice(PhysicalStorageTypeConstant type, String alias, int port, int bus, int lun, String serialNumber) throws RemoteException, IllegalValueException {
        GeneralPSCSIDeviceValidator validator = new GeneralPSCSIDeviceValidator(this.cluster, this.targetList, type, alias, port, bus, lun, serialNumber);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        SrEntityNameFormat entityName = new SrEntityNameFormat(new byte[]{0, 0, 0, (byte)port, 0, 0, 0, (byte)bus});
        return this.createGeneralPhysStorageDevice(type, alias, entityName, lun, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI, serialNumber);
    }

    @Override
    public SrFuture<Void> createGeneralFiberChannelDevice(PhysicalStorageTypeConstant type, String alias, byte[] targetName, int lun, String serialNumber) throws RemoteException, IllegalValueException {
        GeneralFiberChannelDeviceValidator validator = new GeneralFiberChannelDeviceValidator(this.cluster, this.targetList, type, alias, targetName, lun, serialNumber);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        SrEntityNameFormat entityNameFormat = new SrEntityNameFormat(targetName);
        return this.createGeneralPhysStorageDevice(type, alias, entityNameFormat, lun, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP, serialNumber);
    }

    public SrFuture<Void> createISCSITarget(String name, String alias, Permission defaultAccess, String vSwitch, List<VSwitchImpl> vSwitches) throws IllegalValueException {
        if (alias.equals("")) {
            alias = TargetValidator.getDefaultAlias();
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_TARGET);
        Parameter targetName = new Parameter(ParameterCode.ISCSI_TARGET_NAME, (Object)new SrString(name));
        element.addParameter(targetName);
        Parameter targetAlias = new Parameter(ParameterCode.ISCSI_TARGET_ALIAS, (Object)new SrString(alias));
        element.addParameter(targetAlias);
        Parameter targetVSwitch = new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, (Object)new SrString(vSwitch));
        element.addParameter(targetVSwitch);
        if (defaultAccess != null) {
            Parameter defaultAccessParameter = new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS, (Object)new SrInteger(defaultAccess.intValue()));
            element.addParameter(defaultAccessParameter);
        }
        return this.cluster.createElement(element, ClassID.ISCSI_TARGET, alias, vSwitches);
    }

    @Override
    public SrFuture<Void> createISCSITarget(String name, String alias, String vSwitch) throws RemoteException, IllegalValueException {
        return this.createISCSITarget(name, alias, null, vSwitch);
    }

    @Override
    public SrFuture<Void> createISCSITarget(String name, String alias, Permission defaultAccess, String vSwitch) throws RemoteException, IllegalValueException {
        ISCSITargetValidator validator = new ISCSITargetValidator(this.getCluster(), name, alias, vSwitch);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createISCSITarget(name, alias, defaultAccess, vSwitch, null);
    }

    public void createISCSIRemoteTarget(CommKeyClassId remoteTargetId, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags) throws RemoteException, IllegalValueException {
        ISCSIRemoteTargetImpl remotetarget = (ISCSIRemoteTargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(remoteTargetId);
        if (remotetarget == null) {
            throw new IllegalValueException("A remote target must be specified");
        }
        ISCSIRemoteTargetPortalValidator remoteTargetPortalValidator = new ISCSIRemoteTargetPortalValidator(remotetarget, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, null);
        if (!remoteTargetPortalValidator.isValid()) {
            throw new IllegalValueException(remoteTargetPortalValidator.getErrorMsg());
        }
    }

    @Override
    public SrFuture<Void> createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias) throws RemoteException, IllegalValueException {
        return this.createISCSIRemoteTarget(remoteTargetName, remoteTargetAlias, null, null, null, null, null, true);
    }

    public SrFuture<Void> createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags) throws RemoteException, IllegalValueException {
        return this.createISCSIRemoteTarget(remoteTargetName, remoteTargetAlias, remoteTargetCHAPUserName, remoteTargetCHAPPassword, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, true);
    }

    public SrFuture<Void> createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags, boolean validateTargetValues) throws RemoteException, IllegalValueException {
        VSwitch[] array = this.getCluster().getConnectedVSwitches();
        return this.createISCSIRemoteTarget(remoteTargetName, remoteTargetAlias, null, remoteTargetCHAPUserName, remoteTargetCHAPPassword, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, validateTargetValues, array);
    }

    public SrFuture<Void> createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias, String remoteTargetIdentityAlias, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags, boolean validateTargetValues, VSwitch[] vswitches) throws RemoteException, IllegalValueException {
        ISCSIRemoteTargetPortalValidator remoteTargetPortalValidator;
        ISCSIRemoteTargetCHAPCredentialsValidator remoteTargetPortalCHAPCredentialsValidator;
        ISCSIRemoteTargetValidator remoteTargetValidator;
        if (remoteTargetAlias.equals("")) {
            remoteTargetAlias = remoteTargetName;
        }
        if (validateTargetValues && !(remoteTargetValidator = new ISCSIRemoteTargetValidator(this.getCluster(), remoteTargetName, remoteTargetAlias, this.targetList, this.m_remoteTargetList)).isValid()) {
            throw new IllegalValueException(remoteTargetValidator.getErrorMsg());
        }
        if (validateTargetValues && (remoteTargetCHAPUserName != null || remoteTargetCHAPPassword != null) && !(remoteTargetPortalCHAPCredentialsValidator = new ISCSIRemoteTargetCHAPCredentialsValidator(remoteTargetCHAPPassword)).isValid()) {
            throw new IllegalValueException(remoteTargetPortalCHAPCredentialsValidator.getErrorMsg());
        }
        if (validateTargetValues && remoteTargetPortalIPs != null && !(remoteTargetPortalValidator = new ISCSIRemoteTargetPortalValidator(null, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, null)).isValid()) {
            throw new IllegalValueException(remoteTargetPortalValidator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_TARGET);
        CommKeyClassId[] vSwitchestoSet = new CommKeyClassId[vswitches.length];
        for (int index = 0; index < vswitches.length; ++index) {
            vSwitchestoSet[index] = vswitches[index].getCommKeyClassId();
        }
        element.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchestoSet);
        Parameter rTargetConnectedInitiator = new Parameter(ParameterCode.ISCSI_INITIATOR_ID, (Object)this.getLocalInitiatorsInCluster(vswitches));
        element.addParameter(rTargetConnectedInitiator);
        Parameter rTargetName = new Parameter(ParameterCode.DISCOVERED_TARGET_NAME, (Object)new SrString(remoteTargetName));
        element.addParameter(rTargetName);
        Parameter rTargetAlias = new Parameter(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, (Object)new SrString(remoteTargetAlias));
        element.addParameter(rTargetAlias);
        if (remoteTargetIdentityAlias != null) {
            Parameter rTargetIdentityAlias = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_IDENTITY_ALIAS, (Object)new SrString(remoteTargetIdentityAlias));
            element.addParameter(rTargetIdentityAlias);
        }
        if (remoteTargetCHAPUserName != null) {
            Parameter rTargetCHAPUserName = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, (Object)new SrString(remoteTargetCHAPUserName));
            element.addParameter(rTargetCHAPUserName);
        }
        if (remoteTargetCHAPPassword != null) {
            Parameter rTargetCHAPPassword = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD, (Object)new SrString(remoteTargetCHAPPassword));
            element.addParameter(rTargetCHAPPassword);
        }
        if (remoteTargetPortalIPs != null) {
            SrString[] arrayOfrTargetPortalIPs = new SrString[remoteTargetPortalIPs.length];
            SrString.copyStringArrays((String[])remoteTargetPortalIPs, (SrString[])arrayOfrTargetPortalIPs);
            Parameter rTargetPortalIPs = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, (Object)arrayOfrTargetPortalIPs);
            element.addParameter(rTargetPortalIPs);
            SrGauge[] arrayOfrTargetPortalPorts = new SrGauge[remoteTargetPortalPorts.length];
            SrGauge.copyIntegerArrays((BigInteger[])remoteTargetPortalPorts, (SrGauge[])arrayOfrTargetPortalPorts);
            Parameter rTargetPortalPorts = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, (Object)arrayOfrTargetPortalPorts);
            element.addParameter(rTargetPortalPorts);
            SrInteger[] arrayOfrTargetPortalGroupTags = new SrInteger[remoteTargetPortalGroupTags.length];
            SrInteger.copyIntegerArrays((Integer[])remoteTargetPortalGroupTags, (SrInteger[])arrayOfrTargetPortalGroupTags);
            Parameter rTargetPortalGroupTags = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, (Object)arrayOfrTargetPortalGroupTags);
            element.addParameter(rTargetPortalGroupTags);
        }
        return this.cluster.createElement(element, ClassID.ISCSI_REMOTE_TARGET, remoteTargetName);
    }

    private CommKeyClassId[] getLocalInitiatorsInCluster(VSwitch[] vswitches) throws RemoteException {
        ArrayList<CommKeyClassId> initiators = new ArrayList<CommKeyClassId>();
        for (int index = 0; index < vswitches.length; ++index) {
            VSwitch vswitch = vswitches[index];
            ISCSIInitiator[] vswitchInitiators = vswitch.getISCSIInitiators();
            CommKeyClassId iscsiInitiatorId = vswitchInitiators[0].getCommKeyClassId();
            CommKeyClassId scsiInitiatorId = this.getCluster().getSCSIId(iscsiInitiatorId);
            initiators.add(scsiInitiatorId);
        }
        CommKeyClassId[] initiatorsIds = new CommKeyClassId[initiators.size()];
        for (int index = 0; index < initiators.size(); ++index) {
            initiatorsIds[index] = (CommKeyClassId)initiators.get(index);
        }
        return initiatorsIds;
    }

    public Vector<ISCSITargetImpl> getTargetList() {
        return this.getTargetListMgr().getAll();
    }

    public TargetList getTargetListMgr() {
        return this.targetList;
    }

    public ISCSIRemoteTarget[] getRemoteTargetList() {
        return this.getRemoteTargetListMgr().getAll();
    }

    public RemoteTargetList getRemoteTargetListMgr() {
        return this.m_remoteTargetList;
    }

    public VolumeManager getVolumeMgr() {
        return this.volumeManager;
    }

    @Override
    public List getStorageDevices() {
        return this.storagePool.getAll();
    }

    public StoragePool getStoragePool() {
        return this.storagePool;
    }

    public StoragePoolMgr getStoragePoolMgr() {
        return this.myStoragePoolMgr;
    }

    @Override
    public Vector getVolumeTrees() throws RemoteException {
        Vector<VolumeTreeImpl> volumeTrees = this.targetList.getVolumeTrees();
        Vector<VolumeTreeImpl> forestTrees = this.volumeForest.getAll();
        volumeTrees.addAll(forestTrees);
        return volumeTrees;
    }

    @Override
    public Vector<VolumeTreeImpl> getVolumeForest() {
        return this.volumeForest.getAll();
    }

    public List<? extends VolumeNodeImpl> getInteranlVolumesByType(ClassID volClassId) {
        if (volClassId.equals((Object)ClassID.SUB_DIRECT_ACCESS_DEVICE) || volClassId.equals((Object)ClassID.DIRECT_ACCESS_DEVICE)) {
            List<GeneralSCSIDeviceImpl> devices = this.getStoragePool().getAll();
            if (volClassId.equals((Object)ClassID.DIRECT_ACCESS_DEVICE)) {
                return devices;
            }
            Vector<SubDirectAccessDeviceImpl> subdisks = new Vector<SubDirectAccessDeviceImpl>();
            for (int i = 0; i < devices.size(); ++i) {
                DirectAccessDeviceImpl device = (DirectAccessDeviceImpl)devices.get(i);
                subdisks.addAll(device.getSubDirectAccessDevices());
            }
            return subdisks;
        }
        Vector<VolumeTreeImpl> volumesInCluster = this.getVolumeForest();
        Vector<VolumeNodeImpl> voluemsByType = new Vector<VolumeNodeImpl>();
        for (int index = 0; index < volumesInCluster.size(); ++index) {
            VolumeTreeImpl volume = volumesInCluster.elementAt(index);
            if (!volume.getTreeRoot().getClassId().equals((Object)volClassId)) continue;
            voluemsByType.add(volume.getTreeRoot());
        }
        return voluemsByType;
    }

    private VolumeImpl getVolumeIfAlreadyKnownByCluster(ClassID type, ConfigElementData aCED) throws RemoteException {
        CommKeyClassId[] children = (CommKeyClassId[])aCED.getValue((ParameterCodes)ParameterCode.VOLUME_CHILDREN);
        if (children != null && children.length > 0) {
            VolumeImpl candidateVolume;
            VolumeNodeImpl child = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(children[0]);
            if (child != null && (candidateVolume = child.getParentVolume()) != null && candidateVolume.getClassId().equals((Object)type)) {
                Vector<Object> childrenVec = new Vector<Object>(children.length);
                for (int i = 0; i < children.length; ++i) {
                    Object childImpl = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(children[i]);
                    childrenVec.addElement(childImpl);
                }
                List<VolumeNodeImpl> candidateCildren = candidateVolume.getChildren();
                if (!candidateCildren.containsAll(childrenVec) && !childrenVec.containsAll(candidateCildren)) {
                    return null;
                }
                return candidateVolume;
            }
        } else {
            Object alias = aCED.getValue((ParameterCodes)ParameterCode.VOLUME_ALIAS);
            Object vSwitch = aCED.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"No children for volume ", alias, " at ", ClassID.VSWITCH, " ", vSwitch, " in StorageImpl::getVolumeIfAlreadyKnownByCluster()"});
        }
        return null;
    }

    private VolumeImpl checkForVolumeExistance(ClassID type, ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch {
        VolumeImpl volume = this.getVolumeIfAlreadyKnownByCluster(type, aCED);
        if (volume != null) {
            VSwitchImpl[] vSwitches = volume.getConnectedVSwitches();
            VSwitchImpl vSwitch = this.cluster.getVSwitch(aCED);
            boolean sameVSwitch = false;
            for (int i = 0; i < vSwitches.length; ++i) {
                if (!vSwitches[i].equals(vSwitch)) continue;
                sameVSwitch = true;
                if (!CommKeyUtil.isEqual((CommKey[])commKeys, (CommKey[])volume.getCommKeys())) continue;
                throw new AlreadyKnownByVSwitch(volume);
            }
            if (!sameVSwitch) {
                throw new AlreadyKnownByVSwitch(volume);
            }
        }
        return volume;
    }

    private VolumeImpl newVolume(VolumeImpl aVolume, CommKey[] aCommKeys, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        aVolume.changeParameterList(aCED);
        aVolume.setLeafsFree(false);
        this.volumeForest.addVolume(aVolume);
        return aVolume;
    }

    public ConcatinationVolumeImpl newConcatinationVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.CONCAT_VOLUME, aCED, commKeys);
        ConcatinationVolumeImpl volume = new ConcatinationVolumeImpl(this.cluster, aCED);
        ConcatinationVolumeImpl newVolume = (ConcatinationVolumeImpl)this.newVolume(volume, commKeys, aCED);
        newVolume.updateExpandAndRetractStatus();
        return newVolume;
    }

    public CubeVolumeImpl newCubeVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.CUBE_VOLUME, aCED, commKeys);
        CubeVolumeImpl volume = new CubeVolumeImpl(this.cluster, aCED);
        CubeVolumeImpl newVolume = (CubeVolumeImpl)this.newVolume(volume, commKeys, aCED);
        newVolume.updateExpandAndRetractStatus();
        return newVolume;
    }

    public MirrorVolumeImpl newMirrorVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.MIRROR_VOLUME, aCED, commKeys);
        MirrorVolumeImpl volume = new MirrorVolumeImpl(this.cluster, aCED);
        return (MirrorVolumeImpl)this.newVolume(volume, commKeys, aCED);
    }

    public SnapshotVolumeImpl newSnapshotVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.SNAPSHOT_VOLUME, aCED, commKeys);
        SnapshotVolumeImpl volume = new SnapshotVolumeImpl(this.cluster, aCED);
        SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)this.newVolume(volume, commKeys, aCED);
        return snapshotVolume;
    }

    public JournalVolumeImpl newJournalVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.JOURNAL_VOLUME, aCED, commKeys);
        JournalVolumeImpl volume = new JournalVolumeImpl(this.cluster, aCED);
        JournalVolumeImpl journalVolume = (JournalVolumeImpl)this.newVolume(volume, commKeys, aCED);
        return journalVolume;
    }

    public StripeVolumeImpl newStripeVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.STRIPE_VOLUME, aCED, commKeys);
        StripeVolumeImpl volume = new StripeVolumeImpl(this.cluster, aCED);
        return (StripeVolumeImpl)this.newVolume(volume, commKeys, aCED);
    }

    public TransparentVolumeImpl newTransparentVolume(ConfigElementData aCED, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        this.checkForVolumeExistance(ClassID.TRANSPARENT_VOLUME, aCED, commKeys);
        TransparentVolumeImpl volume = new TransparentVolumeImpl(this.cluster, aCED);
        return (TransparentVolumeImpl)this.newVolume(volume, commKeys, aCED);
    }

    public ISCSITargetImpl newISCSITarget(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        String name = (String)((SrString)aCED.getValue((ParameterCodes)ParameterCode.ISCSI_TARGET_NAME)).value();
        ISCSITargetImpl target = this.targetList.getTargetByName(name);
        if (target != null) {
            throw new AlreadyKnownByVSwitch(target);
        }
        target = new ISCSITargetImpl(this.cluster, aCED);
        target.changeParameterList(aCED);
        this.targetList.addTarget(target);
        this.getCluster().getPolicyManager().newTarget(target);
        return target;
    }

    public ISCSIRemoteTargetImpl newISCSIRemoteTarget(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId fromVSwitch = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
        VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(fromVSwitch);
        ISCSIInitiator[] iscsiInitiators = vswitch.getISCSIInitiators();
        boolean isISCSIInitiatorExisted = iscsiInitiators != null && iscsiInitiators.length > 0 && iscsiInitiators[0] != null;
        SrString remoteTargetName = (SrString)aCED.getValue((ParameterCodes)ParameterCode.DISCOVERED_TARGET_NAME);
        String name = (String)remoteTargetName.value();
        ISCSIRemoteTargetImpl remoteTarget = this.getRemoteTargetListMgr().getRemoteTargetByName(name);
        if (remoteTarget != null) {
            if (isISCSIInitiatorExisted) {
                ((ISCSIInitiatorImpl)iscsiInitiators[0]).addRemoteTarget(remoteTarget);
            }
            throw new AlreadyKnownByVSwitch(remoteTarget);
        }
        remoteTarget = new ISCSIRemoteTargetImpl(this.cluster, aCED);
        remoteTarget.changeParameterList(aCED);
        ISCSITargetImpl localTarget = remoteTarget.getConfiguredAsLocalTargetOnSameCluster();
        if (localTarget != null) {
            theLogger.error(SrLogCategories.LEGACY, new Object[]{">>>> Cluster ", this.getCluster().getAlias(), " : Remote target ", remoteTarget.getName(), " is configured as a local target in the cluster ", this.cluster.getAlias()});
        }
        this.m_remoteTargetList.addRemoteTarget(remoteTarget);
        if (isISCSIInitiatorExisted) {
            ((ISCSIInitiatorImpl)iscsiInitiators[0]).addRemoteTarget(remoteTarget);
        }
        return remoteTarget;
    }

    public ISCSIRemoteTargetPortalImpl newISCSIRemoteTargetPortal(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        String ip = ((SrIpAddress)aCED.getValue((ParameterCodes)ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP)).toDisplayString();
        int port = ((BigInteger)((SrGauge)aCED.getValue((ParameterCodes)ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT)).value()).intValue();
        int groupTag = (Integer)((SrInteger)aCED.getValue((ParameterCodes)ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG)).value();
        CommKeyClassId remoteTargetParent = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.ISCSI_REMOTE_TARGET_ID);
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(remoteTargetParent);
        ISCSIRemoteTargetPortalImpl remoteTargetPortal = null;
        if (remoteTarget != null) {
            remoteTargetPortal = remoteTarget.getPortalTableRow(ip, port, groupTag);
            if (remoteTargetPortal != null) {
                throw new AlreadyKnownByVSwitch(remoteTargetPortal);
            }
            remoteTargetPortal = new ISCSIRemoteTargetPortalImpl(this.cluster, aCED);
            remoteTargetPortal.changeParameterList(aCED);
            remoteTarget.addPortal(remoteTargetPortal);
            return remoteTargetPortal;
        }
        return remoteTargetPortal;
    }

    public ISCSIRemotePortalDiscoveryImpl newISCSIRemotePortalDiscovery(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        String ip = ((SrIpAddress)aCED.getValue((ParameterCodes)ParameterCode.REMOTE_PORTAL_DISC_ADDRESS)).toDisplayString();
        int port = (Integer)((SrInteger)aCED.getValue((ParameterCodes)ParameterCode.REMOTE_PORTAL_DISC_PORT)).value();
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
        VSwitchImpl vswitch = (VSwitchImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        ISCSIInitiator[] iscsiInitiators = vswitch.getISCSIInitiators();
        ISCSIRemotePortalDiscoveryImpl remoteDiscoveryPortal = null;
        if (iscsiInitiators != null && iscsiInitiators.length > 0) {
            ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)iscsiInitiators[0];
            remoteDiscoveryPortal = initiator.getRemoteDiscoveryPortal(ip, port);
            VSwitchImpl otherVSwitchInCluster = this.getCluster().getOtherVSwitch(vswitch);
            if (otherVSwitchInCluster != null) {
                ISCSIInitiator[] iscsiInitiatorsInOtherVSwitch = otherVSwitchInCluster.getISCSIInitiators();
                ISCSIRemotePortalDiscoveryImpl remoteDiscoveryPortalInOtherVSwitch = null;
                if (iscsiInitiatorsInOtherVSwitch != null && iscsiInitiatorsInOtherVSwitch.length > 0) {
                    ISCSIInitiatorImpl initiatorInOtherVSwitch = (ISCSIInitiatorImpl)iscsiInitiatorsInOtherVSwitch[0];
                    remoteDiscoveryPortalInOtherVSwitch = initiatorInOtherVSwitch.getRemoteDiscoveryPortal(ip, port);
                    if (remoteDiscoveryPortal == null && remoteDiscoveryPortalInOtherVSwitch == null) {
                        remoteDiscoveryPortal = new ISCSIRemotePortalDiscoveryImpl(this.cluster, aCED);
                        remoteDiscoveryPortal.setOnInitProcess(true);
                        remoteDiscoveryPortal.changeParameterList(aCED);
                        remoteDiscoveryPortal.setOnInitProcess(false);
                        initiator.addRemoteDiscoveryPortal(remoteDiscoveryPortal);
                    } else if (remoteDiscoveryPortal == null && remoteDiscoveryPortalInOtherVSwitch != null) {
                        initiator.addRemoteDiscoveryPortal(remoteDiscoveryPortalInOtherVSwitch);
                        throw new AlreadyKnownByVSwitch(remoteDiscoveryPortalInOtherVSwitch);
                    }
                }
            } else if (remoteDiscoveryPortal == null) {
                remoteDiscoveryPortal = new ISCSIRemotePortalDiscoveryImpl(this.cluster, aCED);
                remoteDiscoveryPortal.setOnInitProcess(true);
                remoteDiscoveryPortal.changeParameterList(aCED);
                remoteDiscoveryPortal.setOnInitProcess(false);
                initiator.addRemoteDiscoveryPortal(remoteDiscoveryPortal);
            }
        }
        return remoteDiscoveryPortal;
    }

    public SCSITargetPortImpl newSCSITargetPort(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        SCSITargetPortImpl targetPort = new SCSITargetPortImpl(this.cluster, aCED);
        targetPort.changeParameterList(aCED);
        ISCSITargetImpl target = targetPort.getTarget();
        if (target != null) {
            target.addSCSIPort(targetPort);
        }
        return targetPort;
    }

    public LUIdentifierImpl newLUIdentifier(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        LUIdentifierImpl luId = new LUIdentifierImpl(this.cluster, aCED);
        luId.changeParameterList(aCED);
        return luId;
    }

    public LUImpl newLU(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId parent = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.LU_PARENT);
        TargetImpl target = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        LUImpl lu = null;
        if (target != null) {
            SrGauge lun = (SrGauge)aCED.getValue((ParameterCodes)ParameterCode.LU_LUN_NUMBER);
            int intValOfLu = Integer.parseInt(lun.longVal().toString());
            lu = target.getLU(intValOfLu);
        }
        if (lu != null) {
            VolumeNodeImpl volume = lu.getVolumeChild();
            CommKeyClassId volumeCommKeyClassId = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.LU_VOLUME_ID);
            VolumeNode newVolume = (VolumeNode)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(volumeCommKeyClassId);
            if (newVolume.equals(volume)) {
                throw new AlreadyKnownByVSwitch(lu);
            }
        }
        lu = new LUImpl(this.cluster, aCED);
        lu.changeParameterList(aCED);
        this.targetList.addLU(lu);
        return lu;
    }

    public SCSILunImpl newSCSILun(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId parentTargetKey = this.cluster.getISCSIId((CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.SCSI_DEVICE_ID));
        TargetImpl parent = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parentTargetKey);
        SCSILunImpl scsiLun = null;
        if (parent != null) {
            LUImpl lu = parent.getLU(((SrScsiLUNFormat)aCED.getValue((ParameterCodes)ParameterCode.SCSI_LUN_LU_NUMBER)).toInt());
            if (lu != null) {
                scsiLun = lu.getScsiLun();
                if (scsiLun != null) {
                    throw new AlreadyKnownByVSwitch(scsiLun);
                }
                scsiLun = new SCSILunImpl(this.cluster, lu, aCED);
                lu.setScsiLun(scsiLun);
                scsiLun.changeParameterList(aCED);
            } else {
                theLogger.error(SrLogCategories.LEGACY, new Object[]{"Trying to create a SCSILun failed due to inconsistency: couldn't find matching LU in the Target parent"});
            }
        } else {
            theLogger.error(SrLogCategories.LEGACY, new Object[]{"Trying to create a SCSILun failed due to inconsistency: couldn't find Target parent"});
        }
        return scsiLun;
    }

    public SubDirectAccessDeviceImpl newSubDirectAccessDevice(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        CommKeyClassId parent = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        DirectAccessDeviceImpl directAccessDevice = (DirectAccessDeviceImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        SubDirectAccessDeviceImpl subStorageDevice = null;
        if (directAccessDevice != null) {
            BigInteger endAddr = (BigInteger)((SrLunFormat)aCED.getValue((ParameterCodes)ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR)).value();
            subStorageDevice = directAccessDevice.getSubDirectAccessDevice(endAddr);
        }
        if (subStorageDevice != null) {
            throw new AlreadyKnownByVSwitch(subStorageDevice);
        }
        subStorageDevice = new SubDirectAccessDeviceImpl(this.cluster, aCED);
        subStorageDevice.changeParameterList(aCED);
        return subStorageDevice;
    }

    public SequentialAccessDeviceImpl newSequentialAccessDevice(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        SequentialAccessDeviceImpl storageDevice = (SequentialAccessDeviceImpl)this.storagePool.getSCSIDeviceParameterList(this.getCluster(), aCED);
        if (storageDevice != null) {
            throw new AlreadyKnownByVSwitch(storageDevice);
        }
        storageDevice = new SequentialAccessDeviceImpl(this.cluster, aCED);
        storageDevice.changeParameterList(aCED);
        this.storagePool.addStorage(storageDevice);
        return storageDevice;
    }

    public GeneralSCSIDeviceImpl newGeneralSCSIDevice(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        GeneralSCSIDeviceImpl storageDevice = this.storagePool.getSCSIDeviceParameterList(this.getCluster(), aCED);
        if (storageDevice != null) {
            throw new AlreadyKnownByVSwitch(storageDevice);
        }
        storageDevice = new GeneralSCSIDeviceImpl(this.cluster, aCED);
        storageDevice.changeParameterList(aCED);
        this.storagePool.addStorage(storageDevice);
        return storageDevice;
    }

    public DirectAccessDeviceImpl newDirectAccessDevice(ConfigElementData aCED) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException, InvalidElementException {
        DirectAccessDeviceImpl storageDevice = (DirectAccessDeviceImpl)this.storagePool.getSCSIDeviceParameterList(this.getCluster(), aCED);
        if (storageDevice != null) {
            throw new AlreadyKnownByVSwitch(storageDevice);
        }
        storageDevice = new DirectAccessDeviceImpl(this.cluster, aCED);
        storageDevice.changeParameterList(aCED);
        this.storagePool.addStorage(storageDevice);
        this.cluster.getAttachedRaidsMgr().updateRaidsCollectionForCreatedDisk(storageDevice);
        return storageDevice;
    }

    public GeneralSCSIDeviceImpl removeGeneralSCSIDevice(GeneralSCSIDeviceImpl generalSCSIDevice) throws RemoteException {
        if (generalSCSIDevice.getConnectedVSwitchCounter() == 1) {
            this.storagePool.removeStorage(generalSCSIDevice);
        }
        return generalSCSIDevice;
    }

    public SequentialAccessDeviceImpl removeSequentialAccessDevice(SequentialAccessDeviceImpl sequentialAccessDevice) throws RemoteException {
        return (SequentialAccessDeviceImpl)this.removeGeneralSCSIDevice(sequentialAccessDevice);
    }

    public DirectAccessDeviceImpl removeDirectAccessDevice(DirectAccessDeviceImpl directAccessDevice) throws RemoteException {
        if (directAccessDevice.getConnectedVSwitchCounter() == 1) {
            this.storagePool.removeStorage(directAccessDevice);
            this.cluster.getAttachedRaidsMgr().updateRaidsCollectionForDeletedDisk(directAccessDevice);
        }
        return directAccessDevice;
    }

    public SubDirectAccessDeviceImpl removeSubDirectAccessDevice(SubDirectAccessDeviceImpl subDirectAccessDevice) throws RemoteException {
        if (subDirectAccessDevice.getConnectedVSwitchCounter() == 1) {
            DirectAccessDeviceImpl parent = subDirectAccessDevice.getDirectAccessDeviceParent();
            parent.removeSubDirectAccessDevice(subDirectAccessDevice);
        }
        return subDirectAccessDevice;
    }

    public LUImpl luRemoved(LUImpl lu) throws RemoteException {
        TargetImpl target;
        if (lu.getConnectedVSwitchCounter() == 1) {
            VolumeNodeImpl volume = this.targetList.removeLU(lu);
            this.cluster.getStorage().returnVolumeToForest(volume);
        }
        if ((target = lu.getParentTarget()).getLUCount() == 0 && ServerPropertiesFetcher.isRemoveTargetEnabled()) {
            try {
                target.deleteElement();
            }
            catch (IllegalValueException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)((Object)exp), new Object[]{"An error occured while removing the target " + target + " since all its LUs were removed."});
            }
        }
        return lu;
    }

    public SCSILunImpl removeSCSILun(SCSILunImpl scsiLun) throws RemoteException {
        if (scsiLun.getConnectedVSwitchCounter() == 1) {
            LUImpl lu;
            CommKeyClassId parentTargetKey = scsiLun.getSCSITargetID();
            TargetImpl parent = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parentTargetKey);
            if (parent != null && (lu = parent.getLU(scsiLun.getLUN())) != null) {
                lu.setScsiLun(null);
            }
        }
        return scsiLun;
    }

    public boolean returnVolumeToForest(VolumeNodeImpl volume) throws RemoteException {
        if (this.volumeForest.getAll().contains(volume)) {
            return false;
        }
        VolumeImpl parentVol = volume.getParentVolume();
        if (parentVol != null) {
            parentVol.removeChild(volume);
            parentVol.removePropagationStateDependentObjectAndListener(volume);
        } else {
            LUImpl lu = volume.getParentLU();
            if (lu == null) {
                return false;
            }
            lu.removeVol(volume);
            lu.removePropagationStateDependentObjectAndListener(volume);
        }
        volume.setExposed(false);
        volume.setParentLU(null);
        volume.setParent(null, 0);
        if (volume instanceof Volume) {
            this.volumeForest.addVolume((VolumeImpl)volume);
            Vector leafs = ((Volume)((Object)volume)).getLeafs();
            Enumeration e = leafs.elements();
            while (e.hasMoreElements()) {
                this.cluster.addPropagationStateDependentObjectAndListener((LogicObjectImpl)e.nextElement());
            }
        } else {
            this.cluster.addPropagationStateDependentObjectAndListener(volume);
        }
        AlarmMgrImpl.getInstance().setAlarmsOnAllVSwitchesIfNeed((GeneralLogicObjectImpl)volume);
        return true;
    }

    public TargetImpl removeTarget(TargetImpl target) throws RemoteException {
        if (target.getConnectedVSwitchCounter() == 1) {
            this.targetList.removeTarget(target);
        }
        return target;
    }

    public ISCSIRemoteTargetImpl removeRemoteTarget(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        if (remoteTarget.getConnectedVSwitchCounter() == 1) {
            this.getRemoteTargetListMgr().removeRemoteTarget(remoteTarget);
        }
        return remoteTarget;
    }

    public ISCSIRemoteTargetPortalImpl removeRemoteTargetPortal(ISCSIRemoteTargetPortalImpl remoteTargetPortal) throws RemoteException {
        if (remoteTargetPortal.getConnectedVSwitchCounter() == 1) {
            ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)remoteTargetPortal.getRemoteTarget();
            ErrorAssertingListener.listenTo(remoteTarget.removePortal(remoteTargetPortal));
        }
        return remoteTargetPortal;
    }

    public VolumeImpl removeVolume(VolumeImpl volume, VSwitchImpl vSwitch) throws RemoteException {
        List<SnapshotVolumeImpl> mySnapshots;
        boolean result;
        if (volume.getConnectedVSwitchCounter() == 1 && (result = this.volumeForest.removeVolumeTreeRoot(volume))) {
            List<VolumeNodeImpl> children = volume.getChildren();
            for (VolumeNodeImpl child : children) {
                if (!(child instanceof Storageable) || !volume.equals(child.getParentVolume())) continue;
                child.setFree(true);
                child.setParent(null, -1);
            }
        }
        SnapshotManager snapMgr = this.volumeManager.getSnapshotManager();
        if (volume.getClassId().equals((Object)ClassID.SNAPSHOT_VOLUME)) {
            snapMgr.removeSnapshot((SnapshotVolumeImpl)volume, vSwitch);
            VolumeNodeImpl snapshotSource = ((SnapshotVolumeImpl)volume).getSourceVolume(vSwitch);
            VSwitchImpl otherVs = this.cluster.getOtherVSwitch(vSwitch);
            VolumeNodeImpl otherSnapSource = ((SnapshotVolumeImpl)volume).getSourceVolume(otherVs);
            if (snapshotSource != null && !snapshotSource.equals(otherSnapSource)) {
                snapshotSource.removeSynchronizeListener(volume);
                snapshotSource.removePropagatedStateEventListener(volume);
            }
        }
        if (snapMgr.isSourceOfSnapshot(volume) && (mySnapshots = snapMgr.getSnapshotsForSourceVolume(volume, vSwitch)) != null) {
            Iterator<SnapshotVolumeImpl> itr = mySnapshots.iterator();
            while (itr.hasNext()) {
                ConfigElementData element = new ConfigElementData(((VolumeNode)itr.next()).getCommKeyClassId());
                element.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (SrType)null);
                CommKeyClassId[] vSwitchData = new CommKeyClassId[]{vSwitch.getCommKeyClassId()};
                element.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchData);
                ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().readElement(element));
            }
        }
        for (VolumeNodeImpl child : volume.getChildren()) {
            AlarmMgrImpl.getInstance().setAlarmsOnAllVSwitchesIfNeed((GeneralLogicObjectImpl)child);
        }
        return volume;
    }

    public void clear() throws RemoteException {
        this.storagePool.removeAll();
        this.volumeManager.clear();
        this.getRemoteTargetListMgr().removeAll();
        this.cluster.getTargetQosMgr().clear();
        this.cluster.getAttachedRaidsMgr().clear();
        this.cluster.getSnapshotSchedulerMgr().clear();
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int storageRetVal;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        try {
            storageRetVal = this.storagePool.synchronize();
            if (storageRetVal > retVal) {
                retVal = storageRetVal;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)((Object)ive), new Object[0]);
            if (ive.getMessage() != null) {
                errMsg.append(ive.getMessage());
            }
            errOccured = true;
        }
        try {
            storageRetVal = this.targetList.synchronize();
            if (storageRetVal > retVal) {
                retVal = storageRetVal;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)((Object)ive), new Object[0]);
            if (ive.getMessage() != null) {
                errMsg.append(ive.getMessage());
            }
            errOccured = true;
        }
        try {
            this.volumeForest.synchronize();
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)((Object)ive), new Object[0]);
            if (ive.getMessage() != null) {
                errMsg.append(ive.getMessage());
            }
            errOccured = true;
        }
        try {
            int storageRetVal2 = this.getRemoteTargetListMgr().synchronize();
            if (storageRetVal2 > retVal) {
                retVal = storageRetVal2;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)((Object)ive), new Object[0]);
            if (ive.getMessage() != null) {
                errMsg.append(ive.getMessage());
            }
            errOccured = true;
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return 0;
    }

    @Override
    public ClusterImpl getCluster() {
        return this.cluster;
    }

    @Override
    public SrFuture<Void> readSnapshotVolumes() throws RemoteException {
        return this.volumeManager.readSnapshotVolumes();
    }

    private CommKeyClassId[] getChildrenDataByPosition(Object children, VSwitchImpl vswitch) {
        CommKeyClassId[] childrenCommKeys;
        if (children instanceof List) {
            childrenCommKeys = new CommKeyClassId[((List)children).size()];
            int childPosition = 0;
            for (VolumeNodeImpl child : (List)children) {
                Integer position;
                childPosition = vswitch != null ? ((position = child.getPositionInParent(vswitch)) != null ? position : ++childPosition) : ++childPosition;
                childrenCommKeys[childPosition - 1] = child.getCommKeyClassId();
            }
        } else {
            childrenCommKeys = new CommKeyClassId[1];
            LogicObjectImpl child = (LogicObjectImpl)children;
            childrenCommKeys[0] = child.getCommKeyClassId();
        }
        return childrenCommKeys;
    }

    private CommKeyClassId[] getVSwitchesAllChildrenExistIn(Object children) throws IllegalValueException, RemoteException {
        ArrayList<VSwitchImpl> vSwitchesToSet = new ArrayList<VSwitchImpl>(this.cluster.getVSwitches());
        if (children instanceof List) {
            for (AliasObjectImpl child : (List)children) {
                if (child.isRedundant()) continue;
                VSwitchImpl[] childVSwitch = child.getConnectedVSwitches();
                Iterator<VSwitchImpl> vSwitches = vSwitchesToSet.iterator();
                while (vSwitches.hasNext()) {
                    boolean wasFound = false;
                    VSwitch vSwitch = vSwitches.next();
                    for (int i = 0; i < childVSwitch.length; ++i) {
                        if (!((Object)childVSwitch[i]).equals(vSwitch)) continue;
                        wasFound = true;
                        break;
                    }
                    if (wasFound) continue;
                    vSwitches.remove();
                }
            }
            if (vSwitchesToSet.size() == 0) {
                throw new IllegalValueException("Children volumes do not exist in the same VSwitches.");
            }
            CommKeyClassId[] retVal = new CommKeyClassId[vSwitchesToSet.size()];
            for (int i = 0; i < vSwitchesToSet.size(); ++i) {
                retVal[i] = vSwitchesToSet.get(i).getCommKeyClassId();
            }
            return retVal;
        }
        VSwitchImpl[] connectedVSwitches = ((VolumeNodeImpl)children).getConnectedVSwitches();
        CommKeyClassId[] retVal = new CommKeyClassId[connectedVSwitches.length];
        for (int i = 0; i < connectedVSwitches.length; ++i) {
            retVal[i] = connectedVSwitches[i].getCommKeyClassId();
        }
        return retVal;
    }

    public VSwitch getVSwitch(HashMap parameterList) throws RemoteException {
        Object vSwitchObj = parameterList.get(ParameterCode.VSWITCH_ID);
        if (vSwitchObj != null) {
            CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)vSwitchObj;
            VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            return vSwitch;
        }
        return null;
    }

    public boolean areVolumesConnectedToRemoteTarget(String remoteTargetName) {
        GeneralSCSIDevice[] remoteTargetStorages = this.storagePool.getStoragesByEntityName(remoteTargetName);
        return remoteTargetStorages != null && remoteTargetStorages.length > 0;
    }

    public Vector getOtherVolumesConnectedToEntityName(String entityName, GeneralSCSIDevice excludeSCSIDevice) throws RemoteException {
        GeneralSCSIDevice[] storages = this.storagePool.getStoragesByEntityName(entityName);
        Vector<GeneralSCSIDevice> otherStorages = new Vector<GeneralSCSIDevice>(storages.length);
        for (int index = 0; index < storages.length; ++index) {
            if (excludeSCSIDevice.equals(storages[index])) continue;
            otherStorages.add(storages[index]);
        }
        return otherStorages;
    }

    public ISCSIRemoteTarget getRemoteTargetByName(String name) throws RemoteException {
        return this.getRemoteTargetListMgr().getRemoteTargetByName(name);
    }

    @Override
    public JournalVolume getJournalVolume(VSwitch vswitch) throws RemoteException {
        for (VolumeTreeImpl currTree : this.getVolumeForest()) {
            VolumeNodeImpl currNode = currTree.getTreeRoot();
            if (!(currNode instanceof JournalVolume)) continue;
            CommKeyClassId vswitchData = vswitch.getCommKeyClassId();
            VSwitchImpl vSwitch = (VSwitchImpl)SystemRootImpl.getInstance().getRefByStub(vswitchData);
            if (!currNode.getActiveVswitch().equals(vSwitch)) continue;
            return (JournalVolume)((Object)currNode);
        }
        return null;
    }

    public Storageable getStorageByAlias(String alias) throws RemoteException {
        return this.storagePool.getStorageByAlias(alias);
    }

    @Override
    public Volume getVolumeByAlias(String alias) throws RemoteException {
        return this.volumeForest.getVolumeByAlias(alias);
    }

    @Override
    public Volume getExposedOrUnexposedVolumeByAlias(String aAlias) throws RemoteException {
        return this.volumeManager.getVolumeByAlias(aAlias);
    }

    public List<MirrorVolumeImpl> getAllRootMirrors() {
        return this.volumeManager.getRootVolumeByType(MirrorVolumeImpl.class, ClassID.MIRROR_VOLUME);
    }

    @Override
    public SrFuture<Void> discoverRemoteTargets(ISCSIRemotePortalDiscovery[] remoteDiscoveryPortals) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("StorageImpl.discoverRemoteTargets");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (remoteDiscoveryPortals != null) {
            for (int index = 0; index < remoteDiscoveryPortals.length; ++index) {
                midFutures.add(remoteDiscoveryPortals[index].discoverRemoteTargets());
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> activateDeactivateSnapshots(SnapshotVolume[] snapshots, SnapshotActivateTypeConstants sat) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("Site.startReplicate_DRActivate[]");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int index = 0; index < snapshots.length; ++index) {
            if (snapshots[index] == null) {
                theLogger.warn(SrLogCategories.SYSTEM, new Object[]{"The client send an active/deactive snapshot command to the server but the server could not find the snapshot. This can be caused by a VS rediscovery race, or a real corruption in the logic's data."});
                continue;
            }
            midFutures.add(snapshots[index].changeElement(ClientParameterCode.SNAPSHOT_ACTIVATE, sat));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }
}

