/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.SrTestUtils;
import com.sanrad.TestServerEventsListener;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotification;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgrImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import junit.framework.TestCase;

public class SrStorageNotificationMgrImplTest
extends TestCase {
    private static SrTestUtils myTestUtils;
    private static int MAX_NOTIFICATIONS_PER_VS;
    private static final Semaphore theLock;
    private static SrLogger theLogger;
    private static final String CONF_FILE;
    private static Properties logProps;
    private Properties myProperties = new Properties();
    private ServerFacade myFacade = null;
    private static Integer notificationID;
    private static SiteImpl mySite;
    private static ClusterImpl myClus1;
    private static ClusterImpl myClus2;
    private static VSwitchImpl myVs1;
    private static VSwitchImpl myVs2;

    public SrStorageNotificationMgrImplTest() {
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
        try {
            this.myProperties.load(new FileInputStream("test//config//SrStorageNotificationMgrImplTest.properties"));
        }
        catch (FileNotFoundException exp) {
            exp.printStackTrace();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            theLock.acquire();
        }
        catch (InterruptedException exp) {
            SrStorageNotificationMgrImplTest.fail((String)"Could not acquire the lock in order to run the test.");
        }
        while (!SystemRootImpl.getInstance().isDiscoverCompleted()) {
            Thread.sleep(500L);
        }
        this.myFacade = LogicMgrAOImpl.getInstance().openSession((ServerEventsListener)new TestServerEventsListener(((Object)((Object)this)).hashCode()));
    }

    protected void tearDown() throws Exception {
        SrStorageNotificationMgrImpl.getInstance().clearAllNotifications();
        this.cleanResources();
        this.myFacade.closeSession();
        theLock.release();
        super.tearDown();
    }

    private void cleanResources() {
        notificationID = 0;
        mySite = null;
        myClus2 = null;
        myClus1 = null;
        myVs2 = null;
        myVs1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearNotifications() {
        try {
            mySite = (SiteImpl)myTestUtils.createSite("MySite");
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The site needed for the test could not be created.", (Object)mySite);
            myClus1 = myTestUtils.createCluster("myCluster1", (Site)mySite);
            myClus2 = myTestUtils.createCluster("myCluster2", (Site)mySite);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The first cluster needed for the test could not be created.", (Object)myClus1);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The second cluster needed for the test could not be created.", (Object)myClus2);
            myVs1 = myTestUtils.createDefaultVswitch(myClus1, this.myProperties.getProperty("VS1_IP"));
            myVs2 = myTestUtils.createDefaultVswitch(myClus2, this.myProperties.getProperty("VS2_IP"));
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The first VS needed for the test could not be created.", (Object)myVs1);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The second VS needed for the test could not be created.", (Object)myVs2);
            this.generateNotificationsForAll();
            try {
                SrStorageNotificationMgrImpl.getInstance().clearAllNotifications();
                List<? extends SrStorageNotification> theList1 = SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs1.getCommKeyClassId());
                SrStorageNotificationMgrImplTest.assertTrue((String)"The container holds a key for VS1 which should not be", (boolean)theList1.isEmpty());
                List<? extends SrStorageNotification> theList2 = SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs2.getCommKeyClassId());
                SrStorageNotificationMgrImplTest.assertTrue((String)"The container holds a key for VS2 which should not be", (boolean)theList2.isEmpty());
            }
            catch (RemoteException e) {
                SrStorageNotificationMgrImplTest.fail((String)("Could not clear notifications becasue of Remote Exception: " + e));
            }
        }
        finally {
            myTestUtils.removeSite((Site)mySite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationInsertion() {
        try {
            mySite = (SiteImpl)myTestUtils.createSite("MySite");
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The site needed for the test could not be created.", (Object)mySite);
            myClus1 = myTestUtils.createCluster("myCluster1", (Site)mySite);
            myClus2 = myTestUtils.createCluster("myCluster2", (Site)mySite);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The first cluster needed for the test could not be created.", (Object)myClus1);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The second cluster needed for the test could not be created.", (Object)myClus2);
            myVs1 = myTestUtils.createDefaultVswitch(myClus1, this.myProperties.getProperty("VS1_IP"));
            myVs2 = myTestUtils.createDefaultVswitch(myClus2, this.myProperties.getProperty("VS2_IP"));
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The first VS needed for the test could not be created.", (Object)myVs1);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The second VS needed for the test could not be created.", (Object)myVs2);
            SrStorageNotificationImpl nVS1 = null;
            SrStorageNotificationImpl nVS2 = null;
            try {
                nVS1 = this.generateSingleNotificationForVS(myVs1);
                nVS2 = this.generateSingleNotificationForVS(myVs2);
                SrStorageNotificationMgrImpl.getInstance().addNotification(nVS1, SrTrapType.NEXSAN_RAID_TRAP_EVENT);
                SrStorageNotificationMgrImpl.getInstance().addNotification(nVS2, SrTrapType.NEXSAN_RAID_TRAP_EVENT);
            }
            catch (Exception e) {
                SrStorageNotificationMgrImplTest.fail((String)("Could not add notifications becasue of exception: " + e));
            }
            try {
                List<? extends SrStorageNotification> firstList = SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs1.getCommKeyClassId());
                SrStorageNotificationMgrImplTest.assertTrue((String)"The first notification was not found in the list.", (boolean)firstList.contains(nVS1));
                SrStorageNotificationMgrImplTest.assertEquals((String)"There should be only one notification for the first VS.", (int)1, (int)firstList.size());
                List<? extends SrStorageNotification> secondList = SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs2.getCommKeyClassId());
                SrStorageNotificationMgrImplTest.assertTrue((String)"The second notification was not found in the list.", (boolean)secondList.contains(nVS2));
                SrStorageNotificationMgrImplTest.assertEquals((String)"There should be only one notification for the second VS.", (int)1, (int)secondList.size());
            }
            catch (RemoteException e) {
                SrStorageNotificationMgrImplTest.fail((String)"Got remote exception in testNotificationInsertion");
            }
        }
        finally {
            myTestUtils.removeSite((Site)mySite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationReplace() {
        try {
            mySite = (SiteImpl)myTestUtils.createSite("MySite");
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The site needed for the test could not be created.", (Object)mySite);
            myClus1 = myTestUtils.createCluster("myCluster1", (Site)mySite);
            myClus2 = myTestUtils.createCluster("myCluster2", (Site)mySite);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The first cluster needed for the test could not be created.", (Object)myClus1);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The second cluster needed for the test could not be created.", (Object)myClus2);
            myVs1 = myTestUtils.createDefaultVswitch(myClus1, this.myProperties.getProperty("VS1_IP"));
            myVs2 = myTestUtils.createDefaultVswitch(myClus2, this.myProperties.getProperty("VS2_IP"));
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The first vs needed for the test could not be created.", (Object)myVs1);
            SrStorageNotificationMgrImplTest.assertNotNull((String)"The second vs needed for the test could not be created.", (Object)myVs2);
            this.generateNotificationsForAll();
            SrStorageNotificationImpl nVS1 = null;
            SrStorageNotificationImpl nVS2 = null;
            SrStorageNotificationImpl nOldVS1 = null;
            SrStorageNotificationImpl nOldVS2 = null;
            try {
                nVS1 = this.generateSingleNotificationForVS(myVs1);
                nVS2 = this.generateSingleNotificationForVS(myVs2);
                nOldVS1 = (SrStorageNotificationImpl)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs1.getCommKeyClassId()).get(0);
                nOldVS2 = (SrStorageNotificationImpl)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs2.getCommKeyClassId()).get(0);
                SrStorageNotificationMgrImpl.getInstance().addNotification(nVS1, SrTrapType.NEXSAN_RAID_TRAP_EVENT);
                SrStorageNotificationMgrImpl.getInstance().addNotification(nVS2, SrTrapType.NEXSAN_RAID_TRAP_EVENT);
            }
            catch (Exception e) {
                SrStorageNotificationMgrImplTest.fail((String)"Could not add notifications");
            }
            try {
                SrStorageNotificationMgrImplTest.assertTrue((boolean)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs1.getCommKeyClassId()).contains(nVS1));
                SrStorageNotificationMgrImplTest.assertFalse((boolean)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs1.getCommKeyClassId()).contains(nOldVS1));
                SrStorageNotificationMgrImplTest.assertTrue((boolean)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs2.getCommKeyClassId()).contains(nVS2));
                SrStorageNotificationMgrImplTest.assertFalse((boolean)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs2.getCommKeyClassId()).contains(nOldVS2));
            }
            catch (RemoteException e) {
                SrStorageNotificationMgrImplTest.fail((String)"Got remote exception in testNotificationReplace");
            }
        }
        finally {
            myTestUtils.removeSite((Site)mySite);
        }
    }

    private void generateNotificationsForAll() {
        ArrayList<SrStorageNotificationImpl> theList1 = null;
        ArrayList<SrStorageNotificationImpl> theList2 = null;
        theList1 = this.generateMultiNotificationsForVS(MAX_NOTIFICATIONS_PER_VS, myVs1);
        SrStorageNotificationMgrImplTest.assertEquals((String)("The number of notifications inserted into the list for VS " + myVs1 + " is not the maximum number of notifications allowed."), (int)MAX_NOTIFICATIONS_PER_VS, (int)theList1.size());
        theList2 = this.generateMultiNotificationsForVS(MAX_NOTIFICATIONS_PER_VS, myVs2);
        SrStorageNotificationMgrImplTest.assertEquals((String)("The number of notifications inserted into the list for VS " + myVs2 + " is not the maximum number of notifications allowed."), (int)MAX_NOTIFICATIONS_PER_VS, (int)theList2.size());
        try {
            for (SrStorageNotificationImpl entry : theList1) {
                SrStorageNotificationMgrImplTest.assertNotNull((String)"Failed adding notification to VS1", (Object)SrStorageNotificationMgrImpl.getInstance().addNotification(entry, SrTrapType.NEXSAN_RAID_TRAP_EVENT));
            }
            for (SrStorageNotificationImpl entry : theList2) {
                SrStorageNotificationMgrImplTest.assertNotNull((String)"Failed adding notification to VS2", (Object)SrStorageNotificationMgrImpl.getInstance().addNotification(entry, SrTrapType.NEXSAN_RAID_TRAP_EVENT));
            }
        }
        catch (RemoteException e) {
            SrStorageNotificationMgrImplTest.fail((String)"Failed in adding notifications !");
        }
        try {
            SrStorageNotificationMgrImplTest.assertEquals((String)"Notification's array list size for VS1 is not valid !", (int)MAX_NOTIFICATIONS_PER_VS, (int)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs1.getCommKeyClassId()).size());
            SrStorageNotificationMgrImplTest.assertEquals((String)"Notification's array list size for VS2 is not valid !", (int)MAX_NOTIFICATIONS_PER_VS, (int)SrStorageNotificationMgrImpl.getInstance().getNotifications(myVs2.getCommKeyClassId()).size());
        }
        catch (RemoteException e) {
            SrStorageNotificationMgrImplTest.fail((String)"Failed getting Notification's list");
        }
    }

    private ArrayList<SrStorageNotificationImpl> generateMultiNotificationsForVS(int aNumNotifications, VSwitchImpl aVsImpl) {
        ArrayList<SrStorageNotificationImpl> retList = new ArrayList<SrStorageNotificationImpl>(aNumNotifications);
        for (int i = 0; i < aNumNotifications && retList.add(this.generateSingleNotificationForVS(aVsImpl)); ++i) {
        }
        return retList;
    }

    private SrStorageNotificationImpl generateSingleNotificationForVS(VSwitchImpl aVsImpl) {
        SrStorageNotificationImpl retNF = null;
        try {
            ConfigElementData nCED = this.generateCED(aVsImpl.getCommKeyClassId());
            retNF = new SrStorageNotificationImpl(aVsImpl.getCluster(), nCED);
            retNF.changeParameterList(nCED);
        }
        catch (RemoteException e) {
            SrStorageNotificationMgrImplTest.fail((String)("Couldn't create Notification because of a remote exception: " + e));
        }
        catch (IllegalValueException e) {
            SrStorageNotificationMgrImplTest.fail((String)("Couldn't create Notification because of an illegal value exception: " + (Object)((Object)e)));
        }
        catch (InvalidElementException e) {
            SrStorageNotificationMgrImplTest.fail((String)("Couldn't create Notification because of an invalid element exception: " + (Object)((Object)e)));
        }
        return retNF;
    }

    private ConfigElementData generateCED(CommKeyClassId aVSCkClassID) {
        ConfigElementData retCED = new ConfigElementData(aVSCkClassID);
        retCED.setValue(ParameterCode.VSWITCH_ID, (SrType)aVSCkClassID);
        retCED.setValue(ParameterCode.RAID_TRAP_DEVICE_HOST_IP, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_DEVICE_HOST_IP")));
        retCED.setValue(ParameterCode.RAID_TRAP_DEVICE_HOST_NAME, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_DEVICE_HOST_NAME")));
        retCED.setValue(ParameterCode.RAID_TRAP_DEVICE_USER_LABEL, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_DEVICE_USER_LABEL")));
        retCED.setValue(ParameterCode.RAID_TRAP_DEVICE_ERROR_CODE, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_DEVICE_ERROR_CODE")));
        Date eventDate = new Date(System.currentTimeMillis());
        retCED.setValue(ParameterCode.RAID_TRAP_EVENT_TIME, (SrType)new SrString(eventDate.toString()));
        notificationID = notificationID + 1;
        retCED.setValue(ParameterCode.RAID_TRAP_DESCRIPTION, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_DESCRIPTION") + "_" + notificationID));
        retCED.setValue(ParameterCode.RAID_TRAP_COMPONENT_TYPE, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_COMPONENT_TYPE")));
        retCED.setValue(ParameterCode.RAID_TRAP_COMPONENT_LOCATION, (SrType)new SrString(this.myProperties.getProperty("RAID_TRAP_COMPONENT_LOCATION")));
        return retCED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        theLock = new Semaphore(1);
        theLogger = null;
        CONF_FILE = "config" + File.separator + "log.properties";
        logProps = new Properties();
        notificationID = 0;
        mySite = null;
        myClus1 = null;
        myClus2 = null;
        myVs1 = null;
        myVs2 = null;
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(CONF_FILE);
            logProps.load(inFile);
            SrLogger.init((Properties)logProps);
            theLogger = SrLogger.getLogger();
        }
        catch (FileNotFoundException e1) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        catch (IOException e) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        finally {
            try {
                if (inFile != null) {
                    inFile.close();
                }
            }
            catch (IOException e) {
                System.err.println("Can not close the logger configuration file.");
            }
        }
        Class<SrStorageNotificationMgrImpl> curClass = SrStorageNotificationMgrImpl.class;
        try {
            Field curField = curClass.getDeclaredField("MAX_NOTIFICATIONS_PER_VS");
            curField.setAccessible(true);
            MAX_NOTIFICATIONS_PER_VS = (Integer)curField.get(null);
        }
        catch (SecurityException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Could not initialize the field MAX_NOTIFICATIONS_PER_VS using reflection."});
        }
        catch (NoSuchFieldException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Could not initialize the field MAX_NOTIFICATIONS_PER_VS using reflection."});
        }
        catch (IllegalArgumentException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Could not initialize the field MAX_NOTIFICATIONS_PER_VS using reflection."});
        }
        catch (IllegalAccessException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"Could not initialize the field MAX_NOTIFICATIONS_PER_VS using reflection."});
        }
    }
}

