/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.ClientStateListener;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.statistics.Statistics;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class StatisticsImpl
extends TableRowImpl
implements Statistics,
ClientStateListener {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static final int POLL_INTERVAL = 10;
    protected HashMap<ParameterCode, ClientParameterCode> s_parametersToCalculateMap = null;
    private int m_refCounter = 0;
    private HashMap<ParameterCode, SrType> myCodeToLastValue = null;
    private HashMap<ParameterCode, Long> myCodeToUpdateTime = null;
    private HashMap m_clientRates = new HashMap();
    private CommKeyClassId m_activeVSwitchCommkeyClassId = null;
    private CommKeyClassId myParentVsID;
    private static SrLogger theLogger;

    private void setVS(VSwitchImpl aVS, ClassID aClassId) {
        aVS.setStatistics(aClassId, this);
    }

    public StatisticsImpl(VSwitchImpl aVS, ClusterImpl cluster, ClassID aClassId, ConfigElementData aCED, HashMap parametersToCalculateCodeMap) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, aClassId, aCED);
        this.myParentVsID = aVS.getCommKeyClassId();
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.setParametersToCalculateMap(parametersToCalculateCodeMap);
        LogicMgrAOImpl.getInstance().addElementListener(this);
        this.setVS(aVS, aClassId);
    }

    protected StatisticsImpl(ClusterImpl cluster, ClassID aClassId, ConfigElementData aCED, HashMap<ParameterCode, ClientParameterCode> parametersToCalculateCodeMap) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, aClassId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.setParametersToCalculateMap(parametersToCalculateCodeMap);
        LogicMgrAOImpl.getInstance().addElementListener(this);
        VSwitchImpl targetVS = null;
        for (VSwitchImpl curVS : cluster.getVSwitches()) {
            if (!curVS.getCommKeyClassId().equals((Object)aCED.getVswitchId())) continue;
            targetVS = curVS;
        }
        if (targetVS == null) {
            throw new IllegalStateException("The CED " + aCED + " does not contain the same VSs as the cluster " + cluster);
        }
        this.setVS(targetVS, aClassId);
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException("This statistics element cannot be deleted " + this.toString());
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException("This element cannot be changed " + this.toString());
    }

    private synchronized void incrementCounter() {
        ++this.m_refCounter;
    }

    private synchronized void decrementCounter() {
        --this.m_refCounter;
    }

    private synchronized int getCounter() {
        return this.m_refCounter;
    }

    private void setParametersToCalculateMap(HashMap<ParameterCode, ClientParameterCode> parametersToCalculateMap) {
        this.s_parametersToCalculateMap = parametersToCalculateMap;
    }

    protected abstract PollingGroupType getGroupType();

    @Override
    @Deprecated
    public SrFuture<Void> startPolling() throws RemoteException {
        CommKeyClassId vswitchData = this.getActiveVswitch() == null ? this.m_activeVSwitchCommkeyClassId : this.getActiveVswitch().getCommKeyClassId();
        return this.startPolling(this.getGroupType(), vswitchData);
    }

    public SrFuture<Void> startPolling(PollingGroupType aGroupType, CommKeyClassId aVS) {
        SrFuture<Void> retFuture = null;
        if (this.getCounter() == 0) {
            retFuture = DataMgrAdapter.getInstance().startPolling(aGroupType, aVS);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{this, ": ", ClassID.VSWITCH, " ", aVS, " start polling"});
        }
        this.incrementCounter();
        if (retFuture == null) {
            return new CompleteFuture("StatisticsImpl.startPolling");
        }
        return retFuture;
    }

    public SrFuture<Integer> stopPolling(PollingGroupType aGroupType, CommKeyClassId aVS) throws RemoteException, IllegalValueException {
        this.clearParameterList();
        int counter = this.getCounter();
        switch (counter) {
            case 0: {
                throw new IllegalValueException(this + ": " + ClassID.VSWITCH + " " + aVS + " could not stop polling - polling was never started.");
            }
            case 1: {
                ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().stopPolling(aGroupType, aVS));
                this.myCodeToLastValue = null;
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{this, ": ", ClassID.VSWITCH, " ", aVS, " stop polling"});
            }
        }
        this.decrementCounter();
        return new CompleteFuture((Object)this.getCounter(), "StatisticsImpl.stopPolling");
    }

    @Override
    @Deprecated
    public SrFuture<Integer> stopPolling() throws RemoteException, IllegalValueException {
        CommKeyClassId vswitchData = this.getActiveVswitch() == null ? this.m_activeVSwitchCommkeyClassId : this.getActiveVswitch().getCommKeyClassId();
        return this.stopPolling(this.getGroupType(), vswitchData);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        if (this.myCodeToLastValue == null) {
            this.myCodeToLastValue = new HashMap();
        }
        if (this.myCodeToUpdateTime == null) {
            this.myCodeToUpdateTime = new HashMap();
        }
        HashMap<ClientParameterCode, Long> clientRates = new HashMap<ClientParameterCode, Long>();
        for (ParameterCode currParam : this.s_parametersToCalculateMap.keySet()) {
            SrType newValue;
            if (!aCED.containsParameter(currParam) || (newValue = (SrType)aCED.getValue((ParameterCodes)currParam)) == null) continue;
            SrType oldValue = this.myCodeToLastValue.get(currParam);
            Long lastUpdateTime = this.myCodeToUpdateTime.get(currParam);
            long currTime = System.currentTimeMillis();
            if (oldValue != null && lastUpdateTime != null) {
                long diff = ((Number)newValue.value()).longValue() - ((Number)oldValue.value()).longValue();
                long timeDiffSec = (currTime - lastUpdateTime) / 1000L;
                if (timeDiffSec <= 8L || timeDiffSec > 30L) {
                    this.myCodeToLastValue.put(currParam, newValue);
                    this.myCodeToUpdateTime.put(currParam, currTime);
                    continue;
                }
                long rate = diff / timeDiffSec;
                ClientParameterCode clientParamCodeForRate = this.s_parametersToCalculateMap.get(currParam);
                clientRates.put(clientParamCodeForRate, rate);
            }
            this.myCodeToLastValue.put(currParam, newValue);
            this.myCodeToUpdateTime.put(currParam, currTime);
        }
        this.m_clientRates = clientRates;
        this.m_activeVSwitchCommkeyClassId = this.getActiveVswitch().getCommKeyClassId();
        return changedValues;
    }

    public HashMap getClientRates() {
        return this.m_clientRates;
    }

    @Override
    public void remoteClientClosed(ClientStateEvent e) {
        int counter = this.getCounter();
        if (counter > 0 && e.getNumberOfCurrentRemoteClients() == 0) {
            try {
                ErrorAssertingListener.listenTo(this.stopPolling());
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            }
            catch (IllegalValueException ive) {
                theLogger.error(SrLogCategories.LEGACY, (Throwable)((Object)ive), new Object[0]);
            }
        }
    }

    @Override
    public VSwitchImpl getDominantVswitch() {
        return this.getParentVSwitch();
    }

    @Override
    public boolean isKnownByVSwitch(VSwitchImpl aVswitch) {
        if (aVswitch != null) {
            return aVswitch.equals(this.getParentVSwitch());
        }
        return false;
    }

    public void clearParameterList() throws RemoteException {
    }

    @Override
    public void clear() throws RemoteException {
        super.clear();
        LogicMgrAOImpl.getInstance().removeElementListener(this);
    }

    @Override
    public CommKey[] getCommKeys() {
        CommKey[] keys = super.getCommKeys();
        return keys != null ? keys : this.myParentVsID.getCommKeys();
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }
}

