/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.isns;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerValidator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;

public class ISNSServerValidator
extends ExternalServerValidator {
    private static final int MAX_ISNS_SERVERS = 2;

    public ISNSServerValidator(ClusterImpl cluster, String serverIp) {
        this.cluster = cluster;
        this.serverIp = serverIp;
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (this.cluster.getISNSServersList().getAllServers().size() == 2) {
            this.setErrorMsg(ErrorMessage.MAX_ISNS_SERVERS_IN_SYSTEM.getMessage(this.serverIp));
            return false;
        }
        if (this.serverIp.equals("")) {
            this.setErrorMsg("IP of " + ClassID.ISNS_SERVER + " cannot be empty");
            return false;
        }
        try {
            if (!NetUtil.isNetworkIpValid((String)this.serverIp)) {
                this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.serverIp));
                return false;
            }
        }
        catch (IllegalArgumentException iae) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.serverIp));
            return false;
        }
        if (this.cluster.getISNSServersList().isServerExist(this.serverIp)) {
            String[] errorBody = new String[]{ClassID.ISNS_SERVER.toString(), this.serverIp};
            this.setErrorMsg(ErrorMessage.SERVER_ALREADY_EXIST.getMessage(errorBody));
            return false;
        }
        return true;
    }
}

