/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.isns;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.srv.isns.ISNSServerAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.srv.isns.ISNSServer;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ISNSServerImpl
extends ExternalServerImpl
implements ISNSServer {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public ISNSServerImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public String getAlias() {
        return this.getServerIP();
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return "";
    }

    @Override
    public String getServerIP(VSwitch vSwitch) throws RemoteException {
        return this.getDisplayStringOf(vSwitch, ParameterCode.ISNS_SERVER_IP_ADDRESS, vSwitch == null);
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isRedundant()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Synchronizing: creating ISNS server on other ", ClassID.VSWITCH});
            ErrorAssertingListener.listenTo(this.cluster.createISNSServer(this.getServerIP(), this.cluster.getOtherVSwitches(this.getVSwitches())));
            return 2;
        }
        return 0;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return ISNSServerAlarmGenerator.getInstatnce();
    }

    @Override
    public String toString() {
        return "iSNS server-" + this.serverIpAddress;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.ISNS_SERVER_IP_ADDRESS);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISNS_SERVER_IP_ADDRESS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

