/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.srv.ExternalServer;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ExternalServerList {
    private Hashtable<String, ExternalServerImpl> serverList = new Hashtable();
    private static SrLogger theLogger = SrLogger.getLogger();

    public void addExternalServer(ExternalServerImpl server) throws RemoteException {
        this.serverList.put(server.getServerIP(), server);
    }

    public ExternalServerImpl getExternalServerByIP(String ip) {
        return this.serverList.get(ip);
    }

    public void removeExternalServerByIP(String ip) {
        this.serverList.remove(ip);
    }

    public void removeExternalServer(ExternalServer server) throws RemoteException {
        this.serverList.remove(server.getServerIP());
    }

    public Vector<ExternalServerImpl> getAllServers() {
        Vector<ExternalServerImpl> servers = new Vector<ExternalServerImpl>(this.serverList.size());
        for (ExternalServerImpl server : this.serverList.values()) {
            servers.addElement(server);
        }
        return servers;
    }

    public boolean isServerExist(String ipAddress) {
        return this.serverList.containsKey(ipAddress);
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        for (ExternalServerImpl extServer : this.serverList.values()) {
            try {
                extServer.synchronize();
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive.getMessage(), " when trying to synchronize ", extServer.getClassId(), " ", extServer});
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return false;
    }

    public boolean isServerExistOnVSwitches(List<VSwitchImpl> vSwitches) throws RemoteException {
        Enumeration<ExternalServerImpl> servers = this.serverList.elements();
        while (servers.hasMoreElements()) {
            ExternalServerImpl server = servers.nextElement();
            VSwitchImpl[] connectedVSwitches = server.getConnectedVSwitches();
            for (int i = 0; i < connectedVSwitches.length; ++i) {
                if (!vSwitches.contains(connectedVSwitches[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.serverList.clear();
    }

    public int size() {
        return this.serverList.size();
    }
}

