/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.raid;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.raid.AttachedRaid;
import com.sanrad.nms.server.logic.raid.AttachedRaidImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AttachedRaidsMgr {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl myCluster = null;
    private ArrayList<AttachedRaidImpl> myAttachedRaids = new ArrayList();
    private HashSet<RAID> myExistingRaids = new HashSet();

    public AttachedRaidsMgr(ClusterImpl aCluster) {
        Util.validateInputNotNull((Object)aCluster, (String)"Cluster");
        this.myCluster = aCluster;
    }

    public void clear() {
        this.myAttachedRaids.clear();
        this.myExistingRaids.clear();
    }

    private AttachedRaidImpl findAttachedRaid(ConfigElementData aCED) {
        SrIpAddress ctrlIp1 = (SrIpAddress)aCED.getValue((ParameterCodes)ParameterCode.ATTACHED_RAID_CTRL_IP1);
        SrIpAddress ctrlIp2 = (SrIpAddress)aCED.getValue((ParameterCodes)ParameterCode.ATTACHED_RAID_CTRL_IP2);
        SrEntityNameFormat uniqueName = (SrEntityNameFormat)aCED.getValue((ParameterCodes)ParameterCode.ATTACHED_RAID_UNIQUE_NAME);
        SrString name = (SrString)aCED.getValue((ParameterCodes)ParameterCode.ATTACHED_RAID_NAME);
        return this.findAttachedRaid(ctrlIp1, ctrlIp2, uniqueName, name != null ? name.toString() : null);
    }

    private AttachedRaidImpl findAttachedRaid(SrIpAddress aCtrlIp1, SrIpAddress aCtrlIp2, SrEntityNameFormat aUniqueName, String aName) {
        for (AttachedRaidImpl currAttachedRaid : this.myAttachedRaids) {
            SrEntityNameFormat targetName;
            List cedIps = Util.convertToList((Object[])new SrIpAddress[]{aCtrlIp1, aCtrlIp2});
            List<SrIpAddress> raidIps = currAttachedRaid.getCtrlIps();
            if (!cedIps.isEmpty() && !raidIps.isEmpty()) {
                cedIps.retainAll(raidIps);
                if (cedIps.isEmpty()) continue;
                return currAttachedRaid;
            }
            if (aUniqueName == null || !(aUniqueName.equals((Object)AttachedRaid.ISCSI_RAID_UNIQUE_NAME) ? aName != null && (targetName = new SrEntityNameFormat(aName.getBytes())).equals((Object)currAttachedRaid.getWwn()) : aUniqueName.equals((Object)currAttachedRaid.getWwn()))) continue;
            return currAttachedRaid;
        }
        return null;
    }

    public List<AttachedRaidImpl> getAllAttachedRaids() {
        return new ArrayList<AttachedRaidImpl>(this.myAttachedRaids);
    }

    public AttachedRaidImpl newAttachedRaid(ConfigElementData aCED) throws IllegalValueException, RemoteException, InvalidElementException, AlreadyKnownByVSwitch {
        AttachedRaidImpl alreadyExistRaid = this.findAttachedRaid(aCED);
        if (alreadyExistRaid != null) {
            return alreadyExistRaid;
        }
        AttachedRaidImpl raid = new AttachedRaidImpl(this.myCluster, aCED);
        raid.changeParameterList(aCED);
        if (this.validateNewAttachedRaid(raid)) {
            this.myAttachedRaids.add(raid);
            return raid;
        }
        ConfigElementDataList deletionCedList = new ConfigElementDataList(raid.getCedForDeletion(), ConfigOperation.DELETE);
        DataMgrAdapter.getInstance().configureElements(deletionCedList);
        return null;
    }

    private boolean validateNewAttachedRaid(AttachedRaidImpl aAttahcedRaid) {
        RAID raid = RAID.extractRaid(aAttahcedRaid);
        for (DirectAccessDeviceImpl disk : this.myCluster.getStoragePool().getAllDisks()) {
            if (!raid.isMyDisk(disk)) continue;
            return true;
        }
        return false;
    }

    public void removeAttachedRaid(AttachedRaidImpl aRaid) {
        if (aRaid.getConnectedVSwitchCounter() == 1) {
            this.myAttachedRaids.remove(aRaid);
        }
    }

    public AttachedRaidImpl getRaidByStorageEntityName(SrEntityNameFormat aEntityName) {
        for (AttachedRaidImpl raid : this.myAttachedRaids) {
            SrEntityNameFormat raidWwn = raid.getWwn();
            if (raidWwn == null || !raidWwn.equals((Object)aEntityName)) continue;
            return raid;
        }
        return null;
    }

    public String getVendorNameForRaid(AttachedRaidImpl aAttachedRaid) {
        RAID raid = RAID.extractRaid(aAttachedRaid);
        for (DirectAccessDeviceImpl disk : this.myCluster.getStoragePool().getAllDisks()) {
            String vendorName;
            if (!raid.isMyDisk(disk) || (vendorName = disk.getVendor(null)) == null) continue;
            return vendorName;
        }
        return null;
    }

    public void updateRaidsCollectionForCreatedDisk(DirectAccessDeviceImpl aDisk) {
        RAID newRaid = RAID.extractRaid(aDisk);
        if (!this.myExistingRaids.contains(newRaid)) {
            this.myExistingRaids.add(newRaid);
        }
    }

    public void updateRaidsCollectionForDeletedDisk(DirectAccessDeviceImpl aDisk) {
        RAID raid = RAID.extractRaid(aDisk);
        if (this.myExistingRaids.contains(raid)) {
            for (DirectAccessDeviceImpl disk : this.myCluster.getStoragePool().getAllDisks()) {
                if (disk == aDisk || !raid.isMyDisk(disk)) continue;
                return;
            }
        }
        this.myExistingRaids.remove(raid);
        AttachedRaidImpl attachedRaid = this.findAttachedRaid(raid.myCtrlIp1, raid.myCtrlIp2, raid.myWwnEntityName, raid.myName);
        if (attachedRaid != null) {
            ConfigElementDataList deletionCedList = new ConfigElementDataList(attachedRaid.getCedForDeletion(), ConfigOperation.DELETE);
            DataMgrAdapter.getInstance().configureElements(deletionCedList);
        }
    }

    public void updateRaidsCollectionForChangedDisk(DirectAccessDeviceImpl aDisk) {
    }

    public boolean isExists(String aRaidName, SrEntityNameFormat aWwnEntityName, SrIpAddress aCtrlIp1, SrIpAddress aCtrlIp2) {
        for (RAID raid : this.myExistingRaids) {
            SrEntityNameFormat currWwnEntityName;
            if (!(AttachedRaid.ISCSI_RAID_UNIQUE_NAME.equals((Object)aWwnEntityName) ? aRaidName != null && raid.isEquivalent(null, currWwnEntityName = new SrEntityNameFormat(aRaidName.getBytes()), aCtrlIp1, aCtrlIp2) : raid.isEquivalent(aRaidName, aWwnEntityName, aCtrlIp1, aCtrlIp2))) continue;
            return true;
        }
        return false;
    }

    private static class RAID {
        private String myName;
        private SrEntityNameFormat myWwnEntityName;
        private SrIpAddress myCtrlIp1;
        private SrIpAddress myCtrlIp2;

        static RAID extractRaid(DirectAccessDeviceImpl aDisk) {
            Util.validateInputNotNull((Object)aDisk, (String)"Disk");
            return new RAID(aDisk.getRaidSysName(), aDisk.getEntityNameValue(), aDisk.getRaidUrl1(), aDisk.getRaidUrl2());
        }

        static RAID extractRaid(AttachedRaidImpl aAttahcedRaid) {
            Util.validateInputNotNull((Object)aAttahcedRaid, (String)"Attached RAID");
            return new RAID(aAttahcedRaid.getName(), aAttahcedRaid.getWwn(), aAttahcedRaid.getCtrlIp1(), aAttahcedRaid.getCtrlIp2());
        }

        private RAID(String aName, SrEntityNameFormat aWwnEntityName, SrIpAddress aCtrlIp1, SrIpAddress aCtrlIp2) {
            Util.validateInputNotNull((Object)aWwnEntityName, (String)"WWN/Entity Name");
            this.myName = aName;
            this.myWwnEntityName = aWwnEntityName;
            this.myCtrlIp1 = aCtrlIp1;
            this.myCtrlIp2 = aCtrlIp2;
        }

        boolean isMyDisk(DirectAccessDeviceImpl aDisk) {
            return Util.equalsWithNull((Object)this.myWwnEntityName, (Object)aDisk.getEntityNameValue());
        }

        boolean isEquivalent(String aRaidName, SrEntityNameFormat aWwnEntityName, SrIpAddress aCtrlIp1, SrIpAddress aCtrlIp2) {
            return Util.equalsWithNull((Object)this.myWwnEntityName, (Object)aWwnEntityName) || Util.equalsWithNull((Object)this.myCtrlIp1, (Object)aCtrlIp1) && Util.equalsWithNull((Object)this.myCtrlIp2, (Object)aCtrlIp2);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RAID[");
            if (this.myName != null) {
                sb.append(this.myName).append(',');
            }
            sb.append(this.myWwnEntityName.toHexStringFormat()).append(',');
            if (this.myCtrlIp1 != null) {
                sb.append(this.myCtrlIp1).append(',');
            }
            if (this.myCtrlIp2 != null) {
                sb.append(this.myCtrlIp2);
            }
            sb.append(']');
            return sb.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o != null) {
                return this.toString().equals(o.toString());
            }
            return false;
        }
    }
}

