/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.policies;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.policies.PeriodicPolicy;
import com.sanrad.nms.server.logic.policies.PolicyImpl;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.nms.server.util.types.constants.UnitsConstant;
import java.rmi.RemoteException;

public class PeriodicPolicyImpl
extends PolicyImpl
implements PeriodicPolicy {
    private static SrLogger theLogger = SrLogger.getLogger();
    private Long period = null;

    public PeriodicPolicyImpl() throws RemoteException {
    }

    public PeriodicPolicyImpl(Long startAt, Long period) throws RemoteException {
        super(startAt);
        this.period = period;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    @Override
    public PolicyTypeConstant getType() throws RemoteException {
        return PolicyTypeConstant.REPLICATE_PERIODIC;
    }

    @Override
    public Object getValue() throws RemoteException {
        return this.period;
    }

    @Override
    public UnitsConstant getUnits() throws RemoteException {
        return UnitsConstant.Minutes;
    }

    @Override
    public void update(Long startAt, Integer param1, Integer param2) {
        this.period = new Long(param1 * 60 + param2);
        this.setStartAt(startAt);
    }

    public String toString() {
        StringBuffer toStringValue = new StringBuffer("PeriodicPolicy: ");
        toStringValue.append("period = " + this.period + " startAt = " + this.getStartAt() + "\n");
        return toStringValue.toString();
    }

    public boolean equals(Object compareTo) {
        try {
            if (compareTo instanceof PeriodicPolicyImpl) {
                return this.period.intValue() == ((Long)((PeriodicPolicyImpl)compareTo).getValue()).intValue();
            }
            return false;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.period.intValue() + this.getStartAt().intValue() * 10;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
    }
}

