/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceValidator;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class SubDirectAccessDeviceCreateValidator
extends SubDirectAccessDeviceValidator {
    public SubDirectAccessDeviceCreateValidator(DirectAccessDeviceImpl parent, String alias, BigInteger startAddr, BigInteger size, ClusterImpl cluster) {
        super(parent, alias, startAddr, size, cluster);
    }

    @Override
    public boolean isValid() throws RemoteException {
        if (super.isValid()) {
            DirectAccessDeviceImpl device = this.cluster.getStoragePool().getSubDirectAccessDevice(this.alias);
            if (device != null) {
                String[] msgParts = new String[]{this.alias, device.getAlias()};
                this.setErrorMsg(ErrorMessage.SUB_DISK_ALIAS_ALREADY_IN_USE.getMessage(msgParts));
                return false;
            }
            BigInteger parentEndAddress = this.parent.getEndAddress();
            if (this.startAddr.compareTo(parentEndAddress) != -1 && parentEndAddress.compareTo(new BigInteger("-1")) != 0) {
                String[] msgParts = new String[]{"0x" + this.startAddr.toString(16).toUpperCase(), "0x" + this.parent.getEndAddress().toString(16).toUpperCase(), this.parent.getAlias()};
                this.setErrorMsg(ErrorMessage.START_ADDR_IS_TOO_BIG.getMessage(msgParts));
                return false;
            }
            SubDirectAccessDevice subDirectAccessDevice = this.parent.isStartAddressOccupied(this.startAddr);
            if (subDirectAccessDevice != null) {
                String[] msgParts = new String[]{"0x" + this.startAddr.toString(16).toUpperCase(), subDirectAccessDevice.getAlias()};
                this.setErrorMsg(ErrorMessage.START_ADDR_IS_OCCUPIED.getMessage(msgParts));
                return false;
            }
            if (!this.parent.isStartAddressCompatible(this.startAddr, this.size)) {
                String[] msgParts = new String[]{"0x" + this.startAddr.toString(16).toUpperCase(), this.size + " Bytes"};
                this.setErrorMsg(ErrorMessage.START_ADDR_IS_INCOMPATIBLE.getMessage(msgParts));
                return false;
            }
            VolumeImpl volParent = this.parent.getParentVolume();
            if (volParent != null) {
                String[] msgBody = new String[]{this.parent.getAlias(), ((Volume)volParent).getClassId() + " " + volParent.getAlias()};
                this.setErrorMsg(ErrorMessage.DISK_HAS_VOLUME_CANNOT_CREATE_SUB_DISK.getMessage(msgBody));
                return false;
            }
            return true;
        }
        return false;
    }
}

