/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.physstorage.BestFitSpaceComparator;
import com.sanrad.nms.server.logic.physstorage.FirstFitSpaceComparator;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceImpl;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

class StorageSpaceManager {
    private Vector<StorageSpaceImpl> occupiedSpace = new Vector();
    private BigInteger totalSize;
    private BigInteger blockSize;
    private boolean isProvisioned;
    private static SrLogger theLogger = SrLogger.getLogger();

    public StorageSpaceManager(BigInteger totalSize, int blockSize, boolean isProvisioned) {
        this.totalSize = totalSize;
        this.blockSize = new BigInteger(Integer.toString(blockSize));
        this.isProvisioned = isProvisioned;
    }

    void setTotalSize(BigInteger totalSize) {
        this.totalSize = totalSize;
    }

    void setBlockSize(int blockSize) {
        this.blockSize = new BigInteger(Integer.toString(blockSize));
    }

    void setProvisioned(boolean isProvisioned) {
        this.isProvisioned = isProvisioned;
    }

    public void addOccupiedSpace(BigInteger startAddr, BigInteger size) throws RemoteException {
        StorageSpaceImpl storageSpace = new StorageSpaceImpl(startAddr, size, false);
        this.occupiedSpace.addElement(storageSpace);
    }

    private static void addIfFree(List<StorageSpaceImpl> freeSpace, BigInteger addr1, BigInteger addr2) {
        BigInteger sizeFree;
        if (addr1 != null && addr2 != null && (sizeFree = addr2.subtract(addr1)).compareTo(BigInteger.ZERO) > 0) {
            try {
                StorageSpaceImpl free = new StorageSpaceImpl(addr1, sizeFree, true);
                freeSpace.add(free);
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.EXCEPTION, new Object[]{"RemoteException in StorageSpaceManager.addIfFree: ", e});
                throw new IllegalStateException("RemoteException in StorageSpaceManager.addIfFree: ", e);
            }
        }
    }

    public List<StorageSpaceImpl> getFreeSpaceList() {
        ArrayList<StorageSpaceImpl> freeSpace = new ArrayList<StorageSpaceImpl>();
        if (this.occupiedSpace.size() > 0) {
            ArrayList<StorageSpaceImpl> itrList = new ArrayList<StorageSpaceImpl>();
            Collections.sort(this.occupiedSpace, new FirstFitSpaceComparator());
            itrList.addAll(this.occupiedSpace);
            BigInteger addr1 = BigInteger.ZERO;
            for (StorageSpaceImpl occupied : itrList) {
                StorageSpaceManager.addIfFree(freeSpace, addr1, occupied.getStartAddress());
                addr1 = occupied.getStartAddress().add(occupied.getSize());
            }
            StorageSpaceImpl occupied = (StorageSpaceImpl)itrList.get(itrList.size() - 1);
            StorageSpaceManager.addIfFree(freeSpace, occupied.getStartAddress().add(occupied.getSize()), this.totalSize);
        } else {
            StorageSpaceManager.addIfFree(freeSpace, BigInteger.ZERO, this.totalSize);
        }
        return freeSpace;
    }

    private int getStorageSpaceIndex(BigInteger startAddr, BigInteger size) {
        for (int i = 0; i < this.occupiedSpace.size(); ++i) {
            StorageSpaceImpl storageSpace = this.occupiedSpace.elementAt(i);
            if (!storageSpace.getStartAddress().equals(startAddr) || !storageSpace.getSize().equals(size)) continue;
            return i;
        }
        return -1;
    }

    public void removeOccupiedSpace(BigInteger startAddr, BigInteger size) {
        int index = this.getStorageSpaceIndex(startAddr, size);
        if (index > -1) {
            this.occupiedSpace.removeElementAt(index);
        }
    }

    public boolean isStartAddressCompatible(BigInteger startAddr, BigInteger size) {
        List<StorageSpaceImpl> freeSpace = this.getFreeSpaceList();
        Collections.sort(freeSpace, new FirstFitSpaceComparator());
        if (freeSpace.size() > 0) {
            for (StorageSpaceImpl storageSpace : freeSpace) {
                BigInteger endAddr = storageSpace.getStartAddress().add(storageSpace.getSize().subtract(this.blockSize));
                if (storageSpace.getStartAddress().compareTo(startAddr) == 1 || endAddr.compareTo(startAddr) != 1 || endAddr.compareTo(startAddr.add(size).subtract(this.blockSize)) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFit(StorageSpaceImpl storageFreeSpace, BigInteger size) {
        return storageFreeSpace.getSize().compareTo(size) >= 0;
    }

    private BigInteger getStartAddress(List<StorageSpaceImpl> freeSpace, BigInteger size) {
        if (freeSpace.size() > 0) {
            for (StorageSpaceImpl storageSpace : freeSpace) {
                if (!this.isFit(storageSpace, size)) continue;
                return storageSpace.getStartAddress();
            }
        }
        if (this.isProvisioned) {
            if (!this.occupiedSpace.isEmpty()) {
                StorageSpaceImpl lastSplit = this.occupiedSpace.lastElement();
                return lastSplit.getStartAddress().add(lastSplit.getSize());
            }
            return BigInteger.ZERO;
        }
        return null;
    }

    public BigInteger getFirstFitStartAddress(BigInteger size) {
        List<StorageSpaceImpl> freeSpace = this.getFreeSpaceList();
        Collections.sort(freeSpace, new FirstFitSpaceComparator());
        return this.getStartAddress(freeSpace, size);
    }

    public BigInteger getBestFitStartAddress(BigInteger size) {
        List<StorageSpaceImpl> freeSpace = this.getFreeSpaceList();
        Collections.sort(freeSpace, new BestFitSpaceComparator());
        return this.getStartAddress(freeSpace, size);
    }

    public BigInteger getLastAvailableSpaceSize() {
        List<StorageSpaceImpl> freeSpace = this.getFreeSpaceList();
        if (freeSpace.isEmpty()) {
            return BigInteger.ZERO;
        }
        StorageSpaceImpl lastSpace = freeSpace.get(freeSpace.size() - 1);
        return lastSpace.getSize();
    }
}

