/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.logic.physstorage.StorageSpace;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.util.virtualization.Allocable;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class StorageSpaceImpl
extends RemoteObjectImpl
implements StorageSpace,
Allocable {
    private BigInteger startAddr;
    private BigInteger size;
    private boolean free;
    private static SrLogger theLogger = SrLogger.getLogger();

    public StorageSpaceImpl(BigInteger startAddr, BigInteger size, boolean free) throws RemoteException {
        this.startAddr = startAddr;
        this.size = size;
        this.free = free;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StorageSpace) || obj instanceof SubDirectAccessDevice) {
            return false;
        }
        try {
            return ((StorageSpace)obj).getStartAddress().equals(this.startAddr) && ((StorageSpace)obj).getSize().equals(this.size);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            return false;
        }
    }

    @Override
    public BigInteger getStartAddress() {
        return this.startAddr;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    public boolean isSpaceFree() {
        return this.free;
    }

    public String toString() {
        return "(" + this.getStartAddress() + ", " + this.getSize() + ")";
    }

    public BigInteger getAllocationSpace() {
        if (!this.isSpaceFree()) {
            return BigInteger.ZERO;
        }
        return this.getSize();
    }
}

