/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.LUIdentifier;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LUIdentifierImpl
extends SynchronizeableImpl
implements LUIdentifier,
Comparable {
    private GeneralSCSIDeviceImpl deviceParent = null;
    private BigInteger codeSet = null;
    private BigInteger association = null;
    private BigInteger type = null;
    private String value = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public LUIdentifierImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.LU_IDENTIFIER, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.value = this.getValue();
        if (this.value != null) {
            this.toStringValue = this.value.toString();
        }
        this.codeSet = this.getCodeSet();
        this.association = this.getAssociation();
        this.type = this.getType();
        CommKeyClassId commKeyClassId = (CommKeyClassId)aCED.getValue((ParameterCodes)ParameterCode.SCSI_DEVICE_ID);
        if (commKeyClassId != null) {
            this.deviceParent = (GeneralSCSIDeviceImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(commKeyClassId);
            if (this.deviceParent == null) {
                String message = ClassID.GENERAL_SCSI_DEVICE + " parent not found for " + this.getClassId() + " " + this.toString();
                theLogger.fatal(SrLogCategories.LEGACY, new Object[]{"Snmp Configuration Error: ", message});
                ElementEventImpl elementEvent = new ElementEventImpl((Object)this, this);
                elementEvent.setErrorMesaage(message);
                LogicMgrAOImpl.getInstance().__fatalConfigurationError(elementEvent);
            }
        }
        return changedValues;
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public BigInteger getCodeSet() {
        return (BigInteger)this.getValueOf(ParameterCode.LU_ID_CODE_SET);
    }

    public BigInteger getAssociation() {
        return (BigInteger)this.getValueOf(ParameterCode.LU_ID_ASSOC);
    }

    public BigInteger getType() {
        return (BigInteger)this.getValueOf(ParameterCode.LU_ID_TYPE);
    }

    public String getValue() {
        return (String)this.getValueOf(ParameterCode.LU_ID_VALUE);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LUIdentifier) {
            LUIdentifierImpl luId = (LUIdentifierImpl)obj;
            return this.codeSet.equals(luId.codeSet) && this.association.equals(luId.association) && this.type.equals(luId.type) && this.value.equals(luId.value);
        }
        return false;
    }

    public boolean isEqual(HashMap parameterList) throws RemoteException {
        BigInteger thisCodeSet = this.getCodeSet();
        BigInteger thisAssociation = this.getAssociation();
        BigInteger thisType = this.getType();
        String thisValue = this.getValue();
        if (thisCodeSet != null && thisAssociation != null && thisType != null && thisValue != null) {
            Object codeSet = parameterList.get(ParameterCode.LU_ID_CODE_SET);
            Object association = parameterList.get(ParameterCode.LU_ID_ASSOC);
            Object type = parameterList.get(ParameterCode.LU_ID_TYPE);
            Object value = parameterList.get(ParameterCode.LU_ID_VALUE);
            return codeSet.equals(thisCodeSet) && association.equals(thisAssociation) && type.equals(thisType) && value.equals(thisValue);
        }
        return false;
    }

    public int compareTo(Object obj) {
        LUIdentifierImpl luId = (LUIdentifierImpl)obj;
        int result = this.getAssociation().compareTo(luId.getAssociation());
        if (result != 0) {
            return result;
        }
        result = this.getCodeSet().compareTo(luId.getCodeSet());
        if (result != 0) {
            return result;
        }
        result = this.getType().compareTo(luId.getType());
        if (result != 0) {
            return result;
        }
        return this.getValue().compareTo(luId.getValue());
    }

    public GeneralSCSIDevice getSCSIDeviceParent() {
        return this.deviceParent;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        return 0;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public String getAlias(VSwitchImpl inSwitch) {
        return null;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.LU_ID_CODE_SET, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_ID_ASSOC, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_ID_TYPE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_ID_VALUE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SCSI_DEVICE_ID, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

