/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.storage.StoragePool;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import java.rmi.RemoteException;

abstract class GeneralSCSIDeviceValidator
extends AliasObjectValidator {
    private static final int MAX_SERIAL_NUM_LENGTH = 254;
    private TargetList targetList;
    protected String alias;
    private SrEntityNameFormat entityName;
    private int lun;
    private String serialNumber;

    public GeneralSCSIDeviceValidator(ClusterImpl cluster, TargetList targetList, PhysicalStorageTypeConstant type, String alias, SrEntityNameFormat entityName, int lun, String serialNumber) {
        super(alias);
        this.targetList = targetList;
        this.alias = alias;
        this.entityName = entityName;
        this.lun = lun;
        this.serialNumber = serialNumber;
        this.cluster = cluster;
    }

    @Override
    public boolean isValid() throws RemoteException {
        int serialNumberLen;
        if (this.alias == null || this.alias.length() == 0) {
            this.setErrorMsg("Alias is mandatory");
            return false;
        }
        if (!super.isValid()) {
            return false;
        }
        StoragePool storagePool = this.cluster.getStoragePool();
        if (storagePool.isSCSIDeviceAliasExist(this.alias)) {
            this.setErrorMsg("Alias " + this.alias + " already exists in cluster " + this.cluster.getAlias() + ". Please select another alias");
            return false;
        }
        if (storagePool.getStoragesByEntityNameAndLUN(this.getEntityName(), this.lun) != null) {
            this.setErrorMsg("Target name/LUN already exist in cluster. Please select another target name and/or LUN");
            return false;
        }
        String targetName = new String(this.entityName.getBytes());
        ISCSITargetImpl target = this.targetList.getTargetByName(targetName);
        if (target != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Target name ");
            sb.append(targetName);
            sb.append(" already exists");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.lun < 0 || this.lun > LUImpl.MAX_LUN_VALUE) {
            StringBuffer sb = new StringBuffer();
            sb.append("Illegal LUN value (0 - ");
            sb.append(LUImpl.MAX_LUN_VALUE);
            sb.append(")");
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.serialNumber != null && (serialNumberLen = this.serialNumber.length()) > 254) {
            StringBuffer sb = new StringBuffer();
            sb.append("Serial Number length is too big: maximal length is ");
            sb.append(254);
            this.setErrorMsg(sb.toString());
            return false;
        }
        return true;
    }

    protected abstract String getEntityName();
}

