/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceValidator;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import java.rmi.RemoteException;

public class GeneralFiberChannelDeviceValidator
extends GeneralSCSIDeviceValidator {
    private static final int FC_ENTITY_NAME_LENGTH = 8;
    private byte[] entityName;

    public GeneralFiberChannelDeviceValidator(ClusterImpl cluster, TargetList targetList, PhysicalStorageTypeConstant type, String alias, byte[] entityName, int lun, String serialNumber) {
        super(cluster, targetList, type, alias, new SrEntityNameFormat(entityName), lun, serialNumber);
        this.entityName = entityName;
    }

    protected boolean isEntityNameValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.entityName == null) {
            this.setErrorMsg("Target Name is mandatory");
            return false;
        }
        if (this.entityName.length != 8) {
            StringBuffer sb = new StringBuffer();
            sb.append("Illegal FiberChannel port ID (Should be ");
            sb.append(8);
            sb.append(" bytes)");
            this.setErrorMsg(sb.toString());
            return false;
        }
        return true;
    }

    @Override
    protected String getEntityName() {
        SrEntityNameFormat entityFormat = new SrEntityNameFormat(this.entityName);
        return entityFormat.toHexStringFormat();
    }
}

